/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.IllegalMessageIdentifierException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InvalidAcknowledgementException;
import java.util.List;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedData
@Description(value="Reliable Messaging Sequence")
public interface Sequence {
    public static final long UNSPECIFIED_MESSAGE_ID = 0L;
    public static final long MIN_MESSAGE_ID = 1L;
    public static final long MAX_MESSAGE_ID = Long.MAX_VALUE;
    public static final long NO_EXPIRY = -1L;

    @ManagedAttribute
    @Description(value="Unique sequence identifier")
    public String getId();

    @ManagedAttribute
    @Description(value="Last message identifier register on this sequence")
    public long getLastMessageNumber();

    public void registerMessage(@NotNull ApplicationMessage var1, boolean var2) throws DuplicateMessageRegistrationException, AbstractSoapFaultException;

    @Nullable
    public ApplicationMessage retrieveMessage(@NotNull String var1);

    public DeliveryQueue getDeliveryQueue();

    public void acknowledgeMessageNumbers(List<AckRange> var1) throws InvalidAcknowledgementException, AbstractSoapFaultException;

    public void acknowledgeMessageNumber(long var1) throws IllegalMessageIdentifierException, AbstractSoapFaultException;

    public List<AckRange> getAcknowledgedMessageNumbers();

    @ManagedAttribute
    @Description(value="True if the sequence has unacknowledged message identifiers")
    public boolean hasUnacknowledgedMessages();

    @ManagedAttribute
    @Description(value="Runtime state of the sequence")
    public State getState();

    public void setAckRequestedFlag();

    public void clearAckRequestedFlag();

    @ManagedAttribute
    @Description(value="True if AckRequested flag set")
    public boolean isAckRequested();

    public void updateLastAcknowledgementRequestTime();

    public boolean isStandaloneAcknowledgementRequestSchedulable(long var1);

    @ManagedAttribute
    @Description(value="The security token reference identifier to which this sequence is bound")
    public String getBoundSecurityTokenReferenceId();

    public void close();

    @ManagedAttribute
    @Description(value="True if the sequence has been closed")
    public boolean isClosed();

    @ManagedAttribute
    @Description(value="True if the sequence has expired")
    public boolean isExpired();

    @ManagedAttribute
    @Description(value="Last activity time on the sequence in milliseconds")
    public long getLastActivityTime();

    public void preDestroy();

    public static class AckRange {
        public final long lower;
        public final long upper;

        public AckRange(long lower, long upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncompleteSequenceBehavior {
        NO_DISCARD,
        DISCARD_ENTIRE_SEQUENCE,
        DISCARD_FOLLOWING_FIRST_GAP;


        public static IncompleteSequenceBehavior getDefault() {
            return NO_DISCARD;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CREATED(15),
        CLOSING(20),
        CLOSED(25),
        TERMINATING(30);

        private int value;

        private State(int value) {
            this.value = value;
        }

        public int asInt() {
            return this.value;
        }

        public static State asState(int value) {
            for (State status : State.values()) {
                if (status.value != value) continue;
                return status;
            }
            return null;
        }
    }
}

