/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.IllegalMessageIdentifierException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InboundSequence
extends AbstractSequence {
    public static final long INITIAL_LAST_MESSAGE_ID = 0L;
    private static final Logger LOGGER = Logger.getLogger(InboundSequence.class);

    public InboundSequence(SequenceData data, DeliveryQueueBuilder deliveryQueueBuilder, TimeSynchronizer timeSynchronizer) {
        super(data, deliveryQueueBuilder, timeSynchronizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessage(ApplicationMessage message, boolean storeMessageFlag) throws DuplicateMessageRegistrationException, IllegalStateException {
        this.checkSequenceCreatedStatus("Cannot register message: This sequence is not in ready to accept messages.", AbstractSoapFaultException.Code.Receiver);
        if (!this.getId().equals(message.getSequenceId())) {
            throw (IllegalArgumentException)LOGGER.logSevereException((Throwable)new IllegalArgumentException(String.format("Cannot register message: sequence identifier on the application message [ %s ] is different from the identifier of this sequence [ %s ].", message.getSequenceId(), this.getId())));
        }
        try {
            this.data.lockWrite();
            if (message.getMessageNumber() > this.data.getLastMessageNumber()) {
                for (long lostIdentifier = this.data.getLastMessageNumber() + 1L; lostIdentifier <= message.getMessageNumber(); ++lostIdentifier) {
                    this.data.registerUnackedMessageNumber(lostIdentifier, false);
                }
                this.data.setLastMessageNumber(message.getMessageNumber());
            }
            this.data.registerUnackedMessageNumber(message.getMessageNumber(), true);
            if (storeMessageFlag) {
                this.data.attachMessageToUnackedMessageNumber(message);
            }
        }
        finally {
            this.data.unlockWrite();
        }
    }

    @Override
    public void acknowledgeMessageNumbers(List<Sequence.AckRange> ranges) {
        throw new UnsupportedOperationException(String.format("This operation is not supported on %s class", this.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeMessageNumber(long messageId) throws IllegalMessageIdentifierException, IllegalStateException {
        this.checkSequenceCreatedStatus(LocalizationMessages.WSRM_1135_WRONG_SEQUENCE_STATE_ACKNOWLEDGEMENT_REJECTED(this.getId(), (Object)this.getState()), AbstractSoapFaultException.Code.Receiver);
        try {
            this.data.lockWrite();
            this.data.markAsAcknowledged(messageId);
        }
        finally {
            this.data.unlockWrite();
        }
        this.getDeliveryQueue().onSequenceAcknowledgement();
    }
}

