/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceClosedException;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceTerminatedException;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequence
implements Sequence {
    protected final SequenceData data;
    private final DeliveryQueue deliveryQueue;
    private final TimeSynchronizer timeSynchronizer;

    AbstractSequence(@NotNull SequenceData data, @NotNull DeliveryQueueBuilder deliveryQueueBuilder, @NotNull TimeSynchronizer timeSynchronizer) {
        assert (data != null);
        assert (deliveryQueueBuilder != null);
        assert (timeSynchronizer != null);
        this.data = data;
        this.timeSynchronizer = timeSynchronizer;
        deliveryQueueBuilder.sequence(this);
        this.deliveryQueue = deliveryQueueBuilder.build();
    }

    @Override
    public String getId() {
        return this.data.getSequenceId();
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.data.getBoundSecurityTokenReferenceId();
    }

    @Override
    public long getLastMessageNumber() {
        return this.data.getLastMessageNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Sequence.AckRange> getAcknowledgedMessageNumbers() {
        long lastMessageNumber;
        Collection<Long> unackedMessageNumbers;
        this.data.lockRead();
        try {
            unackedMessageNumbers = this.data.getUnackedMessageNumbers();
            lastMessageNumber = this.data.getLastMessageNumber();
        }
        finally {
            this.data.unlockRead();
        }
        if (lastMessageNumber == 0L) {
            return Collections.emptyList();
        }
        if (unackedMessageNumbers.isEmpty()) {
            return Arrays.asList(new Sequence.AckRange(1L, lastMessageNumber));
        }
        LinkedList<Sequence.AckRange> result = new LinkedList<Sequence.AckRange>();
        long lastBottomAckRange = 1L;
        for (long lastUnacked : unackedMessageNumbers) {
            if (lastBottomAckRange < lastUnacked) {
                result.add(new Sequence.AckRange(lastBottomAckRange, lastUnacked - 1L));
            }
            lastBottomAckRange = lastUnacked + 1L;
        }
        if (lastBottomAckRange <= lastMessageNumber) {
            result.add(new Sequence.AckRange(lastBottomAckRange, lastMessageNumber));
        }
        return result;
    }

    @Override
    public boolean hasUnacknowledgedMessages() {
        return !this.data.getUnackedMessageNumbers().isEmpty();
    }

    @Override
    public Sequence.State getState() {
        return this.data.getState();
    }

    public void setState(Sequence.State newState) {
        this.data.setState(newState);
    }

    @Override
    public void setAckRequestedFlag() {
        this.data.setAckRequestedFlag(true);
    }

    @Override
    public void clearAckRequestedFlag() {
        this.data.setAckRequestedFlag(false);
    }

    @Override
    public boolean isAckRequested() {
        return this.data.getAckRequestedFlag();
    }

    @Override
    public void updateLastAcknowledgementRequestTime() {
        this.data.setLastAcknowledgementRequestTime(this.timeSynchronizer.currentTimeInMillis());
    }

    @Override
    public long getLastActivityTime() {
        return this.data.getLastActivityTime();
    }

    public void updateLastActivityTime() {
        this.data.setLastActivityTime(this.timeSynchronizer.currentTimeInMillis());
    }

    @Override
    public boolean isStandaloneAcknowledgementRequestSchedulable(long delayPeriod) {
        return this.timeSynchronizer.currentTimeInMillis() - this.data.getLastAcknowledgementRequestTime() > delayPeriod && this.hasUnacknowledgedMessages();
    }

    @Override
    public void close() {
        this.data.setState(Sequence.State.CLOSED);
    }

    @Override
    public boolean isClosed() {
        Sequence.State currentStatus = this.data.getState();
        return currentStatus == Sequence.State.CLOSING || currentStatus == Sequence.State.CLOSED || currentStatus == Sequence.State.TERMINATING;
    }

    @Override
    public boolean isExpired() {
        return this.data.getExpirationTime() == -1L ? false : this.timeSynchronizer.currentTimeInMillis() < this.data.getExpirationTime();
    }

    @Override
    public void preDestroy() {
    }

    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        return this.data.retrieveMessage(correlationId);
    }

    @Override
    public DeliveryQueue getDeliveryQueue() {
        return this.deliveryQueue;
    }

    protected final void checkSequenceCreatedStatus(String message, AbstractSoapFaultException.Code code) throws AbstractSoapFaultException {
        switch (this.getState()) {
            case CLOSING: 
            case CLOSED: {
                throw new SequenceClosedException(message);
            }
            case TERMINATING: {
                throw new SequenceTerminatedException(message, code);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSequence other = (AbstractSequence)obj;
        return !(this.data.getSequenceId() == null ? other.data.getSequenceId() != null : !this.data.getSequenceId().equals(other.data.getSequenceId()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.data.getSequenceId() != null ? this.data.getSequenceId().hashCode() : 0);
        return hash;
    }
}

