/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import javax.xml.ws.EndpointReference;

public class CreateSequenceData {
    @NotNull
    private final EndpointReference acksToEpr;
    private final long expiry;
    @Nullable
    private final String offeredSequenceId;
    private final long offeredSequenceExpiry;
    @Nullable
    private final SecurityTokenReferenceType strType;

    public static Builder getBuilder(EndpointReference acksToEpr) {
        return new Builder(acksToEpr);
    }

    private CreateSequenceData(@NotNull EndpointReference acksToEpr, @Nullable long exipry, @Nullable String offeredSequenceId, @Nullable long offeredSequenceExpiry, @Nullable SecurityTokenReferenceType strType) {
        this.acksToEpr = acksToEpr;
        this.expiry = exipry;
        this.offeredSequenceId = offeredSequenceId;
        this.offeredSequenceExpiry = offeredSequenceExpiry;
        this.strType = strType;
    }

    @NotNull
    public EndpointReference getAcksToEpr() {
        return this.acksToEpr;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public boolean isNoExpiry() {
        return this.expiry == -1L;
    }

    @Nullable
    public String getOfferedSequenceId() {
        return this.offeredSequenceId;
    }

    public long getOfferedSequenceExpiry() {
        return this.offeredSequenceExpiry;
    }

    @Nullable
    public SecurityTokenReferenceType getStrType() {
        return this.strType;
    }

    public static class Builder {
        @NotNull
        private final EndpointReference acksToEpr;
        private long expiry;
        @Nullable
        private String offeredSequenceId;
        private long offeredSequenceExpiry;
        @Nullable
        private SecurityTokenReferenceType strType;

        private Builder(EndpointReference acksToEpr) {
            this.acksToEpr = acksToEpr;
            this.expiry = -1L;
            this.offeredSequenceExpiry = -1L;
        }

        public void expiry(long expiry) {
            this.expiry = expiry;
        }

        public void offeredSequenceExpiry(long offeredSequenceExpiry) {
            this.offeredSequenceExpiry = offeredSequenceExpiry;
        }

        public Builder offeredInboundSequenceId(String value) {
            this.offeredSequenceId = value;
            return this;
        }

        public Builder strType(SecurityTokenReferenceType value) {
            this.strType = value;
            return this;
        }

        public CreateSequenceData build() {
            return new CreateSequenceData(this.acksToEpr, this.expiry, this.offeredSequenceId, this.offeredSequenceExpiry, this.strType);
        }
    }
}

