/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons;

import com.sun.istack.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScheduledTaskManager {
    private static final Logger LOGGER = Logger.getLogger(ScheduledTaskManager.class);
    private static final long DELAY = 2000L;
    private static final long PERIOD = 100L;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Queue<ScheduledFuture<?>> scheduledTaskHandles = new ConcurrentLinkedQueue();

    public List<ScheduledFuture<?>> startTasks(Runnable ... tasks) {
        ArrayList handles = new ArrayList(tasks.length);
        for (Runnable task : tasks) {
            handles.add(this.startTask(task));
        }
        return handles;
    }

    public void stopAll() {
        ScheduledFuture<?> handle;
        while ((handle = this.scheduledTaskHandles.poll()) != null) {
            handle.cancel(false);
        }
        this.scheduler.shutdown();
    }

    public ScheduledFuture<?> startTask(Runnable task, long initialDelay, long period) {
        ScheduledFuture<?> taskHandle = this.scheduler.scheduleAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
        if (!this.scheduledTaskHandles.offer(taskHandle)) {
            LOGGER.warning(String.format("Unable to store handle for task of class [ %s ]", task.getClass().getName()));
        }
        return taskHandle;
    }

    public ScheduledFuture<?> startTask(Runnable task) {
        return this.startTask(task, 2000L, 100L);
    }
}

