/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.gmbal.GmbalException;
import org.glassfish.gmbal.generic.ClassAnalyzer;
import org.glassfish.gmbal.generic.DprintUtil;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.generic.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetAccessorImpl
implements FacetAccessor {
    private Object delegate;
    private Map<Class<?>, Object> facetMap = new HashMap();
    private DprintUtil dputil;

    public FacetAccessorImpl(Object delegate) {
        this.delegate = delegate;
        this.dputil = new DprintUtil(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T facet(Class<T> cls, boolean debug) {
        Object result = null;
        if (debug) {
            this.dputil.enter("facet", "cls=", cls);
        }
        try {
            if (cls.isInstance(this.delegate)) {
                result = this.delegate;
                if (debug) {
                    this.dputil.info("result is delegate");
                }
            } else {
                result = this.facetMap.get(cls);
                if (debug) {
                    this.dputil.info("result=", result);
                }
            }
            if (result == null) {
                T t = null;
                return t;
            }
            T t = cls.cast(result);
            return t;
        }
        finally {
            if (debug) {
                this.dputil.exit(result);
            }
        }
    }

    @Override
    public Collection<Object> facets() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.facetMap.values());
        result.add(this);
        return result;
    }

    @Override
    public <T> void addFacet(final T obj) {
        if (obj.getClass().isInstance(this.delegate)) {
            throw new IllegalArgumentException("Cannot add facet of supertype of this object");
        }
        ClassAnalyzer ca = new ClassAnalyzer(obj.getClass());
        ca.findClasses(new Predicate<Class>(){

            @Override
            public boolean evaluate(Class arg) {
                FacetAccessorImpl.this.facetMap.put(arg, obj);
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Method method, boolean debug, Object ... args) {
        if (debug) {
            this.dputil.enter("invoke", "method=", method, "args=", Arrays.asList(args));
        }
        Object result = null;
        try {
            Object target = this.facet(method.getDeclaringClass(), debug);
            if (target == null) {
                throw new IllegalArgumentException("No facet available for method " + method);
            }
            try {
                result = method.invoke(target, args);
            }
            catch (IllegalAccessException ex) {
                throw new GmbalException("Exception on invocation", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new GmbalException("Exception on invocation", ex);
            }
            catch (InvocationTargetException ex) {
                throw new GmbalException("Exception on invocation", ex);
            }
            if (!debug) return result;
        }
        catch (RuntimeException exc) {
            if (!debug) return result;
            this.dputil.exception("Exception in method invoke call", exc);
            return result;
        }
        finally {
            if (debug) {
                this.dputil.exit(result);
            }
        }
        this.dputil.exit(result);
        return result;
    }

    @Override
    public void removeFacet(Class<?> cls) {
        if (cls.isInstance(this.delegate)) {
            throw new IllegalArgumentException("Cannot add facet of supertype of this object");
        }
        ClassAnalyzer ca = new ClassAnalyzer(cls);
        ca.findClasses(new Predicate<Class>(){

            @Override
            public boolean evaluate(Class arg) {
                FacetAccessorImpl.this.facetMap.remove(arg);
                return false;
            }
        });
    }
}

