/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.AckRequestedElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.Identifier;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.SequenceAcknowledgementElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200702.SequenceElement;
import com.sun.xml.ws.rx.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rx.rm.runtime.Utilities;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class Rm11PacketAdapter
extends PacketAdapter {
    public Rm11PacketAdapter(@NotNull SOAPVersion soapVersion, @NotNull AddressingVersion addressingVersion, @NotNull Packet packet) {
        super(RmVersion.WSRM200702, soapVersion, addressingVersion, packet);
    }

    public void appendSequenceHeader(@NotNull String sequenceId, long messageNumber) throws RxRuntimeException {
        SequenceElement sequenceHeaderElement = new SequenceElement();
        sequenceHeaderElement.setNumber(messageNumber);
        sequenceHeaderElement.setId(sequenceId);
        this.appendHeader(sequenceHeaderElement);
    }

    public void appendAckRequestedHeader(@NotNull String sequenceId) throws RxRuntimeException {
        AckRequestedElement ackRequestedElement = new AckRequestedElement();
        ackRequestedElement.setId(sequenceId);
        this.appendHeader(ackRequestedElement);
    }

    public void appendSequenceAcknowledgementHeader(@NotNull Sequence sequence) throws RxRuntimeException {
        SequenceAcknowledgementElement ackElement = new SequenceAcknowledgementElement();
        Identifier identifier = new Identifier();
        identifier.setValue(sequence.getId());
        ackElement.setIdentifier(identifier);
        List<Sequence.AckRange> ackedMessageIds = sequence.getAcknowledgedMessageIds();
        sequence.clearAckRequestedFlag();
        if (ackedMessageIds != null && !ackedMessageIds.isEmpty()) {
            for (Sequence.AckRange range : ackedMessageIds) {
                ackElement.addAckRange(range.lower, range.upper);
            }
        } else {
            ackElement.addAckRange(0L, 0L);
        }
        if (sequence.isClosed()) {
            ackElement.setFinal(new SequenceAcknowledgementElement.Final());
        }
        this.appendHeader(ackElement);
    }

    void initSequenceHeaderData() throws RxRuntimeException {
        SequenceElement sequenceElement = (SequenceElement)this.readHeaderAsUnderstood(RmVersion.WSRM200702.namespaceUri, "Sequence");
        if (sequenceElement != null) {
            this.setSequenceData(sequenceElement.getId(), sequenceElement.getMessageNumber());
        }
    }

    String initAckRequestedHeaderData() throws RxRuntimeException {
        AckRequestedElement ackRequestedElement = (AckRequestedElement)this.readHeaderAsUnderstood(RmVersion.WSRM200702.namespaceUri, "AckRequested");
        return ackRequestedElement != null ? ackRequestedElement.getId() : null;
    }

    public void processAcknowledgements(SequenceManager sequenceManager, String expectedAckedSequenceId) throws RxRuntimeException {
        SequenceAcknowledgementElement ackElement = (SequenceAcknowledgementElement)this.readHeaderAsUnderstood(RmVersion.WSRM200702.namespaceUri, "SequenceAcknowledgement");
        if (ackElement != null) {
            if (expectedAckedSequenceId != null) {
                Utilities.assertSequenceId(expectedAckedSequenceId, ackElement.getId());
            }
            LinkedList<Sequence.AckRange> ranges = new LinkedList<Sequence.AckRange>();
            if (ackElement.getNone() == null) {
                if (!ackElement.getNack().isEmpty()) {
                    ArrayList<BigInteger> nacks = new ArrayList<BigInteger>(ackElement.getNack());
                    Collections.sort(nacks);
                    long lastLowerBound = 1L;
                    for (BigInteger nackId : nacks) {
                        if (lastLowerBound == nackId.longValue()) {
                            ++lastLowerBound;
                            continue;
                        }
                        ranges.add(new Sequence.AckRange(lastLowerBound, nackId.longValue() - 1L));
                        lastLowerBound = nackId.longValue() + 1L;
                    }
                    long lastMessageId = sequenceManager.getSequence(ackElement.getId()).getLastMessageId();
                    if (lastLowerBound <= lastMessageId) {
                        ranges.add(new Sequence.AckRange(lastLowerBound, lastMessageId));
                    }
                } else if (ackElement.getAcknowledgementRange() != null && !ackElement.getAcknowledgementRange().isEmpty()) {
                    for (SequenceAcknowledgementElement.AcknowledgementRange rangeElement : ackElement.getAcknowledgementRange()) {
                        ranges.add(new Sequence.AckRange(rangeElement.getLower().longValue(), rangeElement.getUpper().longValue()));
                    }
                }
            }
            sequenceManager.getSequence(ackElement.getId()).acknowledgeMessageIds(ranges);
        }
    }
}

