/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MessagePendingElement;
import com.sun.xml.ws.rx.mc.runtime.MakeConnectionSenderTask;
import com.sun.xml.ws.rx.util.TimestampedCollection;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractResponseHandler
implements Fiber.CompletionCallback {
    private static final Logger LOGGER = Logger.getLogger(AbstractResponseHandler.class);
    protected final RxConfiguration configuration;
    protected final MakeConnectionSenderTask mcSenderTask;
    private final TimestampedCollection<String, Fiber> suspendedFiberStorage;
    private String correlationId;

    protected AbstractResponseHandler(RxConfiguration configuration, MakeConnectionSenderTask mcSenderTask, TimestampedCollection<String, Fiber> suspendedFiberStorage, String correlationId) {
        this.configuration = configuration;
        this.mcSenderTask = mcSenderTask;
        this.suspendedFiberStorage = suspendedFiberStorage;
        this.correlationId = correlationId;
    }

    protected AbstractResponseHandler(RxConfiguration configuration, MakeConnectionSenderTask mcSenderTask, TimestampedCollection<String, Fiber> suspendedFiberStorage) {
        this.configuration = configuration;
        this.mcSenderTask = mcSenderTask;
        this.suspendedFiberStorage = suspendedFiberStorage;
        this.correlationId = null;
    }

    protected final void setCorrelationId(String newCorrelationId) {
        this.correlationId = newCorrelationId;
    }

    protected final Fiber getParentFiber() {
        return this.suspendedFiberStorage.remove(this.correlationId);
    }

    protected final void resumeParentFiber(Packet response) throws RxRuntimeException {
        Fiber parent = this.getParentFiber();
        if (parent == null) {
            throw LOGGER.logSevereException(new RxRuntimeException(String.format("No parent fiber found for correlationId [ %s ]. Unable to resume parent fiber with a response packet.", this.correlationId)));
        }
        parent.resume(response);
    }

    protected final void resumeParentFiber(Throwable error) throws RxRuntimeException {
        Fiber parent = this.getParentFiber();
        if (parent == null) {
            throw LOGGER.logSevereException(new RxRuntimeException(String.format("No parent fiber found for correlationId [ %s ]. Unable to resume parent fiber with a fiber-processing error. (Original fiber-processing error attached as a nested exception)", this.correlationId), error));
        }
        parent.resume(error);
    }

    protected final void processMakeConnectionHeaders(@NotNull Message responseMessage) throws RxRuntimeException {
        MessagePendingElement messagePendingHeader;
        assert (responseMessage != null);
        if (responseMessage.hasHeaders() && (messagePendingHeader = (MessagePendingElement)this.readHeaderAsUnderstood(responseMessage, this.configuration.getMcVersion().messagePendingHeaderName)) != null && messagePendingHeader.isPending().booleanValue()) {
            this.mcSenderTask.scheduleMcRequest();
        }
    }

    private final <T> T readHeaderAsUnderstood(Message message, QName headerName) throws RxRuntimeException {
        Header header = message.getHeaders().get(headerName, true);
        if (header == null) {
            return null;
        }
        try {
            Object result = header.readAsJAXB(this.configuration.getMcVersion().getUnmarshaller(this.configuration.getAddressingVersion()));
            return result;
        }
        catch (JAXBException ex) {
            throw LOGGER.logSevereException(new RxRuntimeException(String.format("Error unmarshalling header %s", headerName), ex));
        }
    }
}

