/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Codecs;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.assembler.ClientPipelineHook;
import com.sun.xml.ws.assembler.ServerPipelineHook;
import com.sun.xml.ws.assembler.TubeAppender;
import com.sun.xml.ws.assembler.TubelineAssemblyContextUpdater;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.encoding.LazyStreamCodec;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.util.ServiceConfigurationError;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.jaxws.impl.SecurityClientTube;
import com.sun.xml.wss.jaxws.impl.SecurityServerTube;
import com.sun.xml.wss.provider.wsit.ClientPipeCreator;
import com.sun.xml.wss.provider.wsit.JMACAuthConfigFactory;
import com.sun.xml.wss.provider.wsit.ServerPipeCreator;
import com.sun.xml.xwss.XWSSClientPipe;
import com.sun.xml.xwss.XWSSServerPipe;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTubeAppender
implements TubeAppender,
TubelineAssemblyContextUpdater {
    private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
    private static final String ENDPOINT = "ENDPOINT";
    private static final String NEXT_PIPE = "NEXT_PIPE";
    private static final String POLICY = "POLICY";
    private static final String SEI_MODEL = "SEI_MODEL";
    private static final String WSDL_MODEL = "WSDL_MODEL";
    private static final String GF_SERVER_SEC_PIPE = "com.sun.enterprise.webservice.CommonServerSecurityPipe";

    @Override
    public void prepareContext(WsitClientTubeAssemblyContext context) throws WebServiceException {
        if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            context.setCodec(this.createSecurityCodec(context.getBinding()));
        }
    }

    @Override
    public void prepareContext(WsitServerTubeAssemblyContext context) throws WebServiceException {
        if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            context.setCodec(this.createSecurityCodec(context.getEndpoint().getBinding()));
        }
    }

    @Override
    public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
        ServerPipelineHook[] hooks = this.getServerTubeLineHooks();
        ServerPipelineHook hook = null;
        if (hooks != null && hooks.length > 0 && hooks[0] instanceof ServerPipeCreator) {
            hook = hooks[0];
            this.initializeJMAC();
        } else {
            hook = context.getEndpoint().getContainer().getSPI(ServerPipelineHook.class);
        }
        if (hook != null) {
            Tube securityTube;
            Tube head = context.getTubelineHead();
            if (head == (securityTube = hook.createSecurityTube(context))) {
                Pipe securityPipe = hook.createSecurityPipe(context.getPolicyMap(), context.getSEIModel(), context.getWsdlPort(), context.getEndpoint(), context.getAdaptedTubelineHead());
                securityTube = PipeAdapter.adapt(securityPipe);
            }
            return securityTube;
        }
        if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            if (hooks != null && hooks.length == 0) {
                return this.createSecurityTube(context);
            }
            if (hooks != null && hooks.length > 0) {
                Tube securityTube;
                hook = hooks[0];
                Tube head = context.getTubelineHead();
                if (head == (securityTube = hook.createSecurityTube(context))) {
                    Pipe securityPipe = hook.createSecurityPipe(context.getPolicyMap(), context.getSEIModel(), context.getWsdlPort(), context.getEndpoint(), context.getAdaptedTubelineHead());
                    securityTube = PipeAdapter.adapt(securityPipe);
                }
                return securityTube;
            }
            return new SecurityServerTube(context, context.getTubelineHead());
        }
        try {
            if (!context.isPolicyAvailable() && this.isSecurityConfigPresent(context)) {
                return this.initializeXWSSServerTube(context);
            }
        }
        catch (NoClassDefFoundError err) {
            // empty catch block
        }
        return context.getTubelineHead();
    }

    @Override
    public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
        ClientPipelineHook hook = null;
        ClientPipelineHook[] hooks = this.getClientTublineHooks(context);
        if (hooks != null && hooks.length > 0) {
            for (ClientPipelineHook h : hooks) {
                if (!(h instanceof ClientPipeCreator)) continue;
                hook = h;
                this.initializeJMAC();
                break;
            }
        }
        if (hook == null) {
            hook = context.getContainer().getSPI(ClientPipelineHook.class);
        }
        if (hook != null) {
            Tube securityTube;
            Tube head = context.getTubelineHead();
            if (head == (securityTube = hook.createSecurityTube(context))) {
                ClientPipeAssemblerContext pipeContext = new ClientPipeAssemblerContext(context.getAddress(), context.getWsdlPort(), context.getService(), context.getBinding(), context.getContainer());
                Pipe securityPipe = hook.createSecurityPipe(context.getPolicyMap(), pipeContext, context.getAdaptedTubelineHead());
                if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
                    context.setScInitiator((SecureConversationInitiator)((Object)securityPipe));
                }
                securityTube = PipeAdapter.adapt(securityPipe);
            }
            return securityTube;
        }
        if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            SecurityClientTube securityTube = new SecurityClientTube(context, context.getTubelineHead());
            context.setScInitiator(securityTube);
            return securityTube;
        }
        if (!context.isPolicyAvailable() && this.isSecurityConfigPresent(context)) {
            return this.initializeXWSSClientTube(context);
        }
        return context.getTubelineHead();
    }

    private ClientPipelineHook[] getClientTublineHooks(WsitClientTubeAssemblyContext context) {
        try {
            ClientPipelineHook[] hooks = SecurityTubeAppender.loadSPs(ClientPipelineHook.class);
            if (hooks != null && hooks.length > 0) {
                return hooks;
            }
        }
        catch (ServiceConfigurationError ex) {
            if (ex.getCause() instanceof InstantiationException) {
                return new ClientPipelineHook[0];
            }
            return null;
        }
        return null;
    }

    private boolean isSecurityEnabled(PolicyMap policyMap, WSDLPort wsdlPort) {
        if (policyMap == null || wsdlPort == null) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY200512.namespaceUri))) {
                return true;
            }
            for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                policy = policyMap.getOperationEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getInputMessageEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getOutputMessageEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getFaultMessageEffectivePolicy(operationKey);
                if (policy == null || !policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) && !policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri)) continue;
                return true;
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException(e);
        }
        return false;
    }

    private Codec createSecurityCodec(WSBinding binding) {
        StreamSOAPCodec primaryCodec = Codecs.createSOAPEnvelopeXmlCodec(binding.getSOAPVersion());
        LazyStreamCodec lsc = new LazyStreamCodec(primaryCodec);
        return Codecs.createSOAPBindingCodec(binding, lsc);
    }

    private static <P> P[] loadSPs(Class<P> svcClass) {
        return ServiceFinder.find(svcClass).toArray();
    }

    private ServerPipelineHook[] getServerTubeLineHooks() {
        try {
            ServerPipelineHook[] hooks = SecurityTubeAppender.loadSPs(ServerPipelineHook.class);
            if (hooks != null && hooks.length > 0) {
                return hooks;
            }
        }
        catch (ServiceConfigurationError ex) {
            if (ex.getCause() instanceof InstantiationException) {
                return new ServerPipelineHook[0];
            }
            return null;
        }
        return null;
    }

    private boolean isSecurityConfigPresent(WsitClientTubeAssemblyContext context) {
        return true;
    }

    private boolean isSecurityConfigPresent(WsitServerTubeAssemblyContext context) {
        QName serviceQName = context.getEndpoint().getServiceName();
        String serviceLocalName = serviceQName.getLocalPart();
        Container container = context.getEndpoint().getContainer();
        Object ctxt = null;
        if (container != null) {
            try {
                Class<?> contextClass = Class.forName(SERVLET_CONTEXT_CLASSNAME);
                ctxt = container.getSPI(contextClass);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        String serverName = "server";
        if (ctxt != null) {
            String serverConfig = "/WEB-INF/" + serverName + "_" + "security_config.xml";
            URL url = SecurityUtil.loadFromContext(serverConfig, ctxt);
            if (url == null) {
                serverConfig = "/WEB-INF/" + serviceLocalName + "_" + "security_config.xml";
                url = SecurityUtil.loadFromContext(serverConfig, ctxt);
            }
            if (url != null) {
                return true;
            }
        } else {
            String serverConfig = "META-INF/" + serverName + "_" + "security_config.xml";
            URL url = SecurityUtil.loadFromClasspath(serverConfig);
            if (url == null) {
                serverConfig = "META-INF/" + serviceLocalName + "_" + "security_config.xml";
                url = SecurityUtil.loadFromClasspath(serverConfig);
            }
            if (url != null) {
                return true;
            }
        }
        return false;
    }

    private Tube initializeXWSSClientTube(WsitClientTubeAssemblyContext context) {
        return PipeAdapter.adapt(new XWSSClientPipe(context.getWsdlPort(), context.getService(), context.getBinding(), context.getAdaptedTubelineHead()));
    }

    private Tube initializeXWSSServerTube(WsitServerTubeAssemblyContext context) {
        return PipeAdapter.adapt(new XWSSServerPipe(context.getEndpoint(), context.getWsdlPort(), context.getAdaptedTubelineHead()));
    }

    private Tube createSecurityTube(WsitServerTubeAssemblyContext context) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(POLICY, context.getPolicyMap());
        props.put(SEI_MODEL, context.getSEIModel());
        props.put(WSDL_MODEL, context.getWsdlPort());
        props.put(ENDPOINT, context.getEndpoint());
        props.put(NEXT_PIPE, context.getAdaptedTubelineHead());
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> gfServerPipeClass = null;
            gfServerPipeClass = loader != null ? loader.loadClass(GF_SERVER_SEC_PIPE) : Class.forName(GF_SERVER_SEC_PIPE);
            if (gfServerPipeClass != null) {
                Class<?>[] paramTypes;
                Constructor<?>[] ctors = gfServerPipeClass.getDeclaredConstructors();
                Constructor<?> ctor = null;
                for (int i = 0; i < ctors.length && !(paramTypes = (ctor = ctors[i]).getParameterTypes())[0].equals(Map.class); ++i) {
                }
                if (ctor != null) {
                    return PipeAdapter.adapt((Pipe)ctor.newInstance(props, context.getAdaptedTubelineHead(), false));
                }
            }
            return context.getTubelineHead();
        }
        catch (InstantiationException ex) {
            throw new WebServiceException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new WebServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new WebServiceException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new WebServiceException(ex);
        }
        catch (SecurityException ex) {
            throw new WebServiceException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new WebServiceException(ex);
        }
    }

    private void initializeJMAC() {
        final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AuthConfigFactory factory = AuthConfigFactory.getFactory();
                if (factory == null || !(factory instanceof JMACAuthConfigFactory)) {
                    AuthConfigFactory.setFactory((AuthConfigFactory)new JMACAuthConfigFactory(loader));
                }
                return null;
            }
        });
    }
}

