/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.message.GSHeaderElement;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.keyinfo.KeyIdentifierStrategy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.assertion.saml11.jaxb10.Assertion;
import java.util.HashMap;
import org.w3c.dom.Element;

public class ExportSamlAssertionFilter {
    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        boolean isOptimized = false;
        SecurableSoapMessage secureMessage = null;
        com.sun.xml.wss.core.SecurityHeader securityHeader = null;
        SecurityHeader optSecHeader = null;
        GSHeaderElement she = null;
        if (context instanceof JAXBFilterProcessingContext) {
            isOptimized = true;
            optSecHeader = ((JAXBFilterProcessingContext)context).getSecurityHeader();
        } else {
            secureMessage = context.getSecurableSoapMessage();
            securityHeader = secureMessage.findOrCreateSecurityHeader();
        }
        AuthenticationTokenPolicy policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.getFeatureBinding();
        if (samlPolicy.getIncludeToken() == AuthenticationTokenPolicy.SAMLAssertionBinding.INCLUDE_ONCE) {
            throw new XWSSecurityException("Include Token ONCE not supported for SAMLToken Assertions");
        }
        if (samlPolicy.getAssertionType() != "SV") {
            throw new XWSSecurityException("Internal Error: ExportSamlAssertionFilter called for HOK assertion");
        }
        samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.getFeatureBinding();
        samlPolicy.isReadOnly(true);
        DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
        dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
        dynamicContext.inBoundMessage(false);
        AuthenticationTokenPolicy.SAMLAssertionBinding resolvedPolicy = context.getSecurityEnvironment().populateSAMLPolicy(context.getExtraneousProperties(), samlPolicy, dynamicContext);
        com.sun.xml.wss.saml.Assertion _assertion = null;
        Element assertionElement = resolvedPolicy.getAssertion();
        Element _authorityBinding = resolvedPolicy.getAuthorityBinding();
        try {
            _assertion = System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null ? (assertionElement.getAttributeNode("ID") != null ? com.sun.xml.wss.saml.assertion.saml20.jaxb20.Assertion.fromElement(assertionElement) : com.sun.xml.wss.saml.assertion.saml11.jaxb20.Assertion.fromElement(assertionElement)) : Assertion.fromElement(assertionElement);
        }
        catch (SAMLException ex) {
            // empty catch block
        }
        if (samlPolicy.getIncludeToken() == AuthenticationTokenPolicy.SAMLAssertionBinding.INCLUDE_NEVER && _authorityBinding != null) {
            assertionElement = null;
        }
        if (_assertion == null && _authorityBinding == null) {
            throw new XWSSecurityException("None of SAML Assertion, SAML AuthorityBinding information was set into  the Policy by the CallbackHandler");
        }
        if (_assertion != null) {
            HashMap tokenCache;
            if (_assertion.getVersion() == null && _authorityBinding == null) {
                if (!isOptimized) {
                    if (System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null) {
                        ((com.sun.xml.wss.saml.assertion.saml11.jaxb20.Assertion)_assertion).toElement(securityHeader);
                    } else {
                        ((Assertion)_assertion).toElement(securityHeader);
                    }
                } else {
                    she = new GSHeaderElement(assertionElement, ((JAXBFilterProcessingContext)context).getSOAPVersion());
                    if (optSecHeader.getChildElement(she.getId()) == null) {
                        optSecHeader.add(she);
                    } else {
                        return;
                    }
                }
                tokenCache = context.getTokenCache();
                tokenCache.put(_assertion.getAssertionID(), _assertion);
            } else if (_assertion.getVersion() != null) {
                if (!isOptimized) {
                    ((com.sun.xml.wss.saml.assertion.saml20.jaxb20.Assertion)_assertion).toElement(securityHeader);
                } else {
                    she = new GSHeaderElement(assertionElement, ((JAXBFilterProcessingContext)context).getSOAPVersion());
                    if (optSecHeader.getChildElement(she.getId()) == null) {
                        optSecHeader.add(she);
                    } else {
                        return;
                    }
                }
                tokenCache = context.getTokenCache();
                tokenCache.put(_assertion.getID(), _assertion);
            } else if (null == resolvedPolicy.getSTRID()) {
                throw new XWSSecurityException("Unsupported configuration: required wsu:Id value  for SecurityTokenReference to Remote SAML Assertion not found  in Policy");
            }
        }
        if (null != resolvedPolicy.getSTRID()) {
            if (_assertion == null && null == resolvedPolicy.getAssertionId()) {
                throw new XWSSecurityException("None of SAML Assertion, SAML Assertion Id information was set into  the Policy by the CallbackHandler");
            }
            String assertionId = resolvedPolicy.getAssertionId();
            if (_assertion != null) {
                assertionId = _assertion.getAssertionID();
            }
            if (!isOptimized) {
                com.sun.xml.wss.core.SecurityTokenReference tokenRef = new com.sun.xml.wss.core.SecurityTokenReference(secureMessage.getSOAPPart());
                tokenRef.setWsuId(resolvedPolicy.getSTRID());
                if (_assertion.getVersion() != null) {
                    tokenRef.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                } else {
                    tokenRef.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                }
                if (_authorityBinding != null) {
                    tokenRef.setSamlAuthorityBinding(_authorityBinding, secureMessage.getSOAPPart());
                }
                KeyIdentifierStrategy strat = new KeyIdentifierStrategy(assertionId);
                strat.insertKey(tokenRef, context.getSecurableSoapMessage());
                securityHeader.insertHeaderBlock(tokenRef);
            } else {
                JAXBFilterProcessingContext optContext = (JAXBFilterProcessingContext)context;
                WSSElementFactory elementFactory = new WSSElementFactory(optContext.getSOAPVersion());
                KeyIdentifier ref = elementFactory.createKeyIdentifier();
                ref.setValue(assertionId);
                if (_assertion.getVersion() != null) {
                    ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
                } else {
                    ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                }
                SecurityTokenReference secTokRef = elementFactory.createSecurityTokenReference(ref);
                String strId = resolvedPolicy.getSTRID();
                secTokRef.setId(strId);
                if ("true".equals(optContext.getExtraneousProperty("EnableWSS11PolicySender"))) {
                    if (_assertion.getVersion() != null) {
                        secTokRef.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                    } else {
                        secTokRef.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                    }
                    ((NamespaceContextEx)optContext.getNamespaceContext()).addWSS11NS();
                }
                SSEData data = new SSEData(she, false, optContext.getNamespaceContext());
                optContext.getElementCache().put(strId, data);
                optSecHeader.add(secTokRef);
            }
        }
    }
}

