/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.webservice.member.at;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.developer.MemberSubmissionAddressing;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.developer.Stateful;
import com.sun.xml.ws.developer.StatefulWebServiceManager;
import com.sun.xml.ws.tx.at.ATCoordinator;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.CoordinationManager;
import com.sun.xml.ws.tx.webservice.member.at.CoordinatorPortType;
import com.sun.xml.ws.tx.webservice.member.at.Notification;
import java.util.logging.Level;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MemberSubmissionAddressing
@Stateful
@WebService(serviceName="WSATCoordinator", portName="Coordinator", endpointInterface="com.sun.xml.ws.tx.webservice.member.at.CoordinatorPortType", targetNamespace="http://schemas.xmlsoap.org/ws/2004/10/wsat", wsdlLocation="WEB-INF/wsdl/wsat.wsdl")
public class CoordinatorPortTypeImpl
implements CoordinatorPortType {
    public static final String serviceName = "WSATCoordinator";
    public static final String portName = "Coordinator";
    private static StatefulWebServiceManager<CoordinatorPortTypeImpl> manager;
    private String activityId;
    private String participantId;
    @Resource
    private WebServiceContext wsContext;
    private static final TxLogger logger;
    private ATCoordinator coordinator = null;
    private EndpointReference fallbackEPR = null;

    public CoordinatorPortTypeImpl() {
    }

    public CoordinatorPortTypeImpl(String activityId, String participantId) {
        this.activityId = activityId;
        this.participantId = participantId;
    }

    private void initContextFromIncomingMessage() {
        this.coordinator = (ATCoordinator)CoordinationManager.getInstance().getCoordinator(this.activityId);
        if (this.wsContext != null) {
            MessageContext mc = this.wsContext.getMessageContext();
            HeaderList hdrLst = (HeaderList)mc.get("com.sun.xml.ws.api.message.HeaderList");
            if (hdrLst != null) {
                this.fallbackEPR = hdrLst.getReplyTo(AddressingVersion.MEMBER, SOAPVersion.SOAP_11).toSpec(MemberSubmissionEndpointReference.class);
            }
        } else if (logger.isLogging(Level.WARNING)) {
            logger.warning("initContextFromIncomingMessage", "wsContext unexpectedly null");
        }
        if (this.activityId == "-1") {
            if (logger.isLogging(Level.INFO)) {
                logger.info("Atomic Transaction Coordinator", "handling notification for an unknown transaction");
            }
            this.coordinator = null;
        } else {
            this.coordinator = (ATCoordinator)CoordinationManager.getInstance().getCoordinator(this.activityId);
        }
    }

    @Override
    public void preparedOperation(Notification parameters) {
        String METHOD_NAME = "preparedOperation";
        this.initContextFromIncomingMessage();
        if (logger.isLogging(Level.FINER)) {
            logger.entering("preparedOperation", this.getCoordIdPartId());
        }
        if (this.coordinator != null) {
            this.coordinator.prepared(this.participantId);
        } else if (logger.isLogging(Level.SEVERE)) {
            logger.severe("preparedOperation", "unknown coordId or partId " + this.getCoordIdPartId());
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("preparedOperation", this.getCoordIdPartId());
        }
    }

    @Override
    public void abortedOperation(Notification parameters) {
        String METHOD_NAME = "abortedOperation";
        this.initContextFromIncomingMessage();
        if (logger.isLogging(Level.FINER)) {
            logger.entering("abortedOperation", this.getCoordIdPartId());
        }
        if (this.coordinator != null) {
            this.coordinator.aborted(this.participantId);
        } else if (logger.isLogging(Level.SEVERE)) {
            logger.severe("abortedOperation", "unknown coordId or partId " + this.getCoordIdPartId());
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("abortedOperation", this.getCoordIdPartId());
        }
    }

    @Override
    public void readOnlyOperation(Notification parameters) {
        String METHOD_NAME = "readonlyOperation";
        this.initContextFromIncomingMessage();
        if (logger.isLogging(Level.FINER)) {
            logger.entering("readonlyOperation", this.getCoordIdPartId());
        }
        if (this.coordinator != null) {
            this.coordinator.readonly(this.participantId);
        } else if (logger.isLogging(Level.SEVERE)) {
            logger.severe("readonlyOperation", "unknown coordId or partId " + this.getCoordIdPartId());
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("readonlyOperation", this.getCoordIdPartId());
        }
    }

    @Override
    public void committedOperation(Notification parameters) {
        String METHOD_NAME = "committedOperation";
        this.initContextFromIncomingMessage();
        if (logger.isLogging(Level.FINER)) {
            logger.entering("committedOperation", this.getCoordIdPartId());
        }
        if (this.coordinator != null) {
            this.coordinator.committed(this.participantId);
        } else if (logger.isLogging(Level.SEVERE)) {
            logger.severe("committedOperation", "unknown coordId or partId " + this.getCoordIdPartId());
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("committedOperation", this.getCoordIdPartId());
        }
    }

    @Override
    public void replayOperation(Notification parameters) {
        String METHOD_NAME = "replayOperation";
        this.initContextFromIncomingMessage();
        if (logger.isLogging(Level.FINER)) {
            logger.entering("replayOperation", this.getCoordIdPartId());
        }
        if (this.coordinator != null) {
            this.coordinator.replay(this.participantId);
        } else if (logger.isLogging(Level.SEVERE)) {
            logger.severe("replayOperation", "unknown coordId or partId " + this.getCoordIdPartId());
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("replayOperation", this.getCoordIdPartId());
        }
    }

    private String getCoordIdPartId() {
        return "CoorId=" + this.activityId + " PartId=" + this.participantId + " ";
    }

    public static StatefulWebServiceManager<CoordinatorPortTypeImpl> getManager() {
        return manager;
    }

    public static void setManager(StatefulWebServiceManager<CoordinatorPortTypeImpl> aManager) {
        manager = aManager;
    }

    static {
        logger = TxLogger.getLogger(CoordinatorPortTypeImpl.class);
    }
}

