/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.rm.CloseSequenceException;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.TerminateSequenceException;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.ClientSession;
import com.sun.xml.ws.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rm.runtime.ProtocolCommunicator;
import com.sun.xml.ws.rm.v200702.AcceptType;
import com.sun.xml.ws.rm.v200702.CloseSequenceElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.CreateSequenceElement;
import com.sun.xml.ws.rm.v200702.CreateSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.Identifier;
import com.sun.xml.ws.rm.v200702.OfferType;
import com.sun.xml.ws.rm.v200702.TerminateSequenceElement;
import com.sun.xml.ws.rm.v200702.TerminateSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.UsesSequenceSTR;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.util.Calendar;

final class Rm11ClientSession
extends ClientSession {
    private static final RmLogger LOGGER = RmLogger.getLogger(Rm11ClientSession.class);

    Rm11ClientSession(Configuration configuration, ProtocolCommunicator communicator) {
        super(configuration, communicator);
    }

    void openRmSession(String offerInboundSequenceId, SecurityTokenReferenceType strType) throws RmRuntimeException {
        PacketAdapter responseAdapter;
        CreateSequenceElement csElement = new CreateSequenceElement();
        csElement.setAcksTo(this.configuration.getAddressingVersion().anonymousEpr.toSpec());
        if (offerInboundSequenceId != null) {
            Identifier offerIdentifier = new Identifier();
            offerIdentifier.setValue(offerInboundSequenceId);
            OfferType offer = new OfferType();
            offer.setIdentifier(offerIdentifier);
            offer.setEndpoint(csElement.getAcksTo());
            csElement.setOffer(offer);
        }
        if (strType != null) {
            csElement.setSecurityTokenReference(strType);
        }
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.createEmptyRequestPacket());
        requestAdapter.setRequestMessage(csElement, RmVersion.WSRM11.createSequenceAction);
        if (strType != null) {
            UsesSequenceSTR usesSequenceSTR = new UsesSequenceSTR();
            usesSequenceSTR.getOtherAttributes().put(this.communicator.soapMustUnderstandAttributeName, "true");
            requestAdapter.appendHeader(usesSequenceSTR);
        }
        if (!(responseAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.send(requestAdapter.getPacket()))).containsMessage()) {
            throw LOGGER.logSevereException(new RmRuntimeException(LocalizationMessages.WSRM_1114_NULL_RESPONSE_ON_PROTOCOL_MESSAGE_REQUEST("CreateSequence")));
        }
        if (responseAdapter.isFault()) {
            throw LOGGER.logSevereException(new RmRuntimeException(LocalizationMessages.WSRM_1115_PROTOCOL_MESSAGE_REQUEST_REFUSED("CreateSequence")));
        }
        CreateSequenceResponseElement csrElement = (CreateSequenceResponseElement)responseAdapter.unmarshallMessage();
        responseAdapter.getPacket();
        this.outboundSequenceId = csrElement.getIdentifier().getValue();
        long expirationTime = -1L;
        if (csrElement.getExpires() != null && !"PT0S".equals(csrElement.getExpires().getValue().toString())) {
            expirationTime = csrElement.getExpires().getValue().getTimeInMillis(Calendar.getInstance()) + System.currentTimeMillis();
        }
        this.sequenceManager.createOutboundSequence(this.outboundSequenceId, strType != null ? strType.getId() : null, expirationTime);
        if (offerInboundSequenceId != null) {
            AcceptType accept = csrElement.getAccept();
            if (accept == null || accept.getAcksTo() == null) {
                throw new RmRuntimeException(LocalizationMessages.WSRM_1116_ACKS_TO_NOT_EQUAL_TO_ENDPOINT_DESTINATION(null, this.communicator.getDestination()));
            }
            if (!this.communicator.getDestination().getAddress().equals(new WSEndpointReference(accept.getAcksTo()).getAddress())) {
                throw new RmRuntimeException(LocalizationMessages.WSRM_1116_ACKS_TO_NOT_EQUAL_TO_ENDPOINT_DESTINATION(accept.getAcksTo().toString(), this.communicator.getDestination()));
            }
            this.inboundSequenceId = offerInboundSequenceId;
            this.sequenceManager.createInboundSequence(this.inboundSequenceId, strType != null ? strType.getId() : null, -1L);
        }
    }

    void closeOutboundSequence() throws RmException {
        PacketAdapter responseAdapter;
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.createEmptyRequestPacket());
        requestAdapter.setRequestMessage(new CloseSequenceElement(this.outboundSequenceId, this.sequenceManager.getSequence(this.outboundSequenceId).getLastMessageId()), RmVersion.WSRM11.closeSequenceAction);
        if (this.inboundSequenceId != null) {
            requestAdapter.appendSequenceAcknowledgementHeader(this.sequenceManager.getSequence(this.inboundSequenceId));
        }
        if (!(responseAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.send(requestAdapter.getPacket()))).containsMessage()) {
            throw new CloseSequenceException(LocalizationMessages.WSRM_1114_NULL_RESPONSE_ON_PROTOCOL_MESSAGE_REQUEST("CloseSequence"));
        }
        this.processInboundMessageHeaders(responseAdapter, false);
        if (responseAdapter.isFault()) {
            throw new CloseSequenceException(LocalizationMessages.WSRM_1115_PROTOCOL_MESSAGE_REQUEST_REFUSED("CloseSequence"), responseAdapter.message);
        }
        CloseSequenceResponseElement csrElement = (CloseSequenceResponseElement)responseAdapter.unmarshallMessage();
        responseAdapter.getPacket();
        if (!this.outboundSequenceId.equals(csrElement.getIdentifier().getValue())) {
            throw new CloseSequenceException(LocalizationMessages.WSRM_1119_UNEXPECTED_SEQUENCE_ID_IN_CLOSE_SR(csrElement.getIdentifier().getValue(), this.outboundSequenceId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateOutboundSequence() throws RmException {
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.createEmptyRequestPacket());
        requestAdapter.setRequestMessage(new TerminateSequenceElement(this.outboundSequenceId, this.sequenceManager.getSequence(this.outboundSequenceId).getLastMessageId()), RmVersion.WSRM11.terminateSequenceAction);
        PacketAdapter responseAdapter = null;
        try {
            TerminateSequenceResponseElement tsrElement;
            responseAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.send(requestAdapter.getPacket()));
            if (!responseAdapter.containsMessage()) {
                if (this.inboundSequenceId != null) {
                    throw new TerminateSequenceException(LocalizationMessages.WSRM_1114_NULL_RESPONSE_ON_PROTOCOL_MESSAGE_REQUEST("TerminateSequence"));
                }
                return;
            }
            this.processInboundMessageHeaders(responseAdapter, false);
            if (responseAdapter.isFault()) {
                throw new TerminateSequenceException(LocalizationMessages.WSRM_1115_PROTOCOL_MESSAGE_REQUEST_REFUSED("TerminateSequence"), responseAdapter.message);
            }
            String responseAction = responseAdapter.getWsaAction();
            if (RmVersion.WSRM11.terminateSequenceAction.equals(responseAction)) {
                TerminateSequenceElement tsElement = (TerminateSequenceElement)responseAdapter.unmarshallMessage();
                this.sequenceManager.terminateSequence(tsElement.getIdentifier().getValue());
            } else if (RmVersion.WSRM11.terminateSequenceResponseAction.equals(responseAction) && !this.outboundSequenceId.equals((tsrElement = (TerminateSequenceResponseElement)responseAdapter.unmarshallMessage()).getIdentifier().getValue())) {
                throw new TerminateSequenceException(LocalizationMessages.WSRM_1117_UNEXPECTED_SEQUENCE_ID_IN_TERMINATE_SR(tsrElement.getIdentifier().getValue(), this.outboundSequenceId));
            }
        }
        finally {
            if (responseAdapter != null) {
                responseAdapter.consume();
            }
        }
    }
}

