/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.policy;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.Rm10ClientConfiguration;
import com.sun.xml.ws.rm.policy.Rm10ServiceConfiguration;
import com.sun.xml.ws.rm.policy.Rm11ClientConfiguration;
import com.sun.xml.ws.rm.policy.Rm11ServiceConfiguration;
import com.sun.xml.ws.rm.policy.assertion.Rm10Assertion;
import com.sun.xml.ws.rm.policy.assertion.Rm11Assertion;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationManager {
    private static final RmLogger LOGGER = RmLogger.getLogger(ConfigurationManager.class);
    List<Configuration> configurations = new ArrayList<Configuration>();

    public static ConfigurationManager createServiceConfigurationManager(WSDLPort wsdlPort, WSBinding binding) throws RmRuntimeException {
        return new ConfigurationManager(wsdlPort, binding){

            protected void addNewConfiguration(AssertionSet set, SOAPVersion soapVersion, AddressingVersion addressingVersion, boolean requestResponseOperationsDetected) throws RmRuntimeException {
                if (set.contains(Rm11Assertion.NAME)) {
                    this.configurations.add(new Rm11ServiceConfiguration(set, soapVersion, addressingVersion, requestResponseOperationsDetected));
                } else if (set.contains(Rm10Assertion.NAME)) {
                    this.configurations.add(new Rm10ServiceConfiguration(set, soapVersion, addressingVersion, requestResponseOperationsDetected));
                }
            }
        };
    }

    public static ConfigurationManager createClientConfigurationManager(WSDLPort wsdlPort, WSBinding binding) throws RmRuntimeException {
        return new ConfigurationManager(wsdlPort, binding){

            protected void addNewConfiguration(AssertionSet set, SOAPVersion soapVersion, AddressingVersion addressingVersion, boolean requestResponseOperationsDetected) throws RmRuntimeException {
                if (set.contains(Rm11Assertion.NAME)) {
                    this.configurations.add(new Rm11ClientConfiguration(set, soapVersion, addressingVersion, requestResponseOperationsDetected));
                } else if (set.contains(Rm10Assertion.NAME)) {
                    this.configurations.add(new Rm10ClientConfiguration(set, soapVersion, addressingVersion, requestResponseOperationsDetected));
                }
            }
        };
    }

    private ConfigurationManager(WSDLPort wsdlPort, WSBinding binding) throws RmRuntimeException {
        PolicyMap policyMap;
        PolicyMap policyMap2 = policyMap = wsdlPort != null ? wsdlPort.getBinding().getOwner().getExtension(WSDLPolicyMapWrapper.class).getPolicyMap() : null;
        if (policyMap != null) {
            Policy policy;
            PolicyMapKey endpointScopeKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
            try {
                policy = policyMap.getEndpointEffectivePolicy(endpointScopeKey);
            }
            catch (PolicyException ex) {
                throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSRM_1001_UNEXPECTED_CONFIG_INIT_ERROR(), ex));
            }
            if (policy != null) {
                for (AssertionSet set : policy) {
                    if (set.isEmpty()) continue;
                    this.addNewConfiguration(set, binding.getSOAPVersion(), binding.getAddressingVersion(), this.checkForRequestResponseOperations(wsdlPort));
                }
            }
        }
    }

    public final Configuration[] getConfigurationAlternatives() {
        return this.configurations.toArray(new Configuration[this.configurations.size()]);
    }

    abstract void addNewConfiguration(AssertionSet var1, SOAPVersion var2, AddressingVersion var3, boolean var4) throws RmRuntimeException;

    private boolean checkForRequestResponseOperations(WSDLPort port) {
        WSDLBoundPortType portType;
        if (port == null || null == (portType = port.getBinding())) {
            return false;
        }
        for (WSDLBoundOperation wSDLBoundOperation : portType.getBindingOperations()) {
            if (wSDLBoundOperation.getOperation().isOneWay()) continue;
            return true;
        }
        return false;
    }

    static <T extends PolicyAssertion> T extractAssertion(AssertionSet alternative, QName assertionName, Class<T> assertionClass) {
        ArrayList<PolicyAssertion> assertions = new ArrayList<PolicyAssertion>(alternative.get(assertionName));
        switch (assertions.size()) {
            case 0: {
                return null;
            }
        }
        return (T)((PolicyAssertion)assertionClass.cast(assertions.get(0)));
    }
}

