/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.faults;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.v200502.SequenceFaultElement;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

public abstract class AbstractRmSoapFault
extends RmException {
    private static final QName SOAP_1_1_SENDER_FAULT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client", "env");
    private static final QName SOAP_1_1_RECEIVER_FAULT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server", "env");
    private final transient Packet soapFaultResponse;

    public AbstractRmSoapFault(Configuration configuration, Packet request, QName subcode, String reason) {
        super(reason);
        this.soapFaultResponse = AbstractRmSoapFault.createRmProcessingSoapFaultResponse(configuration, request, subcode, reason);
    }

    public AbstractRmSoapFault(Packet soapFaultResponse, String reason) {
        super(reason);
        this.soapFaultResponse = soapFaultResponse;
    }

    public Packet getSoapFaultResponse() {
        return this.soapFaultResponse;
    }

    protected static Packet createRmProcessingSoapFaultResponse(Configuration configuration, Packet request, QName subcode, String reason) throws RmRuntimeException {
        try {
            SOAPFault soapFault = configuration.getSoapVersion().saajSoapFactory.createFault();
            if (reason != null) {
                soapFault.setFaultString(reason, Locale.ENGLISH);
            }
            switch (configuration.getSoapVersion()) {
                case SOAP_11: {
                    soapFault.setFaultCode(SOAP_1_1_SENDER_FAULT);
                    break;
                }
                case SOAP_12: {
                    soapFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                    soapFault.appendFaultSubcode(subcode);
                    break;
                }
                default: {
                    throw new RmRuntimeException("Unsupported SOAP version: '" + configuration.getSoapVersion().toString() + "'");
                }
            }
            Message soapFaultMessage = Messages.create(soapFault);
            if (configuration.getSoapVersion() == SOAPVersion.SOAP_11) {
                Header faultHeader = configuration.getRmVersion() == RmVersion.WSRM10 ? Headers.create(RmVersion.WSRM11.getJaxbContext(configuration.getAddressingVersion()), (Object)new SequenceFaultElement(subcode)) : Headers.create(RmVersion.WSRM11.getJaxbContext(configuration.getAddressingVersion()), (Object)new com.sun.xml.ws.rm.v200702.SequenceFaultElement(subcode));
                soapFaultMessage.getHeaders().add(faultHeader);
            }
            return request.createServerResponse(soapFaultMessage, configuration.getAddressingVersion(), configuration.getSoapVersion(), AbstractRmSoapFault.getProperFaultActionForAddressingVersion(configuration));
        }
        catch (SOAPException ex) {
            throw new RmRuntimeException("Error creating a SOAP fault", ex);
        }
    }

    protected static Packet createCreateSequenceProcessingSoapFaultResponse(Configuration configuration, Packet request, QName subcode, String reason) throws RmRuntimeException {
        try {
            SOAPFault soapFault = configuration.getSoapVersion().saajSoapFactory.createFault();
            if (reason != null) {
                soapFault.setFaultString(reason, Locale.ENGLISH);
            }
            switch (configuration.getSoapVersion()) {
                case SOAP_11: {
                    soapFault.setFaultCode(subcode);
                    break;
                }
                case SOAP_12: {
                    soapFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                    soapFault.appendFaultSubcode(subcode);
                    break;
                }
                default: {
                    throw new RmRuntimeException("Unsupported SOAP version: '" + configuration.getSoapVersion().toString() + "'");
                }
            }
            Message soapFaultMessage = Messages.create(soapFault);
            return request.createServerResponse(soapFaultMessage, configuration.getAddressingVersion(), configuration.getSoapVersion(), AbstractRmSoapFault.getProperFaultActionForAddressingVersion(configuration));
        }
        catch (SOAPException ex) {
            throw new RmRuntimeException("Error creating a SOAP fault", ex);
        }
    }

    private static String getProperFaultActionForAddressingVersion(Configuration configuration) {
        return configuration.getAddressingVersion() == AddressingVersion.MEMBER ? configuration.getAddressingVersion().getDefaultFaultAction() : configuration.getRmVersion().wsrmFaultAction;
    }
}

