/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.ParameterMemberInfo;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

public class OperationInfo {
    String namespace;
    String localName;
    QName qualifiedName;
    HashMap parameterModels;
    ArrayList parameterMembers;
    ArrayList parameterNames;
    ArrayList parameterXmlTypes;
    ArrayList parameterXmlTypeQNames;
    ArrayList parameterJavaTypes;
    ArrayList parameterModes;
    String endPointAddress;
    QName requestQName;
    QName requestXmlType;
    LiteralType returnLiteralType;
    QName responseQName;
    QName returnXmlType;
    QName returnXmlTypeQName;
    Class returnJavaType;
    String returnClassName;
    ArrayList returnMembers;
    LiteralElementMember returnTypeModel;
    Map properties;
    boolean isDocumentOperationFlag;
    boolean isRPCLiteralOperationFlag;
    boolean isOneWay;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public OperationInfo(String localName) {
        this(localName, SOAPVersion.SOAP_11);
    }

    public OperationInfo(String localName, SOAPVersion ver) {
        this.init(ver);
        this.init();
        this.localName = localName;
    }

    protected void init() {
        this.namespace = "";
        this.localName = "";
        this.qualifiedName = null;
        this.parameterMembers = new ArrayList();
        this.parameterModels = new HashMap();
        this.parameterNames = new ArrayList();
        this.parameterXmlTypes = new ArrayList();
        this.parameterXmlTypeQNames = new ArrayList();
        this.parameterJavaTypes = new ArrayList();
        this.parameterModes = new ArrayList();
        this.endPointAddress = "";
        this.returnXmlType = null;
        this.returnJavaType = null;
        this.returnXmlTypeQName = null;
        this.returnMembers = new ArrayList();
        this.requestQName = null;
        this.requestXmlType = null;
        this.responseQName = null;
        this.properties = new HashMap();
        this.isDocumentOperationFlag = false;
        this.setProperty("javax.xml.rpc.soap.operation.style", "rpc");
        this.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", this.soapEncodingConstants.getURIEncoding());
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.qualifiedName = null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public QName getName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = new QName(this.namespace, this.localName);
        }
        return this.qualifiedName;
    }

    public void addParameter(String parameterName, QName parameterXmlType) {
        this.addParameter(parameterName, parameterXmlType, null, ParameterMode.IN);
    }

    public void addParameter(String parameterName, QName parameterXmlType, Class javaType, ParameterMode mode) {
        this.parameterNames.add(parameterName);
        this.parameterXmlTypes.add(parameterXmlType);
        this.parameterJavaTypes.add(javaType);
        this.parameterModes.add(mode);
    }

    public void addParameterModel(String parameterName, LiteralElementMember parameterWsdlModel) {
        this.parameterModels.put(parameterName, parameterWsdlModel);
    }

    public Collection getParameterModels() {
        return this.parameterModels.values();
    }

    public void setReturnType(QName returnXmlType) {
        this.setReturnType(returnXmlType, null);
    }

    public void setReturnTypeQName(QName returnXmlTypeQName) {
        this.returnXmlTypeQName = returnXmlTypeQName;
    }

    public QName getReturnXmlTypeQName() {
        return this.returnXmlTypeQName;
    }

    public void setReturnType(QName returnXmlType, Class returnJavaType) {
        this.returnXmlType = returnXmlType;
        this.returnJavaType = returnJavaType;
    }

    public void addParameterXmlTypeQName(QName parameterXmlTypeQName) {
        this.parameterXmlTypeQNames.add(parameterXmlTypeQName);
    }

    public QName[] getParameterXmlTypeQNames() {
        return this.parameterXmlTypeQNames.toArray(new QName[this.parameterXmlTypeQNames.size()]);
    }

    public void setReturnClassName(String name) {
        this.returnClassName = name;
    }

    public ParameterMemberInfo[] getReturnMembers() {
        return this.returnMembers.toArray(new ParameterMemberInfo[this.returnMembers.size()]);
    }

    public void setReturnMembers(ArrayList members) {
        this.returnMembers = members;
    }

    public String getReturnClassName() {
        return this.returnClassName;
    }

    public Class getReturnClass() {
        return this.returnJavaType;
    }

    public void setRequestQName(QName name) {
        this.requestQName = name;
    }

    public QName getRequestQName() {
        return this.requestQName;
    }

    public void setResponseQName(QName name) {
        this.responseQName = name;
    }

    public QName getResponseQName() {
        return this.responseQName;
    }

    public QName getReturnXmlType() {
        return this.returnXmlType;
    }

    public void setReturnTypeModel(LiteralElementMember returnTypeModel) {
        this.returnTypeModel = returnTypeModel;
    }

    public String[] getParameterNames() {
        return this.parameterNames.toArray(new String[this.parameterNames.size()]);
    }

    public int getParameterCount() {
        return this.parameterNames.size();
    }

    public QName[] getParameterXmlTypes() {
        return this.parameterXmlTypes.toArray(new QName[this.parameterXmlTypes.size()]);
    }

    public Class[] getParameterJavaTypes() {
        return (Class[])this.parameterJavaTypes.toArray(new QName[this.parameterJavaTypes.size()]);
    }

    public ParameterMode[] getParameterModes() {
        return this.parameterModes.toArray(new ParameterMode[this.parameterModes.size()]);
    }

    public void addMemberInfos(ArrayList infos) {
        this.parameterMembers.add(infos);
    }

    public ParameterMemberInfo[] getMemberInfo(int index) {
        if (this.parameterMembers.size() > index) {
            ArrayList infosByParameterIndex = (ArrayList)this.parameterMembers.get(index);
            return infosByParameterIndex.toArray(new ParameterMemberInfo[infosByParameterIndex.size()]);
        }
        return new ParameterMemberInfo[0];
    }

    public String makeKey(String parameterName, Class parameterClass) {
        String className = "";
        if (parameterClass != null) {
            className = parameterClass.getName();
        }
        return new String(parameterName + className);
    }

    public void setEndPointAddress(String address) {
        this.endPointAddress = address;
    }

    public String getEndPointAddress() {
        return this.endPointAddress;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Iterator getPropertyKeys() {
        return this.properties.keySet().iterator();
    }

    public void beDocumentOperation() {
        this.isDocumentOperationFlag = true;
    }

    public boolean isDocumentOperation() {
        return this.isDocumentOperationFlag;
    }

    public void setIsOneWay(boolean oneway) {
        this.isOneWay = oneway;
    }

    public boolean isOneWay() {
        return this.isOneWay;
    }
}

