/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.uddi.FuturesRequestManager;
import com.sun.xml.registry.uddi.JAXRCommand;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.infomodel.AssociationImpl;
import com.sun.xml.registry.uddi.infomodel.ClassificationImpl;
import com.sun.xml.registry.uddi.infomodel.ClassificationSchemeImpl;
import com.sun.xml.registry.uddi.infomodel.ConceptImpl;
import com.sun.xml.registry.uddi.infomodel.EmailAddressImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalIdentifierImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.LocalizedStringImpl;
import com.sun.xml.registry.uddi.infomodel.OrganizationImpl;
import com.sun.xml.registry.uddi.infomodel.PersonNameImpl;
import com.sun.xml.registry.uddi.infomodel.PostalAddressImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceBindingImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceImpl;
import com.sun.xml.registry.uddi.infomodel.SlotImpl;
import com.sun.xml.registry.uddi.infomodel.SpecificationLinkImpl;
import com.sun.xml.registry.uddi.infomodel.TelephoneNumberImpl;
import com.sun.xml.registry.uddi.infomodel.UserImpl;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class LifeCycleManagerImpl
implements LifeCycleManager {
    RegistryServiceImpl service;
    UDDIMapper uddi;
    String[] names = new String[]{"Association", "Classification", "ClassificationScheme", "Concept", "EmailAddress", "ExternalIdentifier", "ExternalLink", "InternationalString", "Key", "LocalizedString", "Organization", "PersonName", "PostalAddress", "Service", "ServiceBinding", "Slot", "SpecificationLink", "TelephoneNumber", "User"};
    Class[] infoModelClass = new Class[]{AssociationImpl.class, ClassificationImpl.class, ClassificationSchemeImpl.class, ConceptImpl.class, EmailAddressImpl.class, ExternalIdentifierImpl.class, ExternalLinkImpl.class, InternationalStringImpl.class, KeyImpl.class, LocalizedStringImpl.class, OrganizationImpl.class, PersonNameImpl.class, PostalAddressImpl.class, ServiceImpl.class, ServiceBindingImpl.class, SlotImpl.class, SpecificationLinkImpl.class, TelephoneNumberImpl.class, UserImpl.class};

    public LifeCycleManagerImpl() {
        String string2 = Locale.getDefault().getCountry();
        if (string2 == null || string2 == "") {
            Locale.setDefault(Locale.US);
        }
    }

    public LifeCycleManagerImpl(RegistryServiceImpl registryServiceImpl) {
        this();
        this.service = registryServiceImpl;
        this.uddi = registryServiceImpl.getUDDIMapper();
    }

    public RegistryService getRegistryService() {
        return this.service;
    }

    public Object createObject(String string2) throws JAXRException {
        try {
            for (int i = 0; i < this.names.length; ++i) {
                if (!string2.equals(this.names[i])) continue;
                Class clazz = this.infoModelClass[i];
                Object t = clazz.newInstance();
                if (t instanceof RegistryObjectImpl) {
                    RegistryObjectImpl registryObjectImpl = (RegistryObjectImpl)t;
                    registryObjectImpl.setLifeCycleManager(this);
                    registryObjectImpl.setRegistryService(this.service);
                    registryObjectImpl.setIsModified(true);
                }
                return t;
            }
            if (string2.equals("AuditableEvent") || string2.equals("ExtrinsicObject") || string2.equals("RegistryEntry") || string2.equals("Versionable") || string2.equals("RegistryPackage")) {
                throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:Can_not_create_object_of_type_") + string2 + ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:_at_Capability_Level_0"));
            }
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:Class_Name_is_not_an_interface_in_the_javax.xml.registry.infomodel_package"));
        }
        catch (InstantiationException instantiationException) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:InstantiationException_in_createObject()_"), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:IllegalAccessException_in_createObject()_"), illegalAccessException);
        }
    }

    public Association createAssociation(RegistryObject registryObject, Concept concept) throws JAXRException {
        AssociationImpl associationImpl = new AssociationImpl(registryObject, concept);
        associationImpl.setLifeCycleManager(this);
        associationImpl.setIsModified(true);
        return associationImpl;
    }

    public Classification createClassification(ClassificationScheme classificationScheme, String string2, String string3) throws JAXRException {
        ClassificationImpl classificationImpl = new ClassificationImpl(classificationScheme, string2, string3);
        classificationImpl.setLifeCycleManager(this);
        classificationImpl.setIsModified(true);
        return classificationImpl;
    }

    public Classification createClassification(Concept concept) throws JAXRException, InvalidRequestException {
        if (concept.getClassificationScheme() == null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:Concept_has_no_ClassificationScheme"));
        }
        ClassificationImpl classificationImpl = new ClassificationImpl(concept);
        classificationImpl.setLifeCycleManager(this);
        classificationImpl.setIsModified(true);
        return classificationImpl;
    }

    public ClassificationScheme createClassificationScheme(Concept concept) throws JAXRException, InvalidRequestException {
        if (concept.getClassificationScheme() == null && concept.getParentConcept() == null) {
            ClassificationSchemeImpl classificationSchemeImpl = new ClassificationSchemeImpl(concept);
            classificationSchemeImpl.setLifeCycleManager(this);
            classificationSchemeImpl.setIsModified(true);
            return classificationSchemeImpl;
        }
        throw new InvalidRequestException();
    }

    public ClassificationScheme createClassificationScheme(String string2, String string3) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl classificationSchemeImpl = new ClassificationSchemeImpl(string2, string3);
        classificationSchemeImpl.setLifeCycleManager(this);
        classificationSchemeImpl.setIsModified(true);
        return classificationSchemeImpl;
    }

    public Concept createConcept(RegistryObject registryObject, String string2, String string3) throws JAXRException {
        ConceptImpl conceptImpl = new ConceptImpl(registryObject, string2, string3);
        conceptImpl.setLifeCycleManager(this);
        conceptImpl.setIsModified(true);
        return conceptImpl;
    }

    public Concept createConcept(RegistryObject registryObject, InternationalString internationalString, String string2) throws JAXRException {
        ConceptImpl conceptImpl = new ConceptImpl(registryObject, "", string2);
        conceptImpl.setName(internationalString);
        conceptImpl.setLifeCycleManager(this);
        conceptImpl.setIsModified(true);
        return conceptImpl;
    }

    public EmailAddress createEmailAddress(String string2) throws JAXRException {
        return new EmailAddressImpl(string2);
    }

    public EmailAddress createEmailAddress(String string2, String string3) throws JAXRException {
        return new EmailAddressImpl(string2, string3);
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme classificationScheme, String string2, String string3) throws JAXRException {
        ExternalIdentifierImpl externalIdentifierImpl = new ExternalIdentifierImpl(classificationScheme, string2, string3);
        externalIdentifierImpl.setLifeCycleManager(this);
        externalIdentifierImpl.setIsModified(true);
        return externalIdentifierImpl;
    }

    public ExternalLink createExternalLink(String string2, String string3) throws JAXRException {
        ExternalLinkImpl externalLinkImpl = new ExternalLinkImpl(string2, string3);
        externalLinkImpl.setLifeCycleManager(this);
        externalLinkImpl.setIsModified(true);
        return externalLinkImpl;
    }

    public Key createKey(String string2) throws JAXRException {
        return new KeyImpl(string2);
    }

    public PersonName createPersonName(String string2) throws JAXRException {
        return new PersonNameImpl(string2);
    }

    public PostalAddress createPostalAddress(String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws JAXRException {
        PostalAddressImpl postalAddressImpl = new PostalAddressImpl(string2, string3, string4, string5, string6, string7, string8);
        if (this.service != null) {
            postalAddressImpl.setPostalScheme(this.service.getDefaultPostalScheme());
        }
        return postalAddressImpl;
    }

    public Service createService(String string2) throws JAXRException {
        ServiceImpl serviceImpl = new ServiceImpl(string2);
        serviceImpl.setLifeCycleManager(this);
        serviceImpl.setIsModified(true);
        return serviceImpl;
    }

    public ServiceBinding createServiceBinding() throws JAXRException {
        ServiceBindingImpl serviceBindingImpl = new ServiceBindingImpl();
        serviceBindingImpl.setLifeCycleManager(this);
        serviceBindingImpl.setIsModified(true);
        return serviceBindingImpl;
    }

    public Slot createSlot(String string2, String string3, String string4) throws JAXRException {
        return new SlotImpl(string2, string3, string4);
    }

    public Slot createSlot(String string2, Collection collection, String string3) throws JAXRException {
        return new SlotImpl(string2, collection, string3);
    }

    public SpecificationLink createSpecificationLink() throws JAXRException {
        SpecificationLinkImpl specificationLinkImpl = new SpecificationLinkImpl();
        specificationLinkImpl.setLifeCycleManager(this);
        specificationLinkImpl.setIsModified(true);
        return specificationLinkImpl;
    }

    public TelephoneNumber createTelephoneNumber() throws JAXRException {
        return new TelephoneNumberImpl();
    }

    public User createUser() throws JAXRException {
        UserImpl userImpl = new UserImpl();
        userImpl.setLifeCycleManager(this);
        userImpl.setIsModified(true);
        return userImpl;
    }

    public BulkResponse saveObjects(Collection collection) throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl bulkResponseImpl = new BulkResponseImpl();
            bulkResponseImpl.setStatus(3);
            Utility.getInstance();
            bulkResponseImpl.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(bulkResponseImpl);
            FuturesRequestManager.invokeCommand(new JAXRCommand.SaveObjectsCommand(this.service, bulkResponseImpl, collection));
            return bulkResponseImpl;
        }
        return this.uddi.saveObjects(collection);
    }

    public BulkResponse deleteObjects(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse deleteObjects(Collection collection, String string2) throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl bulkResponseImpl = new BulkResponseImpl();
            bulkResponseImpl.setStatus(3);
            Utility.getInstance();
            bulkResponseImpl.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(bulkResponseImpl);
            FuturesRequestManager.invokeCommand(new JAXRCommand.DeleteObjectsCommand(this.service, bulkResponseImpl, collection, string2));
            return bulkResponseImpl;
        }
        return this.uddi.deleteObjects(collection, string2);
    }

    public void createConceptEquivalence(Concept concept, Concept concept2) throws JAXRException {
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:UDDI_V2_functionality_is_not_supported_in_this_release"));
    }

    public void deleteConceptEquivalence(Concept concept, Concept concept2) throws JAXRException {
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:UDDI_V2_functionality_is_not_supported_in_this_release"));
    }

    public LocalizedString createLocalizedString(Locale locale, String string2) throws JAXRException {
        return new LocalizedStringImpl(locale, string2);
    }

    public InternationalString createInternationalString(Locale locale, String string2) throws JAXRException {
        return new InternationalStringImpl(locale, string2);
    }

    public InternationalString createInternationalString() throws JAXRException {
        return new InternationalStringImpl();
    }

    public InternationalString createInternationalString(String string2) throws JAXRException {
        return new InternationalStringImpl(string2);
    }

    public Classification createClassification(ClassificationScheme classificationScheme, InternationalString internationalString, String string2) throws JAXRException {
        ClassificationImpl classificationImpl = new ClassificationImpl(classificationScheme, "", string2);
        classificationImpl.setName(internationalString);
        classificationImpl.setLifeCycleManager(this);
        classificationImpl.setIsModified(true);
        return classificationImpl;
    }

    public ClassificationScheme createClassificationScheme(InternationalString internationalString, InternationalString internationalString2) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl classificationSchemeImpl = new ClassificationSchemeImpl();
        classificationSchemeImpl.setName(internationalString);
        classificationSchemeImpl.setDescription(internationalString2);
        classificationSchemeImpl.setLifeCycleManager(this);
        classificationSchemeImpl.setIsModified(true);
        return classificationSchemeImpl;
    }

    public LocalizedString createLocalizedString(Locale locale, String string2, String string3) throws JAXRException {
        LocalizedStringImpl localizedStringImpl = new LocalizedStringImpl(locale, string2);
        localizedStringImpl.setCharsetName(string3);
        return localizedStringImpl;
    }

    public Organization createOrganization(InternationalString internationalString) throws JAXRException {
        OrganizationImpl organizationImpl = new OrganizationImpl();
        organizationImpl.setName(internationalString);
        organizationImpl.setLifeCycleManager(this);
        organizationImpl.setIsModified(true);
        return organizationImpl;
    }

    public Organization createOrganization(String string2) throws JAXRException {
        return this.createOrganization(this.createInternationalString(string2));
    }

    public ExternalLink createExternalLink(String string2, InternationalString internationalString) throws JAXRException {
        ExternalLinkImpl externalLinkImpl = new ExternalLinkImpl(string2);
        externalLinkImpl.setDescription(internationalString);
        externalLinkImpl.setLifeCycleManager(this);
        externalLinkImpl.setIsModified(true);
        return externalLinkImpl;
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme classificationScheme, InternationalString internationalString, String string2) throws JAXRException {
        ExternalIdentifierImpl externalIdentifierImpl = new ExternalIdentifierImpl(classificationScheme, "", string2);
        externalIdentifierImpl.setName(internationalString);
        externalIdentifierImpl.setLifeCycleManager(this);
        externalIdentifierImpl.setIsModified(true);
        return externalIdentifierImpl;
    }

    public Service createService(InternationalString internationalString) throws JAXRException {
        ServiceImpl serviceImpl = new ServiceImpl();
        serviceImpl.setName(internationalString);
        serviceImpl.setLifeCycleManager(this);
        serviceImpl.setIsModified(true);
        return serviceImpl;
    }

    public RegistryPackage createRegistryPackage(InternationalString internationalString) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public ExtrinsicObject createExtrinsicObject() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public PersonName createPersonName(String string2, String string3, String string4) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public RegistryPackage createRegistryPackage(String string2) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse deprecateObjects(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse unDeprecateObjects(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public ExtrinsicObject createExtrinsicObject(DataHandler dataHandler) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

