/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.ant;

import com.sun.tools.ws.processor.modeler.annotation.WebServiceAp;
import com.sun.tools.ws.resources.JavacompilerMessages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

@Deprecated
public class Apt
extends Task {
    protected Path compileClasspath = null;
    private File destDir = null;
    private File sourceDestDir;
    protected List<Option> options = new ArrayList<Option>();
    protected List<Jvmarg> jvmargs = new ArrayList<Jvmarg>();
    private boolean noCompile = false;
    private boolean print = false;
    private boolean xPrintAptRounds = false;
    private boolean xPrintFactoryInfo = false;
    protected boolean debug = false;
    protected String debugLevel = null;
    protected boolean nowarn = false;
    protected boolean deprecation = false;
    protected Path bootclassPath = null;
    protected String extdirs = null;
    protected String endorseddirs = null;
    protected boolean verbose = false;
    protected Path sourcePath = null;
    protected String encoding = null;
    protected String targetVM = null;
    protected boolean fork = false;
    protected List<FileSet> sourceFileset = new ArrayList<FileSet>();

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File base) {
        this.destDir = base;
    }

    public void setSourcedestdir(File sourceBase) {
        this.sourceDestDir = sourceBase;
    }

    public File getSourcedestdir() {
        return this.sourceDestDir;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option createOption() {
        Option option = new Option();
        this.options.add(option);
        return option;
    }

    public List<Jvmarg> getJvmargs() {
        return this.jvmargs;
    }

    public Jvmarg createJvmarg() {
        Jvmarg jvmarg = new Jvmarg();
        this.jvmargs.add(jvmarg);
        return jvmarg;
    }

    public boolean isNocompile() {
        return this.noCompile;
    }

    public void setNocompile(boolean noCompile) {
        this.noCompile = noCompile;
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public boolean isXprintaptrounds() {
        return this.xPrintAptRounds;
    }

    public void setXprintaptrounds(boolean xPrintAptRounds) {
        this.xPrintAptRounds = xPrintAptRounds;
    }

    public boolean isXprintfactoryinfo() {
        return this.xPrintFactoryInfo;
    }

    public void setXprintfactoryinfo(boolean xPrintFactoryInfo) {
        this.xPrintFactoryInfo = xPrintFactoryInfo;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDebuglevel() {
        return this.debugLevel;
    }

    public void setDebuglevel(String debugLevel) {
        this.debugLevel = debugLevel;
    }

    public boolean isNowarn() {
        return this.nowarn;
    }

    public void setNowarn(boolean nowarn) {
        this.nowarn = nowarn;
    }

    public boolean isDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public Path getBootclasspath() {
        return this.bootclassPath;
    }

    public void setBootclasspath(Path bootclassPath) {
        this.bootclassPath = bootclassPath;
    }

    public String getExtdirs() {
        return this.extdirs;
    }

    public void setExtdirs(String extdirs) {
        this.extdirs = extdirs;
    }

    public String getEndorseddirs() {
        return this.endorseddirs;
    }

    public void setEndorseddirs(String endorseddirs) {
        this.endorseddirs = endorseddirs;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Path getSourcepath() {
        return this.sourcePath;
    }

    public void setSourcepath(Path sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTarget() {
        return this.targetVM;
    }

    public void setTarget(String target) {
        this.targetVM = target;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void addConfiguredSource(FileSet fileset) {
        this.sourceFileset.add(fileset);
    }

    private Commandline setupAptCommand() {
        Commandline cmd = this.setupAptArgs();
        Path classpath = this.getClasspath();
        if (classpath != null && !classpath.toString().equals("")) {
            Apt.addValue(cmd, "-classpath", classpath);
        }
        return cmd;
    }

    private Commandline setupAptForkCommand() {
        CommandlineJava forkCmd = new CommandlineJava();
        Path classpath = this.getClasspath();
        forkCmd.createClasspath(this.getProject()).append(classpath);
        forkCmd.setClassname("com.sun.tools.javac.Main");
        if (this.getJvmargs() != null) {
            for (Jvmarg jvmarg : this.jvmargs) {
                forkCmd.createVmArgument().setLine(jvmarg.getValue());
            }
        }
        Commandline cmd = this.setupAptArgs();
        cmd.createArgument(true).setLine(forkCmd.toString());
        return cmd;
    }

    private Commandline setupAptArgs() {
        Commandline ap = new Commandline();
        if (this.getDestdir() != null && !this.getDestdir().getName().equals("")) {
            Apt.addValue(ap, "-d", this.getDestdir());
        }
        if (this.getSourcedestdir() != null && !this.getSourcedestdir().getName().equals("")) {
            Apt.addValue(ap, "-s", this.getSourcedestdir());
        }
        if (this.getSourcepath() == null) {
            throw new BuildException("\"sourcePath\" attribute must be set.");
        }
        if (this.getSourcepath() != null && !this.getSourcepath().toString().equals("")) {
            Apt.addValue(ap, "-sourcepath", this.getSourcepath().toString());
        }
        if (this.getBootclasspath() != null && !this.getBootclasspath().toString().equals("")) {
            Apt.addValue(ap, "-bootclasspath", this.getBootclasspath().toString());
        }
        if (this.getExtdirs() != null && !this.getExtdirs().equals("")) {
            Apt.addValue(ap, "-extdirs", this.getExtdirs());
        }
        if (this.getEndorseddirs() != null && !this.getEndorseddirs().equals("")) {
            Apt.addValue(ap, "-endorseddirs", this.getEndorseddirs());
        }
        if (this.isDebug()) {
            Iterator<Object> debugOption = "-g";
            if (this.getDebuglevel() != null && !this.getDebuglevel().equals("")) {
                debugOption = (String)((Object)debugOption) + ":" + this.getDebuglevel();
            }
            Apt.addValue(ap, (String)((Object)debugOption));
        } else {
            Apt.addValue(ap, "-g:none");
        }
        if (this.isVerbose()) {
            Apt.addValue(ap, "-verbose");
        }
        if (this.getEncoding() != null && !this.getEncoding().equals("")) {
            Apt.addValue(ap, "-encoding", this.getEncoding());
        }
        if (this.getTarget() != null && !this.getTarget().equals("")) {
            Apt.addValue(ap, "-target", this.getTarget());
        }
        if (!this.fork) {
            for (Jvmarg jvmarg : this.jvmargs) {
                Apt.addValue(ap, "-J" + jvmarg.getValue());
            }
        }
        for (Option option : this.options) {
            Apt.addValue(ap, "-A" + option.getKey() + "=" + option.getValue());
        }
        if (this.isNowarn()) {
            Apt.addValue(ap, "-nowarn");
        }
        if (this.isNocompile()) {
            Apt.addValue(ap, "-proc:only");
        }
        if (this.isDeprecation()) {
            Apt.addValue(ap, "-deprecation");
        }
        if (this.isPrint()) {
            Apt.addValue(ap, "-Xprint");
        }
        if (this.isXprintaptrounds()) {
            Apt.addValue(ap, "-XprintRounds");
        }
        if (this.isXprintfactoryinfo()) {
            Apt.addValue(ap, "-XprintProcessorInfo");
        }
        HashSet<File> sourceFiles = new HashSet<File>();
        this.prepareSourceList(sourceFiles);
        if (!sourceFiles.isEmpty()) {
            for (File source : sourceFiles) {
                ap.createArgument().setFile(source);
            }
        }
        Apt.addValue(ap, "-processor", WebServiceAp.class.getName());
        return ap;
    }

    private static void addValue(Commandline ap, String name) {
        Apt.addValue(ap, name, (String)null);
    }

    private static void addValue(Commandline ap, String name, String value) {
        ap.createArgument().setValue(name);
        if (value != null) {
            ap.createArgument().setValue(value);
        }
    }

    private static void addValue(Commandline ap, String name, Path value) {
        ap.createArgument().setValue(name);
        if (value != null) {
            ap.createArgument().setPath(value);
        }
    }

    private static void addValue(Commandline ap, String name, File value) {
        ap.createArgument().setValue(name);
        if (value != null) {
            ap.createArgument().setFile(value);
        }
    }

    void prepareSourceList(Set<File> sourceFiles) throws BuildException {
        if (this.sourceFileset != null) {
            for (FileSet fileset : this.sourceFileset) {
                DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
                String[] includedFiles = ds.getIncludedFiles();
                File baseDir = ds.getBasedir();
                for (String includedFile : includedFiles) {
                    sourceFiles.add(new File(baseDir, includedFile));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try (PrintWriter writer = null;){
            Commandline cmd;
            Commandline commandline = cmd = this.fork ? this.setupAptForkCommand() : this.setupAptCommand();
            if (this.verbose) {
                this.log("command line: apt " + cmd.toString());
            }
            int status = 0;
            if (this.fork) {
                status = this.run(cmd.getCommandline());
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                writer = new PrintWriter(baos);
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                try {
                    JavaCompiler comp = ToolProvider.getSystemJavaCompiler();
                    if (comp == null) {
                        writer.println(JavacompilerMessages.NO_JAVACOMPILER_ERROR());
                        status = -1;
                    } else {
                        status = comp.run(null, baos, baos, cmd.getArguments());
                    }
                    writer.flush();
                    if (this.verbose || baos.size() != 0) {
                        this.log(baos.toString());
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            if (status != 0) {
                if (!this.verbose) {
                    this.log("Command invoked: apt " + cmd.toString());
                }
                throw new BuildException("apt failed", this.location);
            }
        }
    }

    private int run(String[] command) throws BuildException {
        LogStreamHandler logstr = new LogStreamHandler((Task)this, 2, 1);
        Execute exe = new Execute((ExecuteStreamHandler)logstr);
        exe.setAntRun(this.project);
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }

    public static class Option {
        protected String key;
        protected String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Jvmarg {
        protected String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

