/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wsdl.parser.NamespaceContextImpl;
import com.sun.tools.xjc.util.DOMUtils;
import com.sun.xml.ws.util.JAXWSUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Internalizer {
    private Map<String, Element> wsdlDocuments;
    private Map<String, Document> jaxwsBindings;
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();
    private ProcessorEnvironment env;

    public void transform(Map<String, Document> jaxwsBindings, Map<String, Element> wsdlDocuments, ProcessorEnvironment env) {
        Element e;
        if (jaxwsBindings == null) {
            return;
        }
        this.env = env;
        this.wsdlDocuments = wsdlDocuments;
        this.jaxwsBindings = jaxwsBindings;
        HashMap<Element, Node> targetNodes = new HashMap<Element, Node>();
        for (Map.Entry<String, Document> jaxwsBinding : jaxwsBindings.entrySet()) {
            e = jaxwsBinding.getValue().getDocumentElement();
            this.buildTargetNodeMap(e, e, targetNodes);
        }
        for (Map.Entry<String, Document> jaxwsBinding : jaxwsBindings.entrySet()) {
            e = jaxwsBinding.getValue().getDocumentElement();
            this.move(e, targetNodes);
        }
    }

    private void validate(Element bindings) {
        NamedNodeMap atts = bindings.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if (a.getNamespaceURI() == null && !a.getLocalName().equals("node") && !a.getLocalName().equals("wsdlLocation")) continue;
        }
    }

    public Document get(String systemId) {
        Element doc = this.wsdlDocuments.get(systemId);
        if (doc == null && systemId.startsWith("file:/") && !systemId.startsWith("file://")) {
            doc = this.wsdlDocuments.get("file://" + systemId.substring(5));
        }
        if (doc == null && systemId.startsWith("file:")) {
            String systemPath = this.getPath(systemId);
            for (String key : this.wsdlDocuments.keySet()) {
                if (!key.startsWith("file:") || !this.getPath(key).equalsIgnoreCase(systemPath)) continue;
                doc = this.wsdlDocuments.get(key);
                break;
            }
        }
        return doc == null ? null : doc.getOwnerDocument();
    }

    private String getPath(String key) {
        key = key.substring(5);
        while (key.length() > 0 && key.charAt(0) == '/') {
            key = key.substring(1);
        }
        return key;
    }

    private void buildTargetNodeMap(Element bindings, Node inheritedTarget, Map<Element, Node> result) {
        Element[] children;
        Node target = inheritedTarget;
        this.validate(bindings);
        if (bindings.getAttributeNode("wsdlLocation") != null) {
            String wsdlLocation = bindings.getAttribute("wsdlLocation");
            try {
                wsdlLocation = new URL(new URL(this.getSystemId(bindings.getOwnerDocument())), wsdlLocation).toExternalForm();
            }
            catch (MalformedURLException e) {
                wsdlLocation = JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)wsdlLocation));
            }
            target = this.get(wsdlLocation);
            if (target == null) {
                this.env.error(WsdlMessages.localizableINTERNALIZER_TARGET_NOT_FOUND(wsdlLocation));
                return;
            }
        }
        boolean hasNode = true;
        if (this.isJAXWSBindings(bindings) && bindings.getAttributeNode("node") != null) {
            target = this.evaluateXPathNode(target, bindings.getAttribute("node"), new NamespaceContextImpl(bindings));
        } else if (this.isJAXWSBindings(bindings) && bindings.getAttributeNode("node") == null && !this.isTopLevelBinding(bindings)) {
            hasNode = false;
        } else if (this.isGlobalBinding(bindings) && !this.isWSDLDefinition(target) && this.isTopLevelBinding(bindings.getParentNode())) {
            target = this.getWSDLDefintionNode(target);
        }
        if (target == null) {
            return;
        }
        if (hasNode) {
            result.put(bindings, target);
        }
        for (Element child : children = Internalizer.getChildElements(bindings, "http://java.sun.com/xml/ns/jaxws")) {
            this.buildTargetNodeMap(child, target, result);
        }
    }

    private Node getWSDLDefintionNode(Node target) {
        return this.evaluateXPathNode(target, "wsdl:definitions", new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }

            public String getPrefix(String nsURI) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }
        });
    }

    private boolean isWSDLDefinition(Node target) {
        if (target == null) {
            return false;
        }
        String localName = target.getLocalName();
        String nsURI = target.getNamespaceURI();
        return Internalizer.fixNull(localName).equals("definitions") && Internalizer.fixNull(nsURI).equals("http://schemas.xmlsoap.org/wsdl/");
    }

    private boolean isTopLevelBinding(Node node) {
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        return node != null && ((Element)node).getAttributeNode("wsdlLocation") != null;
    }

    private boolean isJAXWSBindings(Node bindings) {
        return bindings.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && bindings.getLocalName().equals("bindings");
    }

    private boolean isGlobalBinding(Node bindings) {
        if (bindings.getNamespaceURI() == null) {
            this.env.warn(WsdlMessages.localizableINVALID_CUSTOMIZATION_NAMESPACE(bindings.getLocalName()));
            return false;
        }
        return bindings.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && (bindings.getLocalName().equals("package") || bindings.getLocalName().equals("enableAsyncMapping") || bindings.getLocalName().equals("enableAdditionalSOAPHeaderMapping") || bindings.getLocalName().equals("enableWrapperStyle") || bindings.getLocalName().equals("enableMIMEContent"));
    }

    private static Element[] getChildElements(Element parent, String nsUri) {
        ArrayList<Element> a = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node item = children.item(i);
            if (!(item instanceof Element) || !nsUri.equals(item.getNamespaceURI())) continue;
            a.add((Element)item);
        }
        return a.toArray(new Element[a.size()]);
    }

    private Node evaluateXPathNode(Node target, String expression, NamespaceContext namespaceContext) {
        NodeList nlst;
        try {
            this.xpath.setNamespaceContext(namespaceContext);
            nlst = (NodeList)this.xpath.evaluate(expression, target, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            this.env.error(WsdlMessages.localizableINTERNALIZER_X_PATH_EVALUATION_ERROR(e.getMessage()));
            if (this.env.verbose()) {
                e.printStackTrace();
            }
            return null;
        }
        if (nlst.getLength() == 0) {
            this.env.error(WsdlMessages.localizableINTERNALIZER_X_PATH_EVALUATES_TO_NO_TARGET(expression));
            return null;
        }
        if (nlst.getLength() != 1) {
            this.env.error(WsdlMessages.localizableINTERNALIZER_X_PATH_EVAULATES_TO_TOO_MANY_TARGETS(expression, nlst.getLength()));
            return null;
        }
        Node rnode = nlst.item(0);
        if (!(rnode instanceof Element)) {
            this.env.error(WsdlMessages.localizableINTERNALIZER_X_PATH_EVALUATES_TO_NON_ELEMENT(expression));
            return null;
        }
        return (Element)rnode;
    }

    private void move(Element bindings, Map<Element, Node> targetNodes) {
        Element[] children;
        Node target = targetNodes.get(bindings);
        if (target == null) {
            return;
        }
        for (Element item : children = DOMUtils.getChildElements((Element)bindings)) {
            if ("bindings".equals(item.getLocalName())) {
                this.move(item, targetNodes);
                continue;
            }
            if (this.isGlobalBinding(item)) {
                target = targetNodes.get(item);
                this.moveUnder(item, (Element)target);
                continue;
            }
            if (!(target instanceof Element)) {
                return;
            }
            this.moveUnder(item, (Element)target);
        }
    }

    private boolean isJAXBBindingElement(Element e) {
        return Internalizer.fixNull(e.getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxb");
    }

    private boolean isJAXWSBindingElement(Element e) {
        return Internalizer.fixNull(e.getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxws");
    }

    private void moveUnder(Element decl, Element target) {
        if (this.isJAXBBindingElement(decl)) {
            if (!target.hasAttributeNS("http://www.w3.org/2000/xmlns/", "jaxb")) {
                target.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
            }
            if (!target.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "version")) {
                target.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:version", "2.0");
            }
            if (target.getLocalName().equals("schema") && target.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !target.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "extensionBindingPrefixes")) {
                target.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:extensionBindingPrefixes", "xjc");
                target.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xjc", "http://java.sun.com/xml/ns/jaxb/xjc");
            }
            target = this.refineSchemaTarget(target);
            this.copyInscopeNSAttributes(decl);
        } else if (this.isJAXWSBindingElement(decl)) {
            if (!target.hasAttributeNS("http://www.w3.org/2000/xmlns/", "JAXWS")) {
                target.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:JAXWS", "http://java.sun.com/xml/ns/jaxws");
            }
            target = this.refineWSDLTarget(target);
            this.copyInscopeNSAttributes(decl);
        } else {
            return;
        }
        if (target.getOwnerDocument() != decl.getOwnerDocument()) {
            decl = (Element)target.getOwnerDocument().importNode(decl, true);
        }
        target.appendChild(decl);
    }

    private void copyInscopeNSAttributes(Element e) {
        Element p = e;
        HashSet<String> inscopes = new HashSet<String>();
        while (true) {
            NamedNodeMap atts = p.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                String prefix;
                Attr a = (Attr)atts.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI()) || !inscopes.add(prefix = a.getName().indexOf(58) == -1 ? "" : a.getLocalName()) || p == e) continue;
                e.setAttributeNodeNS((Attr)a.cloneNode(true));
            }
            if (p.getParentNode() instanceof Document) break;
            p = (Element)p.getParentNode();
        }
        if (!inscopes.contains("")) {
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
    }

    public Element refineSchemaTarget(Element target) {
        Element appinfo;
        Element annotation = DOMUtils.getFirstChildElement((Element)target, (String)"http://www.w3.org/2001/XMLSchema", (String)"annotation");
        if (annotation == null) {
            annotation = this.insertXMLSchemaElement(target, "annotation");
        }
        if ((appinfo = DOMUtils.getFirstChildElement((Element)annotation, (String)"http://www.w3.org/2001/XMLSchema", (String)"appinfo")) == null) {
            appinfo = this.insertXMLSchemaElement(annotation, "appinfo");
        }
        return appinfo;
    }

    public Element refineWSDLTarget(Element target) {
        Element JAXWSBindings = DOMUtils.getFirstChildElement((Element)target, (String)"http://java.sun.com/xml/ns/jaxws", (String)"bindings");
        if (JAXWSBindings == null) {
            JAXWSBindings = this.insertJAXWSBindingsElement(target, "bindings");
        }
        return JAXWSBindings;
    }

    private Element insertXMLSchemaElement(Element parent, String localName) {
        String qname = parent.getTagName();
        int idx = qname.indexOf(58);
        qname = idx == -1 ? localName : qname.substring(0, idx + 1) + localName;
        Element child = parent.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", qname);
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 0) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, children.item(0));
        }
        return child;
    }

    private Element insertJAXWSBindingsElement(Element parent, String localName) {
        String qname = "JAXWS:" + localName;
        Element child = parent.getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/jaxws", qname);
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 0) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, children.item(0));
        }
        return child;
    }

    @NotNull
    private static String fixNull(@Nullable String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private String getSystemId(Document doc) {
        for (Map.Entry<String, Document> e : this.jaxwsBindings.entrySet()) {
            if (e.getValue() != doc) continue;
            return e.getKey();
        }
        return null;
    }
}

