/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.tools.ws.processor.generator.GeneratorConstants;
import com.sun.tools.ws.processor.generator.GeneratorException;
import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.processor.model.java.JavaStructureMember;
import com.sun.tools.ws.processor.model.jaxb.JAXBProperty;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.ws.util.ClassNameInfo;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.streaming.PrefixFactory;
import com.sun.xml.ws.streaming.PrefixFactoryImpl;
import com.sun.xml.ws.util.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class Names
implements GeneratorConstants {
    protected String serializerNameInfix = null;
    protected PrefixFactory prefixFactory = new PrefixFactoryImpl("ns");
    protected static Map reservedWords = new HashMap();

    public String stubFor(Port port, String infix) {
        String result = (String)port.getProperty("com.sun.xml.ws.processor.model.StubClassName");
        if (result == null) {
            result = this.makeDerivedClassName(port.getJavaInterface(), "_Stub", infix);
        }
        return result;
    }

    public String tieFor(Port port, String infix) {
        String result = (String)port.getProperty("com.sun.xml.ws.processor.model.TieClassName");
        if (result == null) {
            result = this.makeDerivedClassName(port.getJavaInterface(), "_Tie", infix);
        }
        return result;
    }

    public String makeDerivedClassName(JavaInterface javaInterface, String suffix, String infix) {
        String name = ClassNameInfo.replaceInnerClassSym(javaInterface.getRealName());
        return name + (infix == null ? "" : "_" + infix) + suffix;
    }

    public static String getPortName(Port port) {
        String javaPortName = (String)port.getProperty("com.sun.xml.ws.processor.model.JavaPortName");
        if (javaPortName != null) {
            return javaPortName;
        }
        QName portName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLPortName");
        if (portName != null) {
            return portName.getLocalPart();
        }
        String name = Names.stripQualifier(port.getJavaInterface().getName());
        return ClassNameInfo.replaceInnerClassSym(name);
    }

    public static String stripQualifier(Class classObj) {
        String name = classObj.getName();
        return Names.stripQualifier(name);
    }

    public static String stripQualifier(String name) {
        return ClassNameInfo.getName(name);
    }

    public static String getPackageName(String className) {
        String packageName = ClassNameInfo.getQualifier(className);
        return packageName != null ? packageName : "";
    }

    public static String getUnqualifiedClassName(String className) {
        return ClassNameInfo.getName(className).replace('$', '.');
    }

    public File sourceFileForClass(String className, String outputClassName, File destDir, ProcessorEnvironment env) throws GeneratorException {
        File packageDir = DirectoryUtil.getOutputDirectoryFor(className, destDir, env);
        String outputName = Names.stripQualifier(outputClassName);
        String outputFileName = outputName + ".java";
        return new File(packageDir, outputFileName);
    }

    public static String getPackageName(Service service) {
        String portPackage = Names.getPackageName(service.getJavaInterface().getName());
        return portPackage;
    }

    public String customJavaTypeClassName(JavaInterface intf) {
        String intName = intf.getName();
        return intName;
    }

    public String customExceptionClassName(Fault fault) {
        String typeName = fault.getJavaException().getName();
        return typeName;
    }

    public String getExceptionClassMemberName() {
        return "faultInfo";
    }

    public String getQNameName(QName name) {
        String qname = this.getPrefix(name) + "_" + name.getLocalPart() + "_QNAME";
        return this.validInternalJavaIdentifier(qname);
    }

    public String getBlockQNameName(Operation operation, Block block) {
        QName blockName = block.getName();
        String qname = this.getPrefix(blockName);
        if (operation != null) {
            qname = qname + "_" + operation.getUniqueName();
        }
        qname = qname + "_" + blockName.getLocalPart() + "_QNAME";
        return this.validInternalJavaIdentifier(qname);
    }

    public String getTypeQName(QName name) {
        String qname = this.getPrefix(name) + "_" + name.getLocalPart() + "_TYPE_QNAME";
        return this.validInternalJavaIdentifier(qname);
    }

    public String validJavaClassName(String name) {
        return JAXBRIContext.mangleNameToClassName((String)name);
    }

    public String validJavaMemberName(String name) {
        return JAXBRIContext.mangleNameToVariableName((String)name);
    }

    public String validInternalJavaIdentifier(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    sb.append(ch);
                    continue;
                }
                sb.append("_$");
                sb.append(Integer.toHexString(ch));
                sb.append("$");
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append("$");
            sb.append(Integer.toHexString(ch));
            sb.append("$");
        }
        String id = sb.toString();
        String tmp = (String)reservedWords.get(id);
        if (tmp != null) {
            id = tmp;
        }
        return id;
    }

    public String validExternalJavaIdentifier(String name) {
        return this.validInternalJavaIdentifier(name).replace('$', '_');
    }

    public String validJavaName(String name) {
        name = this.wordBreakString(name);
        String tmp = (String)reservedWords.get(name = this.removeWhiteSpace(name));
        if (tmp != null) {
            name = tmp;
        }
        return name;
    }

    public boolean isJavaReservedWord(String name) {
        return reservedWords.get(name) != null;
    }

    public String getJavaMemberReadMethod(JavaStructureMember member) {
        String return_value = null;
        return_value = member.getType().getRealName() == "boolean" ? "is" + StringUtils.capitalize((String)member.getName()) : "get" + StringUtils.capitalize((String)member.getName());
        return return_value;
    }

    public String getJavaMemberWriteMethod(JavaStructureMember member) {
        return "set" + StringUtils.capitalize((String)member.getName());
    }

    public static String getResponseName(String messageName) {
        return messageName + "Response";
    }

    public String getJavaReadMethod(JAXBProperty prop) {
        if (prop.getType().getName().equals("boolean")) {
            return "is" + StringUtils.capitalize((String)prop.getName());
        }
        return this.getJavaReadMethod(prop.getName());
    }

    public String getJavaWriteMethod(JAXBProperty prop) {
        return this.getJavaWriteMethod(prop.getName());
    }

    public String getJavaReadMethod(String prop) {
        return "get" + StringUtils.capitalize((String)prop);
    }

    public String getJavaWriteMethod(String prop) {
        return "set" + StringUtils.capitalize((String)prop);
    }

    public String removeWhiteSpace(String str) {
        String tmp = this.removeCharacter(32, str);
        return tmp;
    }

    public String wordBreakString(String str) {
        StringBuffer buf = new StringBuffer(str);
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (Character.isDigit(ch)) {
                if (i + 1 >= buf.length() || Character.isDigit(buf.charAt(i + 1))) continue;
                buf.insert(1 + i++, ' ');
                continue;
            }
            if (Character.isSpaceChar(ch) || ch == '_') continue;
            if (!Character.isJavaIdentifierPart(ch)) {
                buf.setCharAt(i, ' ');
                continue;
            }
            if (Character.isLetter(ch)) continue;
            buf.setCharAt(i, ' ');
        }
        return buf.toString();
    }

    public String removeCharacter(int ch, String str) {
        int idx = str.indexOf(ch);
        while (idx >= 0) {
            str = str.substring(0, idx) + StringUtils.capitalize((String)str.substring(idx + 1).trim());
            idx = str.indexOf(32);
        }
        return str;
    }

    public String getPrefix(QName name) {
        return this.getPrefix(name.getNamespaceURI());
    }

    public String getPrefix(String uri) {
        return this.prefixFactory.getPrefix(uri);
    }

    public void resetPrefixFactory() {
        this.prefixFactory = new PrefixFactoryImpl("ns");
    }

    public void setSerializerNameInfix(String serNameInfix) {
        if (serNameInfix != null && serNameInfix.length() > 0) {
            this.serializerNameInfix = "_" + serNameInfix;
        }
    }

    public String getSerializerNameInfix() {
        String str = this.serializerNameInfix;
        if (this.serializerNameInfix != null && this.serializerNameInfix.charAt(0) == '_') {
            str = this.serializerNameInfix.substring(1);
        }
        return str;
    }

    static {
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("assert", "_assert");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put("return", "_return");
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
        reservedWords.put("enum", "_enum");
    }
}

