/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.tools.ws.api.MetaDataResolver;
import com.sun.tools.ws.api.MetadataResolverFactory;
import com.sun.tools.ws.api.ServiceDescriptor;
import com.sun.tools.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.ws.api.wsdl.TWSDLExtensionHandler;
import com.sun.tools.ws.processor.config.WSDLModelInfo;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.util.xml.NullEntityResolver;
import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.tools.ws.wsdl.document.Binding;
import com.sun.tools.ws.wsdl.document.BindingFault;
import com.sun.tools.ws.wsdl.document.BindingInput;
import com.sun.tools.ws.wsdl.document.BindingOperation;
import com.sun.tools.ws.wsdl.document.BindingOutput;
import com.sun.tools.ws.wsdl.document.Definitions;
import com.sun.tools.ws.wsdl.document.Documentation;
import com.sun.tools.ws.wsdl.document.Fault;
import com.sun.tools.ws.wsdl.document.Import;
import com.sun.tools.ws.wsdl.document.Input;
import com.sun.tools.ws.wsdl.document.Message;
import com.sun.tools.ws.wsdl.document.MessagePart;
import com.sun.tools.ws.wsdl.document.Operation;
import com.sun.tools.ws.wsdl.document.OperationStyle;
import com.sun.tools.ws.wsdl.document.Output;
import com.sun.tools.ws.wsdl.document.Port;
import com.sun.tools.ws.wsdl.document.PortType;
import com.sun.tools.ws.wsdl.document.Service;
import com.sun.tools.ws.wsdl.document.WSDLConstants;
import com.sun.tools.ws.wsdl.document.WSDLDocument;
import com.sun.tools.ws.wsdl.document.schema.SchemaConstants;
import com.sun.tools.ws.wsdl.document.schema.SchemaKinds;
import com.sun.tools.ws.wsdl.framework.Entity;
import com.sun.tools.ws.wsdl.framework.ParseException;
import com.sun.tools.ws.wsdl.framework.ParserListener;
import com.sun.tools.ws.wsdl.framework.TWSDLParserContextImpl;
import com.sun.tools.ws.wsdl.parser.HTTPExtensionHandler;
import com.sun.tools.ws.wsdl.parser.Internalizer;
import com.sun.tools.ws.wsdl.parser.JAXWSBindingExtensionHandler;
import com.sun.tools.ws.wsdl.parser.MIMEExtensionHandler;
import com.sun.tools.ws.wsdl.parser.MemberSubmissionAddressingExtensionHandler;
import com.sun.tools.ws.wsdl.parser.SOAP12ExtensionHandler;
import com.sun.tools.ws.wsdl.parser.SOAPExtensionHandler;
import com.sun.tools.ws.wsdl.parser.Util;
import com.sun.tools.ws.wsdl.parser.W3CAddressingExtensionHandler;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDLParser {
    private WSDLModelInfo modelInfo;
    private EntityResolver entityResolver;
    private final Set<String> imports = new HashSet<String>();
    private final Map<String, Element> wsdlDocuments = new HashMap<String, Element>();
    private final List<Element> schemaElements;
    private final Map extensionHandlers;
    private final ProcessorEnvironment env;
    private String targetNamespaceURI;
    private ArrayList<ParserListener> listeners;

    public WSDLParser(WSDLModelInfo modelInfo) {
        assert (modelInfo != null);
        this.extensionHandlers = new HashMap();
        this.schemaElements = new ArrayList<Element>();
        this.modelInfo = modelInfo;
        this.entityResolver = modelInfo.getEntityResolver();
        this.env = modelInfo.getConfiguration().getEnvironment();
        this.register(new SOAPExtensionHandler(this.extensionHandlers));
        this.register(new HTTPExtensionHandler(this.extensionHandlers));
        this.register(new MIMEExtensionHandler(this.extensionHandlers));
        this.register(new JAXWSBindingExtensionHandler(this.extensionHandlers));
        this.register(new SOAP12ExtensionHandler(this.extensionHandlers));
        this.register(new MemberSubmissionAddressingExtensionHandler(this.extensionHandlers, this.env));
        this.register(new W3CAddressingExtensionHandler(this.extensionHandlers, this.env));
        for (TWSDLExtensionHandler te : (TWSDLExtensionHandler[])ServiceFinder.find(TWSDLExtensionHandler.class).toArray()) {
            this.register(te);
        }
    }

    private void register(TWSDLExtensionHandler h) {
        this.extensionHandlers.put(h.getNamespaceURI(), h);
    }

    public void addParserListener(ParserListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    private void removeParserListener(ParserListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public WSDLDocument parse() {
        String location = this.modelInfo.getLocation();
        assert (location != null);
        WSDLDocument document = new WSDLDocument();
        InputSource source = null;
        String wsdlLoc = JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)location));
        if (this.entityResolver != null) {
            try {
                source = this.entityResolver.resolveEntity(null, wsdlLoc);
            }
            catch (SAXException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.saxExceptionWithSystemId", source.getSystemId(), e);
                }
                throw new ParseException("parsing.saxException", e);
            }
            catch (IOException e) {
                if (source.getSystemId() != null) {
                    throw new ParseException("parsing.ioExceptionWithSystemId", source.getSystemId(), e);
                }
                throw new ParseException("parsing.ioException", e);
            }
        }
        if (source == null) {
            source = new InputSource(wsdlLoc);
        }
        document.setSystemId(wsdlLoc);
        TWSDLParserContextImpl context = new TWSDLParserContextImpl(document, this.listeners);
        Definitions definitions = this.parseDefinitions(context, source, null);
        if (this.env.getErrorCount() > 0) {
            return null;
        }
        document.setDefinitions(definitions);
        return document;
    }

    /*
     * Unable to fully structure code
     */
    protected Definitions parseDefinitions(TWSDLParserContextImpl context, InputSource source, String expectedTargetNamespaceURI) {
        context.pushWSDLLocation();
        context.setWSDLLocation(context.getDocument().getSystemId());
        sysId = context.getDocument().getSystemId();
        root = null;
        if (sysId.endsWith("?wsdl")) {
            try {
                root = this.buildDocumentFromWSDL(sysId, source, expectedTargetNamespaceURI);
            }
            catch (IOException e) {
                root = this.getFromMetadataResolver(sysId, null, null);
                if (root != null) ** GOTO lbl21
                this.env.error(WsdlMessages.localizablePARSING_UNABLE_TO_GET_METADATA(sysId));
                return null;
            }
        } else {
            root = this.getFromMetadataResolver(sysId, source, expectedTargetNamespaceURI);
            if (root == null) {
                try {
                    root = this.buildDocumentFromWSDL(sysId, source, expectedTargetNamespaceURI);
                }
                catch (IOException e) {
                    throw new ParseException(WsdlMessages.localizablePARSING_IO_EXCEPTION_WITH_SYSTEM_ID(sysId, e));
                }
            }
        }
lbl21:
        // 5 sources

        if (root == null) {
            return null;
        }
        new Internalizer().transform(this.modelInfo.getJAXWSBindings(), this.wsdlDocuments, this.modelInfo.getParent().getEnvironment());
        definitions = this.parseDefinitionsNoImport(context, root);
        this.processImports(context, source, definitions);
        context.popWSDLLocation();
        return definitions;
    }

    private Element getFromMetadataResolver(String systemId, InputSource source, String expectedTargetNamespaceURI) {
        MetaDataResolver resolver = null;
        ServiceDescriptor serviceDescriptor = null;
        for (MetadataResolverFactory resolverFactory : ServiceFinder.find(MetadataResolverFactory.class)) {
            resolver = resolverFactory.metadataResolver(this.entityResolver);
            try {
                serviceDescriptor = resolver.resolve(new URI(JAXWSUtils.getFileOrURLName((String)systemId)));
                if (serviceDescriptor == null) continue;
                break;
            }
            catch (URISyntaxException e) {
                throw new ParseException(e);
            }
        }
        if (serviceDescriptor != null) {
            return this.parseMetadata(serviceDescriptor);
        }
        if (resolver != null && source != null && systemId.startsWith("http")) {
            String getSysId = systemId + "?wsdl";
            try {
                source = new InputSource(getSysId);
                return this.buildDocumentFromWSDL(getSysId, source, expectedTargetNamespaceURI);
            }
            catch (Exception e) {
                this.env.error(WsdlMessages.localizablePARSING_UNABLE_TO_GET_METADATA(getSysId));
            }
        }
        return null;
    }

    private Element parseMetadata(ServiceDescriptor serviceDescriptor) {
        Element e;
        Node n;
        List<? extends Source> wsdls = serviceDescriptor.getWSDLs();
        List<? extends Source> schemas = serviceDescriptor.getSchemas();
        Element root = null;
        for (Source source : wsdls) {
            if (!(source instanceof DOMSource)) continue;
            n = ((DOMSource)source).getNode();
            Element element = e = n.getNodeType() == 1 ? (Element)n : DOMUtil.getFirstElementChild((Node)n);
            if (root == null) {
                root = e;
            }
            this.wsdlDocuments.put(source.getSystemId(), e);
        }
        for (Source source : schemas) {
            if (!(source instanceof DOMSource)) continue;
            n = ((DOMSource)source).getNode();
            e = n.getNodeType() == 1 ? (Element)n : DOMUtil.getFirstElementChild((Node)n);
            this.schemaElements.add(e);
        }
        return root;
    }

    private Element buildDocumentFromWSDL(String systemId, InputSource source, String expectedTargetNamespaceURI) throws IOException {
        try {
            Document document = null;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setErrorHandler(com.sun.xml.ws.util.xml.XmlUtil.DRACONIAN_ERROR_HANDLER);
            if (this.entityResolver != null) {
                builder.setEntityResolver(this.entityResolver);
            } else {
                builder.setEntityResolver(new NullEntityResolver());
            }
            document = builder.parse(source);
            Element e = document.getDocumentElement();
            if (!Util.isTagName(e, WSDLConstants.QNAME_DEFINITIONS)) {
                this.env.error(WsdlMessages.localizablePARSING_INVALID_TAG_NS(e.getTagName(), e.getNamespaceURI(), WSDLConstants.QNAME_DEFINITIONS.getLocalPart(), WSDLConstants.QNAME_DEFINITIONS.getNamespaceURI(), systemId));
                return null;
            }
            this.wsdlDocuments.put(systemId, e);
            this.processWSDLDocument(e, expectedTargetNamespaceURI, source);
            return e;
        }
        catch (SAXException e) {
            throw new ParseException(WsdlMessages.localizablePARSING_SAX_EXCEPTION_WITH_SYSTEM_ID(source.getSystemId(), e));
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(WsdlMessages.localizablePARSING_PARSER_CONFIG_EXCEPTION(e));
        }
        catch (FactoryConfigurationError e) {
            throw new ParseException(WsdlMessages.localizablePARSING_FACTORY_CONFIG_EXCEPTION(e));
        }
    }

    private void processWSDLDocument(Element e, String expectedTargetNamespaceURI, InputSource source) throws IOException, SAXException {
        Element e2;
        String _targetNamespaceURI = XmlUtil.getAttributeOrNull((Element)e, (String)"targetNamespace");
        if (expectedTargetNamespaceURI == null || !expectedTargetNamespaceURI.equals(_targetNamespaceURI)) {
            // empty if block
        }
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (!XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_IMPORT)) continue;
            String namespace = Util.getRequiredAttribute(e2, "namespace");
            String location = Util.getRequiredAttribute(e2, "location");
            if ((location = this.getAdjustedLocation(source, location)) == null || location.equals("") || this.imports.contains(location)) continue;
            this.imports.add(location);
            InputSource impSource = null;
            if (this.entityResolver != null) {
                impSource = this.entityResolver.resolveEntity(null, location);
            }
            if (impSource == null) {
                impSource = new InputSource(location);
            }
            this.buildDocumentFromWSDL(location, impSource, namespace);
        }
    }

    private String getAdjustedLocation(InputSource source, String location) {
        return source.getSystemId() == null ? location : Util.processSystemIdWithBase(source.getSystemId(), location);
    }

    public void dump(OutputStream out) throws IOException {
        try {
            Transformer it = XmlUtil.newTransformer();
            for (Map.Entry<String, Element> e : this.wsdlDocuments.entrySet()) {
                out.write(("---<< " + e.getKey() + "\n").getBytes());
                it.transform(new DOMSource((Document)((Object)e.getValue())), new StreamResult(out));
                out.write("\n\n\n".getBytes());
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void processImports(TWSDLParserContextImpl context, InputSource source, Definitions definitions) {
        for (String location : this.imports) {
            Definitions importedDefinitions;
            if (context.getDocument().isImportedDocument(location) || (importedDefinitions = this.parseDefinitionsNoImport(context, this.wsdlDocuments.get(location))) == null) continue;
            context.getDocument().addImportedEntity(importedDefinitions);
            context.getDocument().addImportedDocument(location);
        }
    }

    private Definitions parseDefinitionsNoImport(TWSDLParserContextImpl context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Definitions definitions = new Definitions(context.getDocument());
        String name = XmlUtil.getAttributeOrNull((Element)e, (String)"name");
        definitions.setName(name);
        this.targetNamespaceURI = XmlUtil.getAttributeOrNull((Element)e, (String)"targetNamespace");
        definitions.setTargetNamespaceURI(this.targetNamespaceURI);
        boolean gotDocumentation = false;
        boolean gotTypes = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.env.error(WsdlMessages.localizablePARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                    return null;
                }
                gotDocumentation = true;
                if (definitions.getDocumentation() != null) continue;
                definitions.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_TYPES)) {
                if (gotTypes) {
                    this.env.error(WsdlMessages.localizablePARSING_ONLY_ONE_TYPES_ALLOWED("definitions"));
                    return null;
                }
                this.addSchemaElements(e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_MESSAGE)) {
                Message message = this.parseMessage(context, definitions, e2);
                definitions.add(message);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PORT_TYPE)) {
                PortType portType = this.parsePortType(context, definitions, e2);
                definitions.add(portType);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_BINDING)) {
                Binding binding = this.parseBinding(context, definitions, e2);
                definitions.add(binding);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_SERVICE)) {
                Service service = this.parseService(context, definitions, e2);
                definitions.add(service);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_IMPORT)) {
                definitions.add(this.parseImport(context, definitions, e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, SchemaConstants.QNAME_IMPORT)) {
                this.env.warn(WsdlMessages.localizableWARNING_WSI_R_2003());
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, definitions, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_DEFINITIONS, definitions);
        return definitions;
    }

    protected Message parseMessage(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Message message = new Message(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        message.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                message.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PART)) {
                MessagePart part = this.parseMessagePart(context, e2);
                message.add(part);
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_MESSAGE, message);
        return message;
    }

    protected MessagePart parseMessagePart(TWSDLParserContextImpl context, Element e) {
        context.push();
        context.registerNamespaces(e);
        MessagePart part = new MessagePart();
        String partName = Util.getRequiredAttribute(e, "name");
        part.setName(partName);
        String elementAttr = XmlUtil.getAttributeOrNull((Element)e, (String)"element");
        String typeAttr = XmlUtil.getAttributeOrNull((Element)e, (String)"type");
        if (elementAttr != null) {
            if (typeAttr != null) {
                Util.fail("parsing.onlyOneOfElementOrTypeRequired", partName);
            }
            part.setDescriptor(context.translateQualifiedName(elementAttr));
            part.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
        } else if (typeAttr != null) {
            part.setDescriptor(context.translateQualifiedName(typeAttr));
            part.setDescriptorKind(SchemaKinds.XSD_TYPE);
        } else {
            Util.fail("parsing.elementOrTypeRequired", partName);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PART, part);
        return part;
    }

    protected PortType parsePortType(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        PortType portType = new PortType(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        portType.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (portType.getDocumentation() != null) continue;
                portType.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OPERATION)) {
                Operation op = this.parsePortTypeOperation(context, e2);
                op.setParent(portType);
                portType.add(op);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, portType, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PORT_TYPE, portType);
        return portType;
    }

    protected Operation parsePortTypeOperation(TWSDLParserContextImpl context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Operation operation = new Operation();
        String name = Util.getRequiredAttribute(e, "name");
        operation.setName(name);
        String parameterOrderAttr = XmlUtil.getAttributeOrNull((Element)e, (String)"parameterOrder");
        operation.setParameterOrder(parameterOrderAttr);
        boolean gotDocumentation = false;
        boolean gotInput = false;
        boolean gotOutput = false;
        boolean gotFault = false;
        boolean inputBeforeOutput = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            Element e3;
            Iterator iter2;
            boolean gotDocumentation2;
            Attr e32;
            String nameAttr;
            String messageAttr;
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (operation.getDocumentation() != null) continue;
                operation.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_INPUT)) {
                if (gotInput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                Input input = new Input();
                input.setParent(operation);
                messageAttr = Util.getRequiredAttribute(e2, "message");
                input.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                input.setName(nameAttr);
                operation.setInput(input);
                gotInput = true;
                if (gotOutput) {
                    inputBeforeOutput = false;
                }
                Iterator iter22 = XmlUtil.getAllAttributes((Element)e2);
                while (iter22.hasNext()) {
                    e32 = (Attr)iter22.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, input, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        input.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", e3.getTagName(), e3.getNamespaceURI());
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OUTPUT)) {
                if (gotOutput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                Output output = new Output();
                output.setParent(operation);
                messageAttr = Util.getRequiredAttribute(e2, "message");
                output.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                output.setName(nameAttr);
                operation.setOutput(output);
                gotOutput = true;
                if (gotInput) {
                    inputBeforeOutput = true;
                }
                Iterator iter23 = XmlUtil.getAllAttributes((Element)e2);
                while (iter23.hasNext()) {
                    e32 = (Attr)iter23.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, output, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        output.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    Util.fail("parsing.invalidElement", e3.getTagName(), e3.getNamespaceURI());
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_FAULT)) {
                context.push();
                context.registerNamespaces(e2);
                Fault fault = new Fault();
                fault.setParent(operation);
                messageAttr = Util.getRequiredAttribute(e2, "message");
                fault.setMessage(context.translateQualifiedName(messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                fault.setName(nameAttr);
                operation.addFault(fault);
                gotFault = true;
                Iterator iter24 = XmlUtil.getAllAttributes((Element)e2);
                while (iter24.hasNext()) {
                    e32 = (Attr)iter24.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, fault, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        if (fault.getDocumentation() != null) continue;
                        fault.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, fault, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, operation, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        if (gotInput && !gotOutput && !gotFault) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (gotInput && gotOutput && inputBeforeOutput) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (gotInput && gotOutput && !inputBeforeOutput) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (gotOutput && !gotInput && !gotFault) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", name);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    protected Binding parseBinding(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Binding binding = new Binding(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        binding.setName(name);
        String typeAttr = Util.getRequiredAttribute(e, "type");
        binding.setPortType(context.translateQualifiedName(typeAttr));
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                binding.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OPERATION)) {
                BindingOperation op = this.parseBindingOperation(context, e2);
                binding.add(op);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, binding, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_BINDING, binding);
        return binding;
    }

    protected BindingOperation parseBindingOperation(TWSDLParserContextImpl context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        BindingOperation operation = new BindingOperation();
        String name = Util.getRequiredAttribute(e, "name");
        operation.setName(name);
        boolean gotDocumentation = false;
        boolean gotInput = false;
        boolean gotOutput = false;
        boolean gotFault = false;
        boolean inputBeforeOutput = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            Iterator iter2;
            String nameAttr;
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                operation.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_INPUT)) {
                Element e3;
                if (gotInput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"input", "operation", name});
                }
                Iterator itere2 = XmlUtil.getAllChildren((Element)e2);
                Element ee = Util.nextElement(itere2);
                context.push();
                context.registerNamespaces(e2);
                BindingInput input = new BindingInput();
                String nameAttr2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                input.setName(nameAttr2);
                operation.setInput(input);
                gotInput = true;
                if (gotOutput) {
                    inputBeforeOutput = false;
                }
                boolean gotDocumentation2 = false;
                Iterator iter22 = XmlUtil.getAllChildren((Element)e2);
                while (iter22.hasNext() && (e3 = Util.nextElement(iter22)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        input.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, input, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OUTPUT)) {
                Element e3;
                if (gotOutput) {
                    Util.fail("parsing.tooManyElements", new Object[]{"output", "operation", name});
                }
                context.push();
                context.registerNamespaces(e2);
                BindingOutput output = new BindingOutput();
                nameAttr = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                output.setName(nameAttr);
                operation.setOutput(output);
                gotOutput = true;
                if (gotInput) {
                    inputBeforeOutput = true;
                }
                boolean gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        output.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, output, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_FAULT)) {
                Element e3;
                context.push();
                context.registerNamespaces(e2);
                BindingFault fault = new BindingFault();
                nameAttr = Util.getRequiredAttribute(e2, "name");
                fault.setName(nameAttr);
                operation.addFault(fault);
                gotFault = true;
                boolean gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                        }
                        gotDocumentation2 = true;
                        if (fault.getDocumentation() != null) continue;
                        fault.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, fault, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, operation, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        if (gotInput && !gotOutput && !gotFault) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (gotInput && gotOutput && inputBeforeOutput) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (gotInput && gotOutput && !inputBeforeOutput) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (gotOutput && !gotInput && !gotFault) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            Util.fail("parsing.invalidOperationStyle", name);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    protected Import parseImport(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Import anImport = new Import();
        String namespace = Util.getRequiredAttribute(e, "namespace");
        anImport.setNamespace(namespace);
        String location = Util.getRequiredAttribute(e, "location");
        anImport.setLocation(location);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                anImport.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_IMPORT, anImport);
        return anImport;
    }

    protected Service parseService(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Service service = new Service(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        service.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (service.getDocumentation() != null) continue;
                service.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PORT)) {
                Port port = this.parsePort(context, definitions, e2);
                service.add(port);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, service, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_SERVICE, service);
        return service;
    }

    protected Port parsePort(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Port port = new Port(definitions);
        String name = Util.getRequiredAttribute(e, "name");
        port.setName(name);
        String bindingAttr = Util.getRequiredAttribute(e, "binding");
        port.setBinding(context.translateQualifiedName(bindingAttr));
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                if (port.getDocumentation() != null) continue;
                port.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, port, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PORT, port);
        return port;
    }

    private void addSchemaElements(Element typesElement) {
        Element e;
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)typesElement);
        while (iter.hasNext() && (e = Util.nextElement(iter)) != null) {
            if (gotDocumentation) {
                Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
            }
            if (XmlUtil.matchesTagNS(e, SchemaConstants.QNAME_IMPORT)) {
                this.env.warn(WsdlMessages.localizableWARNING_WSI_R_2003());
                continue;
            }
            this.checkNotWsdlElement(e);
            if (!XmlUtil.matchesTagNS(e, SchemaConstants.QNAME_SCHEMA)) continue;
            this.schemaElements.add(e);
        }
    }

    public List getSchemaElements() {
        return this.schemaElements;
    }

    protected boolean handleExtension(TWSDLParserContextImpl context, TWSDLExtensible entity, Element e) {
        TWSDLExtensionHandler h = (TWSDLExtensionHandler)this.extensionHandlers.get(e.getNamespaceURI());
        if (h == null) {
            context.fireIgnoringExtension(new QName(e.getNamespaceURI(), e.getLocalName()), ((Entity)((Object)entity)).getElementName());
            return false;
        }
        return h.doHandleExtension(context, entity, e);
    }

    protected boolean handleExtension(TWSDLParserContextImpl context, TWSDLExtensible entity, Node n, Element e) {
        TWSDLExtensionHandler h = (TWSDLExtensionHandler)this.extensionHandlers.get(n.getNamespaceURI());
        if (h == null) {
            context.fireIgnoringExtension(new QName(n.getNamespaceURI(), n.getLocalName()), ((Entity)((Object)entity)).getElementName());
            return false;
        }
        return h.doHandleExtension(context, entity, e);
    }

    protected void checkNotWsdlElement(Element e) {
        if (e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            Util.fail("parsing.invalidWsdlElement", e.getTagName());
        }
    }

    protected void checkNotWsdlAttribute(Attr a) {
        if (a.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            Util.fail("parsing.invalidWsdlElement", a.getLocalName());
        }
    }

    protected void checkNotWsdlRequired(Element e) {
        String required = XmlUtil.getAttributeNSOrNull((Element)e, (String)"required", (String)"http://schemas.xmlsoap.org/wsdl/");
        if (required != null && required.equals("true")) {
            Util.fail("parsing.requiredExtensibilityElement", e.getTagName(), e.getNamespaceURI());
        }
    }

    protected Documentation getDocumentationFor(Element e) {
        String s = XmlUtil.getTextForNode((Node)e);
        if (s == null) {
            return null;
        }
        return new Documentation(s);
    }
}

