/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.ws.server.provider.ProviderEndpointModel;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.http.HTTPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XMLProviderArgumentBuilder<T>
extends ProviderArgumentsBuilder<T> {
    XMLProviderArgumentBuilder() {
    }

    @Override
    protected void updateResponse(Packet response, Exception e) {
        if (e instanceof HTTPException && response.supports("javax.xml.ws.http.response.code")) {
            response.put("javax.xml.ws.http.response.code", ((HTTPException)e).getStatusCode());
        }
    }

    static XMLProviderArgumentBuilder create(ProviderEndpointModel model) {
        if (model.getServiceMode() == Service.Mode.PAYLOAD) {
            return new PayloadSource();
        }
        return model.isSource() ? new PayloadSource() : new DataSourceParameter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DataSourceParameter
    extends XMLProviderArgumentBuilder<DataSource> {
        private DataSourceParameter() {
        }

        @Override
        public DataSource getParameter(Message msg) {
            return msg instanceof XMLMessage.MessageDataSource ? ((XMLMessage.MessageDataSource)((Object)msg)).getDataSource() : XMLMessage.getDataSource(msg);
        }

        @Override
        public Message getResponse(DataSource ds) {
            return XMLMessage.create(ds);
        }

        @Override
        protected Message getResponseMessage(Exception e) {
            return XMLMessage.create(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PayloadSource
    extends XMLProviderArgumentBuilder<Source> {
        private PayloadSource() {
        }

        @Override
        public Source getParameter(Message msg) {
            return msg.readPayloadAsSource();
        }

        @Override
        public Message getResponse(Source source) {
            return Messages.createUsingPayload(source, SOAPVersion.SOAP_11);
        }

        @Override
        protected Message getResponseMessage(Exception e) {
            return XMLMessage.create(e);
        }
    }
}

