/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.AsyncProvider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProviderEndpointModel<T> {
    private final boolean isSource;
    private final Service.Mode mode;
    private final boolean isAsync;

    ProviderEndpointModel(Class<T> implementorClass, WSBinding binding) {
        assert (implementorClass != null);
        assert (binding != null);
        this.mode = ProviderEndpointModel.getServiceMode(implementorClass);
        Class otherClass = binding instanceof SOAPBinding ? SOAPMessage.class : DataSource.class;
        this.isAsync = AsyncProvider.class.isAssignableFrom(implementorClass);
        this.isSource = ProviderEndpointModel.isSource(this.isAsync ? AsyncProvider.class : Provider.class, implementorClass, otherClass);
        if (this.mode == Service.Mode.PAYLOAD && !this.isSource) {
            throw new IllegalArgumentException("Illeagal combination - Mode.PAYLOAD and Provider<" + otherClass.getName() + ">");
        }
    }

    public boolean isSource() {
        return this.isSource;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public Service.Mode getServiceMode() {
        return this.mode;
    }

    private static Service.Mode getServiceMode(Class<?> c) {
        ServiceMode mode = c.getAnnotation(ServiceMode.class);
        if (mode == null) {
            return Service.Mode.PAYLOAD;
        }
        return mode.value();
    }

    private static boolean isSource(Class provider, Class c, Class otherClass) {
        Type base = JAXBRIContext.getBaseType((Type)c, (Class)provider);
        assert (base != null);
        if (base instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)base;
            Type[] types = pt.getActualTypeArguments();
            if (types[0] instanceof Class && Source.class.isAssignableFrom((Class)types[0])) {
                return true;
            }
            if (types[0] instanceof Class && otherClass.isAssignableFrom((Class)types[0])) {
                return false;
            }
        }
        throw new IllegalArgumentException("Endpoint should implement Provider<" + Source.class.getName() + "> or Provider<" + otherClass.getName() + ">");
    }
}

