/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.DispatchImpl;
import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.message.source.PayloadSourceMessage;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceDispatch
extends DispatchImpl<Source> {
    public SourceDispatch(QName port, Service.Mode mode, WSServiceDelegate owner, Tube pipe, BindingImpl binding, WSEndpointReference epr) {
        super(port, mode, owner, pipe, binding, epr);
    }

    @Override
    Source toReturnValue(Packet response) {
        Message msg = response.getMessage();
        switch (this.mode) {
            case PAYLOAD: {
                if (SourceDispatch.isXMLHttp(this.binding)) {
                    try {
                        return new StreamSource(XMLMessage.getDataSource(msg).getInputStream());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return msg.readPayloadAsSource();
            }
            case MESSAGE: {
                if (SourceDispatch.isXMLHttp(this.binding)) {
                    try {
                        return new StreamSource(XMLMessage.getDataSource(msg).getInputStream());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return msg.readEnvelopeAsSource();
            }
        }
        throw new WebServiceException("Unrecognized dispatch mode");
    }

    @Override
    Packet createPacket(Source msg) {
        Message message;
        switch (this.mode) {
            case PAYLOAD: {
                message = msg == null ? Messages.createEmpty(this.soapVersion) : new PayloadSourceMessage(null, msg, this.setOutboundAttachments(), this.soapVersion);
                break;
            }
            case MESSAGE: {
                if (SourceDispatch.isXMLHttp(this.binding)) {
                    message = msg == null ? Messages.createEmpty(this.soapVersion) : new PayloadSourceMessage(null, msg, this.setOutboundAttachments(), this.soapVersion);
                    break;
                }
                message = Messages.create(msg, this.soapVersion);
                break;
            }
            default: {
                throw new WebServiceException("Unrecognized message mode");
            }
        }
        return new Packet(message);
    }
}

