/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.developer.MemberSubmissionAddressing;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.ws.developer.Stateful;
import com.sun.xml.ws.developer.StatefulFeature;
import com.sun.xml.ws.model.RuntimeModelerException;
import com.sun.xml.ws.resources.ModelerMessages;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebServiceFeatureList
implements WSFeatureList {
    private Map<Class<? extends WebServiceFeature>, WebServiceFeature> wsfeatures = new HashMap<Class<? extends WebServiceFeature>, WebServiceFeature>();

    public WebServiceFeatureList() {
    }

    public WebServiceFeatureList(WebServiceFeature ... features) {
        if (features != null) {
            for (WebServiceFeature f : features) {
                this.wsfeatures.put(f.getClass(), f);
            }
        }
    }

    public WebServiceFeatureList(@NotNull Class<?> endpointClass) {
        this.parseAnnotations(endpointClass);
    }

    public void parseAnnotations(Class<?> endpointClass) {
        for (Annotation a : endpointClass.getAnnotations()) {
            Object ftr;
            Object addAnn;
            if (!a.annotationType().isAnnotationPresent(WebServiceFeatureAnnotation.class)) continue;
            if (a instanceof Addressing) {
                addAnn = (Addressing)a;
                ftr = new AddressingFeature(addAnn.enabled(), addAnn.required());
            } else if (a instanceof MemberSubmissionAddressing) {
                addAnn = (MemberSubmissionAddressing)a;
                ftr = new MemberSubmissionAddressingFeature(addAnn.enabled(), addAnn.required());
            } else if (a instanceof MTOM) {
                MTOM mtomAnn = (MTOM)a;
                ftr = new MTOMFeature(mtomAnn.enabled(), mtomAnn.threshold());
                BindingID bindingID = BindingID.parse(endpointClass);
                MTOMFeature bindingMtomSetting = bindingID.createBuiltinFeatureList().get(MTOMFeature.class);
                if (bindingMtomSetting != null && bindingMtomSetting.isEnabled() ^ ftr.isEnabled()) {
                    throw new RuntimeModelerException(ModelerMessages.RUNTIME_MODELER_MTOM_CONFLICT(bindingID, ftr.isEnabled()), new Object[0]);
                }
            } else if (a instanceof RespectBinding) {
                RespectBinding rbAnn = (RespectBinding)a;
                ftr = new RespectBindingFeature(rbAnn.enabled());
            } else if (a instanceof Stateful) {
                ftr = new StatefulFeature();
            } else {
                throw new WebServiceException("Unrecognized annotation:" + a);
            }
            this.add((WebServiceFeature)ftr);
        }
    }

    @Override
    public Iterator<WebServiceFeature> iterator() {
        return this.wsfeatures.values().iterator();
    }

    @Override
    @NotNull
    public WebServiceFeature[] toArray() {
        return this.wsfeatures.values().toArray(new WebServiceFeature[0]);
    }

    @Override
    public boolean isEnabled(String featureId) {
        WebServiceFeature ftr = this.get(featureId);
        if (ftr == null) {
            return false;
        }
        return ftr.isEnabled();
    }

    @Override
    public boolean isEnabled(@NotNull Class<? extends WebServiceFeature> feature) {
        WebServiceFeature ftr = this.get(feature);
        if (ftr == null) {
            return false;
        }
        return ftr.isEnabled();
    }

    @Override
    @Nullable
    public WebServiceFeature get(String featureId) {
        if (featureId == null) {
            return null;
        }
        for (WebServiceFeature f : this.wsfeatures.values()) {
            if (!f.getID().equals(featureId)) continue;
            return f;
        }
        return null;
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F get(@NotNull Class<F> featureType) {
        return (F)((WebServiceFeature)featureType.cast(this.wsfeatures.get(featureType)));
    }

    public void add(@NotNull WebServiceFeature f) {
        if (!this.wsfeatures.containsKey(f.getClass())) {
            this.wsfeatures.put(f.getClass(), f);
        }
    }

    public void addAll(@NotNull WSFeatureList list) {
        for (WebServiceFeature f : list) {
            this.add(f);
        }
    }

    public void mergeFeatures(@NotNull WSDLPort wsdlPort, boolean honorWsdlRequired, boolean reportConflicts) {
        if (honorWsdlRequired && !this.isEnabled(RespectBindingFeature.class)) {
            return;
        }
        if (!honorWsdlRequired) {
            this.addAll(wsdlPort.getFeatures());
            return;
        }
        for (WebServiceFeature wsdlFtr : wsdlPort.getFeatures()) {
            if (this.get(wsdlFtr.getClass()) == null) {
                try {
                    Method m = wsdlFtr.getClass().getMethod("isRequired", new Class[0]);
                    try {
                        boolean required = (Boolean)m.invoke((Object)wsdlFtr, new Object[0]);
                        if (!required) continue;
                        this.add(wsdlFtr);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new WebServiceException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new WebServiceException((Throwable)e);
                    }
                }
                catch (NoSuchMethodException e) {
                    this.add(wsdlFtr);
                    continue;
                }
            }
            if (!reportConflicts || this.isEnabled(wsdlFtr.getID()) == wsdlFtr.isEnabled()) continue;
            throw new RuntimeModelerException(ModelerMessages.localizableRUNTIME_MODELER_FEATURE_CONFLICT(this.get(wsdlFtr.getClass()), wsdlFtr));
        }
    }
}

