/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.W3CAddressingConstants;
import com.sun.xml.ws.addressing.WsaTube;
import com.sun.xml.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.ws.addressing.model.InvalidMapException;
import com.sun.xml.ws.addressing.model.MapRequiredException;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.ws.resources.AddressingMessages;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

public final class WsaServerTube
extends WsaTube {
    private WSEndpointReference replyTo;
    private WSEndpointReference faultTo;
    public static final String REQUEST_MESSAGE_ID = "com.sun.xml.ws.addressing.request.messageID";
    private static final Logger LOGGER = Logger.getLogger(WsaServerTube.class.getName());

    public WsaServerTube(@NotNull WSDLPort wsdlPort, WSBinding binding, Tube next) {
        super(wsdlPort, binding, next);
    }

    public WsaServerTube(WsaServerTube that, TubeCloner cloner) {
        super(that, cloner);
    }

    public WsaServerTube copy(TubeCloner cloner) {
        return new WsaServerTube(this, cloner);
    }

    @NotNull
    public NextAction processRequest(Packet request) {
        Packet p;
        Message msg = request.getMessage();
        if (msg == null) {
            return this.doInvoke(this.next, request);
        }
        HeaderList hl = request.getMessage().getHeaders();
        this.replyTo = hl.getReplyTo(this.addressingVersion, this.soapVersion);
        this.faultTo = hl.getFaultTo(this.addressingVersion, this.soapVersion);
        String messageId = hl.getMessageID(this.addressingVersion, this.soapVersion);
        request.invocationProperties.put(REQUEST_MESSAGE_ID, messageId);
        if (this.replyTo == null) {
            this.replyTo = this.addressingVersion.anonymousEpr;
        }
        if (this.faultTo == null) {
            this.faultTo = this.replyTo;
        }
        if (!this.faultTo.isAnonymous() && !this.replyTo.isAnonymous() && request.transportBackChannel != null) {
            request.transportBackChannel.close();
        }
        if ((p = this.validateInboundHeaders(request)).getMessage() == null) {
            return this.doReturnWith(p);
        }
        if (p.getMessage().isFault()) {
            return this.processResponse(p);
        }
        return this.doInvoke(this.next, p);
    }

    @NotNull
    public NextAction processResponse(Packet response) {
        WSEndpointReference target;
        Message msg = response.getMessage();
        if (msg == null) {
            return this.doReturnWith(response);
        }
        WSEndpointReference wSEndpointReference = target = msg.isFault() ? this.faultTo : this.replyTo;
        if (target.isAnonymous()) {
            return this.doReturnWith(response);
        }
        if (target.isNone()) {
            response.setMessage(null);
            return this.doReturnWith(response);
        }
        this.processNonAnonymousReply(response, target);
        response.setMessage(null);
        return this.doReturnWith(response);
    }

    private void processNonAnonymousReply(Packet packet, WSEndpointReference target) {
        if (packet.transportBackChannel != null) {
            packet.transportBackChannel.close();
        }
        if (packet.getMessage().isOneWay(this.wsdlPort)) {
            LOGGER.fine(AddressingMessages.NON_ANONYMOUS_RESPONSE_ONEWAY());
            return;
        }
        EndpointAddress adrs = new EndpointAddress(URI.create(target.getAddress()));
        Tube transport = TransportTubeFactory.create(Thread.currentThread().getContextClassLoader(), new ClientTubeAssemblerContext(adrs, this.wsdlPort, null, this.binding));
        packet.endpointAddress = adrs;
        Fiber.current().runSync(transport, packet);
    }

    public void validateAction(Packet packet) {
        WSDLBoundOperation wbo = this.getWSDLBoundOperation(packet);
        if (wbo == null) {
            return;
        }
        String gotA = packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
        if (gotA == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_SERVER_NULL_ACTION());
        }
        String expected = this.helper.getInputAction(packet);
        String soapAction = this.helper.getSOAPAction(packet);
        if (this.helper.isInputActionDefault(packet) && soapAction != null && !soapAction.equals("")) {
            expected = soapAction;
        }
        if (expected != null && !gotA.equals(expected)) {
            throw new ActionNotSupportedException(gotA);
        }
    }

    protected void checkMandatoryHeaders(Packet packet, boolean foundAction, boolean foundTo, boolean foundRelatesTo, boolean foundMessageID) {
        if (!foundAction) {
            throw new MapRequiredException(this.addressingVersion.actionTag);
        }
        if (!foundTo) {
            throw new MapRequiredException(this.addressingVersion.toTag);
        }
        if (!foundMessageID && !packet.getMessage().isOneWay(this.wsdlPort)) {
            throw new MapRequiredException(this.addressingVersion.messageIDTag);
        }
    }

    public void checkCardinality(Packet packet) {
        super.checkCardinality(packet);
        WSDLBoundOperation wbo = this.getWSDLBoundOperation(packet);
        this.checkAnonymousSemantics(wbo, this.replyTo, this.faultTo);
    }

    final void checkAnonymousSemantics(WSDLBoundOperation wbo, WSEndpointReference replyTo, WSEndpointReference faultTo) {
        if (this.addressingVersion == null || this.addressingVersion == AddressingVersion.MEMBER) {
            return;
        }
        if (wbo == null) {
            return;
        }
        WSDLBoundOperationImpl impl = (WSDLBoundOperationImpl)wbo;
        WSDLBoundOperation.ANONYMOUS anon = impl.getAnonymous();
        String replyToValue = null;
        String faultToValue = null;
        if (replyTo != null) {
            replyToValue = replyTo.getAddress();
        }
        if (faultTo != null) {
            faultToValue = faultTo.getAddress();
        }
        switch (anon) {
            case optional: {
                break;
            }
            case prohibited: {
                if (replyToValue != null && replyToValue.equals(this.addressingVersion.anonymousUri)) {
                    throw new InvalidMapException(this.addressingVersion.replyToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (faultToValue == null || !faultToValue.equals(this.addressingVersion.anonymousUri)) break;
                throw new InvalidMapException(this.addressingVersion.faultToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
            }
            case required: {
                if (replyToValue != null && !replyToValue.equals(this.addressingVersion.anonymousUri)) {
                    throw new InvalidMapException(this.addressingVersion.replyToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (faultToValue == null || faultToValue.equals(this.addressingVersion.anonymousUri)) break;
                throw new InvalidMapException(this.addressingVersion.faultToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
            }
            default: {
                throw new WebServiceException(AddressingMessages.INVALID_WSAW_ANONYMOUS(anon.toString()));
            }
        }
    }
}

