/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jvnet.jax_ws_commons.jaxws.AbstractWsGenMojo;

@Mojo(name="wsgen", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class MainWsGenMojo
extends AbstractWsGenMojo {
    @Parameter(defaultValue="false")
    protected boolean genWsdl;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File destDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/wsgen")
    private File sourceDestDir;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/wsdl")
    private File resourceDestDir;

    @Override
    protected File getDestDir() {
        return this.destDir;
    }

    @Override
    protected File getSourceDestDir() {
        return this.sourceDestDir;
    }

    @Override
    protected File getResourceDestDir() {
        return this.resourceDestDir;
    }

    @Override
    protected File getDefaultSrcOut() {
        return new File(this.project.getBuild().getDirectory(), "generated-sources/wsgen");
    }

    @Override
    protected File getClassesDir() {
        return new File(this.project.getBuild().getOutputDirectory());
    }

    @Override
    protected boolean getGenWSDL() {
        return this.genWsdl;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.getGenWSDL()) {
            try {
                this.attachWsdl();
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to execute wsgen", (Exception)ex);
            }
        }
    }

    private void attachWsdl() throws IOException {
        File target = new File(this.project.getBuild().getDirectory());
        if (!"war".equalsIgnoreCase(this.project.getPackaging())) {
            target = new File(this.project.getBuild().getOutputDirectory(), "META-INF/wsdl");
        } else {
            String targetPath = null;
            Plugin war = (Plugin)this.project.getBuild().getPluginsAsMap().get("org.apache.maven.plugins:maven-war-plugin");
            for (PluginExecution exec : war.getExecutions()) {
                String s = this.getWebappDirectory(exec.getConfiguration());
                if (s == null) continue;
                targetPath = s;
                break;
            }
            if (targetPath == null) {
                targetPath = this.getWebappDirectory(war.getConfiguration());
            }
            target = targetPath != null ? new File(targetPath) : new File(target, this.project.getBuild().getFinalName());
            target = new File(target, "WEB-INF/wsdl");
        }
        if (!target.mkdirs() && !target.exists()) {
            this.getLog().warn((CharSequence)("Cannot create directory: " + target.getAbsolutePath()));
        }
        this.getLog().debug((CharSequence)("Packaging WSDL(s) to: " + target));
        FileUtils.copyDirectory((File)this.getResourceDestDir(), (File)target);
    }

    private String getWebappDirectory(Object conf) {
        if (conf == null) {
            return null;
        }
        Xpp3Dom el = ((Xpp3Dom)conf).getChild("webappDirectory");
        return el != null ? el.getValue() : null;
    }
}

