/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.jvnet.jax_ws_commons.jaxws.AbstractJaxwsMojo;

abstract class AbstractWsGenMojo
extends AbstractJaxwsMojo {
    @Parameter
    private List<String> seis;
    @Parameter
    private String sei;
    @Parameter
    private String protocol;
    @Parameter
    private String servicename;
    @Parameter
    private String portname;
    @Parameter(defaultValue="false")
    private boolean inlineSchemas;
    @Parameter(defaultValue="false")
    private boolean xnocompile;
    @Parameter(defaultValue="false")
    private boolean xdonotoverwrite;
    @Parameter
    private File metadata;

    AbstractWsGenMojo() {
    }

    protected abstract File getResourceDestDir();

    protected abstract File getClassesDir();

    protected abstract boolean getGenWSDL();

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<String> allSeis = new HashSet<String>();
        if (this.seis != null && !this.seis.isEmpty()) {
            allSeis.addAll(this.seis);
        }
        if (this.sei != null && !allSeis.add(this.sei)) {
            this.getLog().warn((CharSequence)("'" + this.sei + "' was already added"));
        }
        if (allSeis.isEmpty()) {
            allSeis.addAll(this.getSEIs(this.getClassesDir()));
        }
        if (allSeis.isEmpty()) {
            throw new MojoFailureException("No @javax.jws.WebService found.");
        }
        for (String aSei : allSeis) {
            this.processSei(aSei);
        }
    }

    protected void processSei(String sei) throws MojoExecutionException {
        if (this.buildContext.hasDelta(new File(this.getClassesDir(), sei.replace('.', '/') + ".class")) || this.metadata != null && this.buildContext.hasDelta(this.metadata)) {
            this.getLog().info((CharSequence)("Processing: " + sei));
            List<String> args = this.getWsGenArgs(sei, true);
            this.getLog().info((CharSequence)("jaxws:wsgen args: " + args));
            this.exec(args);
            if (this.metadata != null) {
                try {
                    FileUtils.copyFileToDirectory((File)this.metadata, (File)this.getClassesDir());
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
                }
            }
        }
    }

    @Override
    protected String getMain() {
        return "com.sun.tools.ws.wscompile.WsgenTool";
    }

    @Override
    protected String getExtraClasspath() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClassesDir().getAbsolutePath());
        for (Artifact a : this.project.getArtifacts()) {
            buf.append(File.pathSeparatorChar);
            buf.append(a.getFile().getAbsolutePath());
        }
        return buf.toString();
    }

    @Override
    protected boolean getXnocompile() {
        return this.xnocompile;
    }

    protected List<String> getWsGenArgs(String aSei, boolean attachResources) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>(this.getCommonArgs());
        if (this.getGenWSDL()) {
            File resourceDir;
            if (this.protocol != null) {
                args.add("-wsdl:" + this.protocol);
            } else {
                args.add("-wsdl");
            }
            if (this.inlineSchemas) {
                this.maybeUnsupportedOption("-inlineSchemas", null, args);
            }
            if (this.servicename != null) {
                args.add("-servicename");
                args.add(this.servicename);
            }
            if (this.portname != null) {
                args.add("-portname");
                args.add(this.portname);
            }
            if (!(resourceDir = this.getResourceDestDir()).mkdirs() && !resourceDir.exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + resourceDir.getAbsolutePath()));
            }
            args.add("-r");
            args.add("'" + resourceDir.getAbsolutePath() + "'");
            if (attachResources && !"war".equals(this.project.getPackaging())) {
                Resource r = new Resource();
                r.setDirectory(this.getRelativePath(this.project.getBasedir(), this.getResourceDestDir()));
                this.project.addResource(r);
            }
        }
        if (this.xdonotoverwrite) {
            args.add("-Xdonotoverwrite");
        }
        if (this.metadata != null && this.isArgSupported("-x")) {
            this.maybeUnsupportedOption("-x", "'" + this.metadata.getAbsolutePath() + "'", args);
        }
        args.add(aSei);
        this.getLog().debug((CharSequence)("jaxws:wsgen args: " + args));
        return args;
    }

    private String getRelativePath(File root, File f) {
        return root.toURI().relativize(f.toURI()).getPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getSEIs(File directory) throws MojoExecutionException {
        HashSet<String> seis = new HashSet<String>();
        if (!directory.exists() || directory.isFile()) {
            return seis;
        }
        URLClassLoader cl = null;
        try {
            cl = new URLClassLoader(new URL[]{directory.toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
            for (String s : FileUtils.getFileAndDirectoryNames((File)directory, (String)"**/*.class", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false)) {
                try {
                    String clsName = s.replace(File.separator, ".");
                    Class<?> c = cl.loadClass(clsName.substring(0, clsName.length() - 6));
                    if (c.isInterface() || !c.isAnnotationPresent(WebService.class)) continue;
                    seis.add(c.getName());
                }
                catch (ClassNotFoundException ex) {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                    return seis;
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        finally {
            if (cl instanceof Closeable) {
                try {
                    ((Closeable)cl).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

