/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.async_client_transport;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.util.Pool;
import java.io.Closeable;
import javax.xml.ws.WebServiceException;

public class RequestSender
implements Closeable {
    private final Tube masterTubeline;
    private Pool<Tube> tubelinePool;
    private volatile Engine engine;

    public RequestSender(String name, Tube tubeline) {
        this.masterTubeline = tubeline;
        this.engine = new Engine(name);
        this.tubelinePool = new Pool.TubePool(this.masterTubeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet send(Packet request) {
        if (this.tubelinePool == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Tube tubeline = (Tube)this.tubelinePool.take();
        try {
            Packet packet = this.engine.createFiber().runSync(tubeline, request);
            return packet;
        }
        finally {
            this.tubelinePool.recycle((Object)tubeline);
        }
    }

    public void sendAsync(Packet request, final Fiber.CompletionCallback completionCallback) {
        if (this.tubelinePool == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Fiber fiber = this.engine.createFiber();
        final Tube tube = (Tube)this.tubelinePool.take();
        fiber.start(tube, request, new Fiber.CompletionCallback(){

            public void onCompletion(@NotNull Packet response) {
                RequestSender.this.tubelinePool.recycle((Object)tube);
                completionCallback.onCompletion(response);
            }

            public void onCompletion(@NotNull Throwable error) {
                completionCallback.onCompletion(error);
            }
        });
    }

    @Override
    public void close() {
        if (this.tubelinePool != null) {
            Tube p = (Tube)this.tubelinePool.take();
            this.tubelinePool = null;
            p.preDestroy();
        }
    }
}

