/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer.stax;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import java.io.StringReader;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.xml.sax.XMLReader;

public class OverrideNamespaceTest
extends TestCase {
    public OverrideNamespaceTest(String testName) {
        super(testName);
    }

    public void testOverrideNamespace() throws Exception {
        String[] startElement = new String[]{"definitions", "types", "binding"};
        String[] startElement_namespaces = new String[]{"http://wsdl", "http://types", "http://wsdl"};
        String[] endElement = new String[]{"types", "binding", "definitions"};
        String[] endElement_namespaces = new String[]{"http://types", "http://wsdl", "http://wsdl"};
        String str = "<tns:definitions xmlns:tns='http://wsdl'><tns:types xmlns:tns='http://types'/><tns:binding/></tns:definitions>";
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(str));
        XMLStreamBuffer xsb = XMLStreamBuffer.createNewBufferFromXMLStreamReader(rdr);
        StreamReaderBufferProcessor xsbrdr = xsb.readAsXMLStreamReader();
        int i = 0;
        int j = 0;
        while (xsbrdr.hasNext()) {
            int event = xsbrdr.next();
            if (event == 1) {
                OverrideNamespaceTest.assertEquals((String)("Start of Element " + xsbrdr.getName() + " has wrong namespace"), (String)startElement_namespaces[i], (String)xsbrdr.getNamespaceURI("tns"));
                OverrideNamespaceTest.assertEquals((String)startElement[i++], (String)xsbrdr.getLocalName());
                continue;
            }
            if (event != 2) continue;
            OverrideNamespaceTest.assertEquals((String)("End of Element " + xsbrdr.getName() + " has wrong namespace"), (String)endElement_namespaces[j], (String)xsbrdr.getNamespaceURI("tns"));
            OverrideNamespaceTest.assertEquals((String)endElement[j++], (String)xsbrdr.getLocalName());
        }
    }

    public void testOverrideNamespace1() throws Exception {
        LinkedHashMap<String, String> ns = new LinkedHashMap<String, String>();
        ns.put("definitions", "http://wsdl");
        ns.put("types", "http://types");
        ns.put("binding", "http://wsdl");
        ns.put("operation", "http://operation");
        ns.put("port", "http://wsdl");
        String str = "<tns:definitions xmlns:tns='http://wsdl'><tns:types xmlns:tns='http://types'/><tns:binding><tns:operation xmlns:tns='http://operation'/></tns:binding><tns:port/></tns:definitions>";
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(str));
        XMLStreamBuffer xsb = XMLStreamBuffer.createNewBufferFromXMLStreamReader(rdr);
        StreamReaderBufferProcessor xsbrdr = xsb.readAsXMLStreamReader();
        Iterator nsItr = ns.keySet().iterator();
        while (xsbrdr.hasNext()) {
            int event = xsbrdr.next();
            if (event == 1) {
                OverrideNamespaceTest.assertEquals((String)"Wrong Start of Element", (String)((String)nsItr.next()), (String)xsbrdr.getLocalName());
                OverrideNamespaceTest.assertEquals((String)("Start of Element " + xsbrdr.getName() + " has wrong namespace"), (String)((String)ns.get(xsbrdr.getLocalName())), (String)xsbrdr.getNamespaceURI("tns"));
                continue;
            }
            if (event != 2) continue;
            OverrideNamespaceTest.assertEquals((String)("End of Element " + xsbrdr.getName() + " has wrong namespace"), (String)((String)ns.get(xsbrdr.getLocalName())), (String)xsbrdr.getNamespaceURI("tns"));
        }
    }

    public void testNamespaceScope1() throws Exception {
        String str = "<html:html xmlns:html='http://www.w3.org/1999/xhtml'><html:head><html:title>Frobnostication</html:title></html:head><html:body><html:p><html:a href='http://frob.example.com'>here.</html:a></html:p></html:body></html:html>";
        this.useReaderForTesting(str, "html");
    }

    public void testNamespaceScope2() throws Exception {
        String str = "<book xmlns='urn:loc.gov:books' xmlns:isbn='urn:ISBN:0-395-36341-6'><title>Cheaper by the Dozen</title><isbn:number>1568491379</isbn:number><notes><!-- make HTML the default namespace for some commentary --><p xmlns='http://www.w3.org/1999/xhtml'>This is a <i>funny</i> book!</p></notes></book>";
        this.useReaderForTesting(str, "", "isbn");
    }

    public void testNamespaceScope3() throws Exception {
        String str = "<Beers><!-- the default namespace inside tables is that of HTML --><table xmlns='http://www.w3.org/1999/xhtml'><th><td>Name</td><td>Origin</td><td>Description</td></th><tr><!-- no default namespace inside table cells --><td><brandName xmlns=''>Huntsman</brandName></td><td><origin xmlns=''>Bath, UK</origin></td><td><details xmlns=''><class>Bitter</class><hop>Fuggles</hop><pro>Wonderful hop, light alcohol, good summer beer</pro><con>Fragile; excessive variance pub to pub</con></details></td></tr></table></Beers>";
        this.useReaderForTesting(str, "");
    }

    public void testNamespaceScope4() throws Exception {
        String str = "<Beers><table xmlns:A='A' xmlns:B='B' xmlns='http://www.w3.org/1999/xhtml'><th xmlns:A='A1' xmlns:P='P' xmlns:Q='Q'></th><tr><td><brandName xmlns:P='P1' xmlns:R='R'>Huntsman</brandName></td><td><origin xmlns:R='R1'>Bath, UK</origin></td><td/></tr><th xmlns:B='B1' xmlns:P='P2' xmlns:Q='Q1'></th></table></Beers>";
        this.useReaderForTesting(str, "", "A", "B", "P", "Q", "R");
    }

    public void testInscopeNamespaces() throws Exception {
        String name;
        String str = "<S:Envelope xmlns:S='http://schemas.xmlsoap.org/soap/envelope/' xmlns:ns4='A'><S:Body xmlns:ns4='http://schemas.xmlsoap.org/soap/envelope/'><S:Fault><faultcode>ns4:Server</faultcode><faultstring>com.sun.istack.XMLStreamException2</faultstring></S:Fault></S:Body></S:Envelope>";
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(str));
        rdr.nextTag();
        rdr.nextTag();
        rdr.nextTag();
        MutableXMLStreamBuffer xsb = new MutableXMLStreamBuffer();
        StreamReaderBufferCreator c = new StreamReaderBufferCreator(xsb);
        String[] envNs = new String[]{"S", "http://schemas.xmlsoap.org/soap/envelope/", "ns4", "A"};
        c.storeElement("http://schemas.xmlsoap.org/soap/envelope/", "Envelope", "S", envNs);
        String[] bodyNs = new String[]{"ns4", "http://schemas.xmlsoap.org/soap/envelope/"};
        c.storeElement("http://schemas.xmlsoap.org/soap/envelope/", "Body", "S", bodyNs);
        while (rdr.getEventType() != 8 && !(name = rdr.getLocalName()).equals("Body")) {
            c.create(rdr);
        }
        XMLStreamReader rdr1 = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(str));
        StreamReaderBufferProcessor xsbrdr = xsb.readAsXMLStreamReader();
        this.compareReaders(rdr1, (XMLStreamReader)((Object)xsbrdr), "S", "ns4");
    }

    public void testWSDLNamespaces() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getClassLoader().getResource("data/header.wsdl");
        System.out.println("WSDL=" + wsdl);
        XMLStreamBufferResult xsbr = new XMLStreamBufferResult();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        XMLReader xmlReader = spf.newSAXParser().getXMLReader();
        TransformerHandler transformerHandler = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
        transformerHandler.setResult(xsbr);
        xmlReader.setContentHandler(transformerHandler);
        xmlReader.parse(wsdl.toExternalForm());
        MutableXMLStreamBuffer xsb = xsbr.getXMLStreamBuffer();
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(wsdl.openStream());
        StreamReaderBufferProcessor xsbrdr = xsb.readAsXMLStreamReader();
        this.compareReaderQNames(rdr, (XMLStreamReader)((Object)xsbrdr), "wsdl", "soap", "xsd");
    }

    public void testWSDLNamespaces2() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getClassLoader().getResource("data/header.wsdl");
        System.out.println("WSDL=" + wsdl);
        StreamSource source = new StreamSource(wsdl.openStream());
        XMLStreamBufferResult xsbr = new XMLStreamBufferResult();
        TransformerFactory.newInstance().newTransformer().transform(source, xsbr);
        MutableXMLStreamBuffer xsb = xsbr.getXMLStreamBuffer();
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(wsdl.openStream());
        StreamReaderBufferProcessor xsbrdr = xsb.readAsXMLStreamReader();
        this.compareReaderQNames(rdr, (XMLStreamReader)((Object)xsbrdr), "a", "wsdl", "soap", "xsd");
    }

    private void useReaderForTesting(String str, String ... prefixes) throws Exception {
        XMLStreamReader rdr = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(str));
        XMLStreamBuffer xsb = XMLStreamBuffer.createNewBufferFromXMLStreamReader(rdr);
        StreamReaderBufferProcessor xsbrdr = xsb.readAsXMLStreamReader();
        rdr = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(str));
        this.compareReaders(rdr, (XMLStreamReader)((Object)xsbrdr), prefixes);
    }

    /*
     * Unable to fully structure code
     */
    private void compareReaderQNames(XMLStreamReader rdr, XMLStreamReader xsbrdr, String ... prefixes) throws XMLStreamException {
        while (true) {
            if (rdr.hasNext() && (event = rdr.next()) != 1 && event != 2) continue;
            while (xsbrdr.hasNext() && (event = xsbrdr.next()) != 1 && event != 2) {
            }
            if (!rdr.hasNext()) break;
            OverrideNamespaceTest.assertEquals((Object)rdr.getName(), (Object)xsbrdr.getName());
            arr$ = prefixes;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (i$ >= len$) ** break;
                prefix = arr$[i$];
                OverrideNamespaceTest.assertEquals((String)OverrideNamespaceTest.fixNull(rdr.getNamespaceURI(prefix)), (String)OverrideNamespaceTest.fixNull(xsbrdr.getNamespaceURI(prefix)));
                ++i$;
            }
            break;
        }
        OverrideNamespaceTest.assertTrue((boolean)(xsbrdr.hasNext() == false));
    }

    private void compareReaders(XMLStreamReader rdr, XMLStreamReader xsbrdr, String ... prefixes) throws XMLStreamException {
        while (rdr.hasNext()) {
            OverrideNamespaceTest.assertTrue((boolean)xsbrdr.hasNext());
            int expected = rdr.next();
            int actual = xsbrdr.next();
            OverrideNamespaceTest.assertEquals((int)expected, (int)actual);
            if (expected != 1 && expected != 2) continue;
            OverrideNamespaceTest.assertEquals((Object)rdr.getName(), (Object)xsbrdr.getName());
            for (String prefix : prefixes) {
                OverrideNamespaceTest.assertEquals((String)OverrideNamespaceTest.fixNull(rdr.getNamespaceURI(prefix)), (String)OverrideNamespaceTest.fixNull(xsbrdr.getNamespaceURI(prefix)));
            }
        }
    }

    private static String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

