/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.analysis.types;

import com.sun.xml.fastinfoset.types.XSDataType;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaProcessor {
    private List<URL> _schema;
    private Set<XSDataType> _filter;
    private Map<String, Set<XSDataType>> _elementMap = new HashMap<String, Set<XSDataType>>();
    private Map<String, Set<XSDataType>> _attributeMap = new HashMap<String, Set<XSDataType>>();
    private QName _element;
    private QName _attribute;
    private boolean _isListSimpleType;

    public SchemaProcessor(URL schema) {
        this._schema = new ArrayList<URL>();
        this._schema.add(schema);
    }

    public SchemaProcessor(List<URL> schema) {
        this._schema = schema;
    }

    public Map<String, Set<XSDataType>> getElementToXSDataTypeMap() {
        return new HashMap<String, Set<XSDataType>>(this._elementMap);
    }

    public Map<String, Set<XSDataType>> getAttributeToXSDataTypeMap() {
        return new HashMap<String, Set<XSDataType>>(this._attributeMap);
    }

    public void process() throws Exception {
        this.process(null);
    }

    public void process(Set<XSDataType> filter) throws Exception {
        InputSource s;
        this._filter = filter;
        XSOMParser parser = new XSOMParser();
        parser.setErrorHandler((ErrorHandler)new ErrorHandlerImpl());
        for (URL u : this._schema) {
            s = new InputSource(u.openStream());
            s.setSystemId(u.toString());
            parser.parse(s);
        }
        XSSchemaSet sset = parser.getResult();
        Iterator is = sset.iterateSchema();
        while (is.hasNext()) {
            s = (XSSchema)is.next();
            s.visit(new InternalSchemaProcessor());
        }
    }

    private void addToMap(Map<String, Set<XSDataType>> map, String localName, String typeName) {
        XSDataType type = XSDataType.create(typeName);
        if (this._filter != null && !this._filter.contains((Object)type)) {
            return;
        }
        Set<XSDataType> types = map.get(localName);
        if (types == null) {
            map.put(localName, Collections.singleton(type));
        } else if (!types.contains((Object)type)) {
            if (types.size() == 1) {
                types = new HashSet<XSDataType>(types);
                map.put(localName, types);
            }
            types.add(type);
        }
    }

    private void reset() {
        this._attribute = null;
        this._element = null;
        this._isListSimpleType = false;
    }

    private QName qname(XSDeclaration d) {
        return new QName(d.getTargetNamespace(), d.getName());
    }

    private void print() {
        System.out.println("ELEMENTS");
        for (Map.Entry<String, Set<XSDataType>> e : this._elementMap.entrySet()) {
            System.out.println("  " + e.getKey() + ": " + e.getValue());
        }
        System.out.println("ATTRIBUTES");
        for (Map.Entry<String, Set<XSDataType>> e : this._attributeMap.entrySet()) {
            System.out.println("  " + e.getKey() + ": " + e.getValue());
        }
    }

    public static void main(String[] args) throws Exception {
        SchemaProcessor v = new SchemaProcessor(new File(args[0]).toURI().toURL());
        v.process();
        v.print();
    }

    private static class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.out.println("WARNING");
            e.printStackTrace();
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            System.out.println("ERROR");
            e.printStackTrace();
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            System.out.println("FATAL ERROR");
            e.printStackTrace();
        }
    }

    private class InternalSchemaProcessor
    implements XSVisitor,
    XSSimpleTypeVisitor {
        private Set<XSElementDecl> seen = new HashSet<XSElementDecl>();

        private InternalSchemaProcessor() {
        }

        public void annotation(XSAnnotation xSAnnotation) {
        }

        public void attGroupDecl(XSAttGroupDecl decl) {
            for (XSAttGroupDecl groupDecl : decl.getAttGroups()) {
                groupDecl.visit((XSVisitor)this);
            }
            for (XSAttributeUse use : decl.getAttributeUses()) {
                use.visit((XSVisitor)this);
            }
        }

        public void attributeDecl(XSAttributeDecl xSAttributeDecl) {
            SchemaProcessor.this._attribute = SchemaProcessor.this.qname((XSDeclaration)xSAttributeDecl);
            SchemaProcessor.this._element = null;
            XSSimpleType s = xSAttributeDecl.getType();
            s.visit((XSSimpleTypeVisitor)this);
        }

        public void attributeUse(XSAttributeUse use) {
            XSAttributeDecl decl = use.getDecl();
            decl.visit((XSVisitor)this);
        }

        public void complexType(XSComplexType type) {
            XSType baseType;
            if (type.getContentType().asSimpleType() != null) {
                baseType = type.getBaseType();
                if (type.getDerivationMethod() != 2 && type.getName() != null && type.getTargetNamespace().compareTo(baseType.getTargetNamespace()) == 0 && type.getName().compareTo(baseType.getName()) == 0) {
                    baseType.visit((XSVisitor)this);
                }
                XSSimpleType s = type.getContentType().asSimpleType();
                s.visit((XSSimpleTypeVisitor)this);
            } else {
                baseType = type.getBaseType().asComplexType();
                if (type.getDerivationMethod() != 2) {
                    if (type.getName() != null && type.getTargetNamespace().compareTo(baseType.getTargetNamespace()) == 0 && type.getName().compareTo(baseType.getName()) == 0) {
                        baseType.visit((XSVisitor)this);
                    }
                    type.getExplicitContent().visit((XSVisitor)this);
                }
                type.getContentType().visit((XSVisitor)this);
            }
            for (XSAttGroupDecl a : type.getAttGroups()) {
                a.visit((XSVisitor)this);
            }
            for (XSAttGroupDecl a : type.getDeclaredAttributeUses()) {
                a.visit((XSVisitor)this);
            }
        }

        public void schema(XSSchema s) {
            for (XSAttGroupDecl groupDecl : s.getAttGroupDecls().values()) {
                this.attGroupDecl(groupDecl);
            }
            for (XSAttributeDecl attrDecl : s.getAttributeDecls().values()) {
                this.attributeDecl(attrDecl);
            }
            for (XSComplexType complexType : s.getComplexTypes().values()) {
                this.complexType(complexType);
            }
            for (XSElementDecl elementDecl : s.getElementDecls().values()) {
                this.elementDecl(elementDecl);
            }
            for (XSModelGroupDecl modelGroupDecl : s.getModelGroupDecls().values()) {
                this.modelGroupDecl(modelGroupDecl);
            }
        }

        public void facet(XSFacet facet) {
        }

        public void notation(XSNotation xSNotation) {
        }

        public void identityConstraint(XSIdentityConstraint xSIdentityConstraint) {
        }

        public void xpath(XSXPath xSXPath) {
        }

        public void wildcard(XSWildcard xSWildcard) {
        }

        public void modelGroupDecl(XSModelGroupDecl decl) {
            this.modelGroup(decl.getModelGroup());
        }

        public void modelGroup(XSModelGroup group) {
            int len = group.getSize();
            for (int i = 0; i < len; ++i) {
                this.particle(group.getChild(i));
            }
        }

        public void elementDecl(XSElementDecl type) {
            if (this.seen.contains(type)) {
                return;
            }
            this.seen.add(type);
            SchemaProcessor.this._element = SchemaProcessor.this.qname((XSDeclaration)type);
            type.getType().visit((XSVisitor)this);
        }

        public void particle(XSParticle part) {
            part.getTerm().visit((XSVisitor)this);
        }

        public void empty(XSContentType xSContentType) {
        }

        public void simpleType(XSSimpleType type) {
            type.visit((XSSimpleTypeVisitor)this);
        }

        public void listSimpleType(XSListSimpleType xSListSimpleType) {
            if (SchemaProcessor.this._isListSimpleType) {
                return;
            }
            SchemaProcessor.this._isListSimpleType = true;
            this.simpleType(xSListSimpleType.getItemType());
        }

        public void unionSimpleType(XSUnionSimpleType type) {
        }

        public void restrictionSimpleType(XSRestrictionSimpleType type) {
            if (type.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
                if (SchemaProcessor.this._element != null) {
                    SchemaProcessor.this.addToMap(SchemaProcessor.this._elementMap, SchemaProcessor.this._element.getLocalPart(), type.getName());
                } else if (SchemaProcessor.this._attribute != null) {
                    SchemaProcessor.this.addToMap(SchemaProcessor.this._attributeMap, SchemaProcessor.this._attribute.getLocalPart(), type.getName());
                }
            } else {
                XSSimpleType baseType = type.getSimpleBaseType();
                if (baseType == null) {
                    return;
                }
                if (baseType.isLocal()) {
                    this.simpleType(baseType);
                }
            }
            SchemaProcessor.this.reset();
        }
    }
}

