/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.analysis.frequency;

import com.sun.xml.analysis.frequency.FrequencyBasedLists;
import com.sun.xml.analysis.frequency.FrequencySet;
import com.sun.xml.analysis.frequency.SchemaProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.fastinfoset.Vocabulary;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FrequencyHandler
extends DefaultHandler {
    private Map<String, Set<QName>> namespacesToElements = new HashMap<String, Set<QName>>();
    private Map<String, Set<QName>> namespacesToAttributes = new HashMap<String, Set<QName>>();
    private Map<String, String> namespaceURIToPrefix = new HashMap<String, String>();
    private FrequencySet<String> prefixes = new FrequencySet();
    private FrequencySet<String> namespaces = new FrequencySet();
    private FrequencySet<String> localNames = new FrequencySet();
    private FrequencySet<QName> elements = new FrequencySet();
    private FrequencySet<QName> attributes = new FrequencySet();
    private FrequencySet<String> attributeValues = new FrequencySet();
    private FrequencySet<String> textContentValues = new FrequencySet();
    private StringBuilder prefixBuilder;
    private char prefixCharacter = (char)97;

    public FrequencyHandler() {
    }

    public FrequencyHandler(SchemaProcessor sp) {
        for (String s : sp.localNames) {
            this.localNames.add0(s);
        }
        for (String s : sp.namespaces) {
            this.namespaces.add0(s);
        }
        this.bucketQNamesToNamespace(sp.elements, this.namespacesToElements);
        this.bucketQNamesToNamespace(sp.attributes, this.namespacesToAttributes);
        for (String s : sp.textContentValues) {
            this.textContentValues.add0(s);
        }
        for (String s : sp.attributeValues) {
            this.attributeValues.add0(s);
        }
    }

    public void addXsiAttributes() {
        QName q = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
        this.addQNameToAttributes(q);
        q = new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        this.addQNameToAttributes(q);
    }

    public void addQNameToElements(QName q) {
        this.namespaces.add0(q.getNamespaceURI());
        this.localNames.add0(q.getLocalPart());
    }

    public void addQNameToAttributes(QName q) {
        this.namespaces.add0(q.getNamespaceURI());
        this.localNames.add0(q.getLocalPart());
    }

    @Deprecated
    public FrequencyBasedLists getLists() {
        return new FrequencyBasedLists(this.prefixes.createFrequencyBasedList(), this.namespaces.createFrequencyBasedList(), this.localNames.createFrequencyBasedList(), this.elements.createFrequencyBasedList(), this.attributes.createFrequencyBasedList(), this.textContentValues.createFrequencyBasedList(), this.attributeValues.createFrequencyBasedList());
    }

    public Vocabulary getVocabulary() {
        Vocabulary v = new Vocabulary();
        this.addAll(v.prefixes, this.prefixes.createFrequencyBasedSet());
        this.addAll(v.namespaceNames, this.namespaces.createFrequencyBasedSet());
        this.addAll(v.localNames, this.localNames.createFrequencyBasedSet());
        this.addAll(v.elements, this.elements.createFrequencyBasedSet());
        this.addAll(v.attributes, this.attributes.createFrequencyBasedSet());
        this.addAll(v.characterContentChunks, this.textContentValues.createFrequencyBasedSet());
        this.addAll(v.attributeValues, this.attributeValues.createFrequencyBasedSet());
        return v;
    }

    public void generateQNamesWithPrefix() {
        HashSet<String> namespaceURIs = new HashSet<String>();
        namespaceURIs.addAll(this.namespacesToElements.keySet());
        namespaceURIs.addAll(this.namespacesToAttributes.keySet());
        for (String namespaceURI : namespaceURIs) {
            if (namespaceURI.length() == 0) {
                this.namespaceURIToPrefix.put(namespaceURI, "");
                continue;
            }
            String prefix = this.getNewPrefix();
            this.namespaceURIToPrefix.put(namespaceURI, prefix);
            this.prefixes.add0(prefix);
        }
        this.generateQNamesWithPrefix(this.namespacesToElements, this.elements, this.namespaceURIToPrefix);
        this.generateQNamesWithPrefix(this.namespacesToAttributes, this.attributes, this.namespaceURIToPrefix);
    }

    public Map<String, String> getNamespaceURIToPrefixMap() {
        return this.namespaceURIToPrefix;
    }

    private void addAll(Set to, Set<?> from) {
        for (Object o : from) {
            to.add(o);
        }
    }

    private void bucketQNamesToNamespace(Set<QName> s, Map<String, Set<QName>> m) {
        for (QName q : s) {
            Set<QName> subs = m.get(q.getNamespaceURI());
            if (subs == null) {
                subs = new HashSet<QName>();
                m.put(q.getNamespaceURI(), subs);
            }
            subs.add(q);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixes.add(prefix);
        this.namespaces.add(uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        QName q = this.createQName(uri, localName, qName);
        this.addQName(q, this.namespacesToElements, this.elements);
        for (int i = 0; i < atts.getLength(); ++i) {
            q = this.createQName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i));
            this.addQName(q, this.namespacesToAttributes, this.attributes);
        }
    }

    private void addQName(QName q, Map<String, Set<QName>> m, FrequencySet<QName> fhm) {
        Set<QName> s = m.get(q.getNamespaceURI());
        if (s == null) {
            fhm.add(q);
        } else {
            m.put(q.getNamespaceURI(), null);
            String prefix = q.getPrefix();
            if (prefix.length() == 0) {
                if (s.contains(q)) {
                    s.remove(q);
                }
                fhm.add(q);
                for (QName qInSet : s) {
                    fhm.add0(qInSet);
                }
            } else {
                QName qWithoutPrefix = new QName(q.getNamespaceURI(), q.getLocalPart());
                if (s.contains(qWithoutPrefix)) {
                    s.remove(qWithoutPrefix);
                }
                fhm.add(q);
                for (QName qInSet : s) {
                    fhm.add0(new QName(qInSet.getNamespaceURI(), qInSet.getLocalPart(), prefix));
                }
            }
        }
    }

    private QName createQName(String uri, String localName, String qName) {
        if (uri != "") {
            int i = qName.indexOf(58);
            String prefix = i != -1 ? qName.substring(0, i) : "";
            return new QName(uri, localName, prefix);
        }
        return new QName(localName);
    }

    private void generateQNamesWithPrefix(Map<String, Set<QName>> m, FrequencySet<QName> fhm, Map<String, String> namespaceURIToPrefix) {
        for (Map.Entry<String, Set<QName>> entry : m.entrySet()) {
            String namespaceURI = entry.getKey();
            String prefix = namespaceURIToPrefix.get(namespaceURI);
            for (QName qInSet : entry.getValue()) {
                fhm.add0(new QName(namespaceURI, qInSet.getLocalPart(), prefix));
            }
        }
    }

    private String getNewPrefix() {
        if (this.prefixBuilder == null) {
            this.prefixBuilder = new StringBuilder();
            this.prefixBuilder.append(this.prefixCharacter);
            return this.prefixBuilder.toString();
        }
        this.prefixCharacter = (char)(this.prefixCharacter + '\u0001');
        if (this.prefixCharacter > 'z') {
            this.prefixCharacter = (char)97;
            this.prefixBuilder.append(this.prefixCharacter);
        } else {
            this.prefixBuilder.setCharAt(this.prefixBuilder.length() - 1, this.prefixCharacter);
        }
        return this.prefixBuilder.toString();
    }
}

