/*
 * Decompiled with CFR 0.152.
 */
package samples.stax;

import com.sun.xml.fastinfoset.stax.StAXDocumentParser;
import com.sun.xml.fastinfoset.stax.events.StAXEventReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import samples.common.Util;

public class StAXEventReadingSample {
    private File input;
    InputStream document = null;
    XMLStreamReader streamReader = null;

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            StAXEventReadingSample.displayUsageAndExit();
        }
        StAXEventReadingSample eventReader = new StAXEventReadingSample();
        try {
            eventReader.readFIDoc(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readFIDoc(String filename) throws Exception {
        this.input = new File(filename);
        this.document = new BufferedInputStream(new FileInputStream(this.input));
        StAXDocumentParser streamReader = new StAXDocumentParser(this.document);
        StAXEventReader r = new StAXEventReader((XMLStreamReader)streamReader);
        int count = 0;
        System.out.println("Reading " + this.input.getName() + ": \n");
        while (r.hasNext()) {
            XMLEvent e = r.nextEvent();
            System.out.println(++count + ": " + Util.getEventTypeString(e.getEventType()) + " " + e.toString());
        }
    }

    private static void displayUsageAndExit() {
        System.err.println("Usage: ant EventReader or samples.stax.EventReader FI_file");
        System.exit(1);
    }
}

