/*
 * Decompiled with CFR 0.152.
 */
package samples.transform;

import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import com.sun.xml.fastinfoset.tools.SAX2StAXWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public class XMLToFastInfosetStAXSerializer {
    String _xmlFile;
    Transformer _transformer;
    DocumentBuilder _docBuilder;
    DOMSource _source = null;
    SAXResult _result = null;
    ByteArrayOutputStream _baos;

    public XMLToFastInfosetStAXSerializer() {
        try {
            this._transformer = TransformerFactory.newInstance().newTransformer();
            this._docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void getDOMSource(File input) {
        try {
            FileInputStream fis = new FileInputStream(input);
            Document document = this._docBuilder.parse(fis);
            fis.close();
            this._source = new DOMSource(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void getSAXResult(File output) {
        try {
            this._baos = new ByteArrayOutputStream();
            StAXDocumentSerializer serializer = new StAXDocumentSerializer((OutputStream)this._baos);
            SAX2StAXWriter saxTostax = new SAX2StAXWriter((XMLStreamWriter)serializer);
            this._result = new SAXResult();
            this._result.setHandler((ContentHandler)saxTostax);
            this._result.setLexicalHandler((LexicalHandler)saxTostax);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(File input, File output) {
        this.getDOMSource(input);
        this.getSAXResult(output);
        if (this._source != null && this._result != null) {
            try {
                System.out.println("Transforming " + input.getName() + " into " + output.getName());
                this._transformer.transform(this._source, this._result);
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(output));
                this._baos.writeTo(fos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("\ndone.");
        } else {
            System.out.println("Source or Result could not be null.");
        }
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            XMLToFastInfosetStAXSerializer.displayUsageAndExit();
        }
        File input = new File(args[0]);
        File ouput = new File(args[1]);
        XMLToFastInfosetStAXSerializer docSerializer = new XMLToFastInfosetStAXSerializer();
        docSerializer.write(input, ouput);
    }

    private static void displayUsageAndExit() {
        System.err.println("Usage: ant FIStAXSerializer or samples.stax.FISerializer XML_input_file> FI_output_file");
        System.exit(1);
    }
}

