/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.roundtriptests;

import com.sun.xml.fastinfoset.roundtriptests.FileUtils;
import com.sun.xml.fastinfoset.roundtriptests.RoundTripReport;
import com.sun.xml.fastinfoset.roundtriptests.SingleRountTripTest;
import com.sun.xml.fastinfoset.roundtriptests.rtt.DOMRoundTripRtt;
import com.sun.xml.fastinfoset.roundtriptests.rtt.DOMSAXRoundTripRtt;
import com.sun.xml.fastinfoset.roundtriptests.rtt.RoundTripRtt;
import com.sun.xml.fastinfoset.roundtriptests.rtt.SAXRoundTripRtt;
import com.sun.xml.fastinfoset.roundtriptests.rtt.SAXStAXDiffRtt;
import com.sun.xml.fastinfoset.roundtriptests.rtt.StAXRoundTripRtt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class AllRoundTripTest {
    private RoundTripRtt[] roundTripTests = new RoundTripRtt[]{new SAXRoundTripRtt(), new StAXRoundTripRtt(), new DOMRoundTripRtt(), new DOMSAXRoundTripRtt(), new SAXStAXDiffRtt()};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllRttTests(String testSrc, String report) {
        File testSrcFile = new File(testSrc);
        RoundTripReport reporter = new RoundTripReport();
        for (int i = 0; i < this.roundTripTests.length; ++i) {
            SingleRountTripTest roundTripTest = new SingleRountTripTest(this.roundTripTests[i], reporter);
            roundTripTest.processFileOrFolder(testSrcFile);
        }
        this.cleanupDiffs(testSrcFile);
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(report)));){
            writer.print(reporter.generateReport());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Error generating report!");
        }
    }

    private void cleanupDiffs(File testSrcFile) {
        if (testSrcFile.isFile()) {
            testSrcFile = testSrcFile.getParentFile();
        }
        FileUtils.removeFileRecursivelly(testSrcFile, file -> {
            if (file.isDirectory()) {
                return !file.getName().equals(".") && !file.getName().equals("..");
            }
            if (file.isFile()) {
                String filename = file.getName();
                return filename.endsWith(".finf") || filename.endsWith(".sax-event") || filename.contains(".diff");
            }
            return false;
        });
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Not enough parameters!!!");
            System.out.println("Use AllRoundTripTest <test_src> <report_filename>");
            System.out.println("Where <test_src> - testing file or folder");
            System.out.println("<report_filename> - file for generating report");
            System.exit(0);
        }
        new AllRoundTripTest().processAllRttTests(args[0], args[1]);
    }
}

