/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

public abstract class WhiteSpaceProcessor {
    public static String replace(String text) {
        int i;
        for (i = text.length() - 1; i >= 0 && !WhiteSpaceProcessor.isWhiteSpaceExceptSpace(text.charAt(i)); --i) {
        }
        if (i < 0) {
            return text;
        }
        char[] buf = text.toCharArray();
        buf[i--] = 32;
        while (i >= 0) {
            if (WhiteSpaceProcessor.isWhiteSpaceExceptSpace(buf[i])) {
                buf[i] = 32;
            }
            --i;
        }
        return new String(buf);
    }

    public static String collapse(String text) {
        int s;
        int len = text.length();
        for (s = 0; s < len && !WhiteSpaceProcessor.isWhiteSpace(text.charAt(s)); ++s) {
        }
        if (s == len) {
            return text;
        }
        StringBuffer result = new StringBuffer(len);
        if (s != 0) {
            for (int i = 0; i < s; ++i) {
                result.append(text.charAt(i));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s + 1; i < len; ++i) {
            char ch = text.charAt(i);
            boolean b = WhiteSpaceProcessor.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    protected static final boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    protected static final boolean isWhiteSpaceExceptSpace(char ch) {
        if (ch >= ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r';
    }
}

