/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jms.MessageFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage,
Traceable {
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private byte[] messageBody = null;

    protected ObjectMessageImpl() throws JMSException {
        this.setPacketType(5);
    }

    public void clearBody() throws JMSException {
        this.messageBody = null;
        this.setMessageReadMode(false);
    }

    protected void setMessageBodyToPacket() throws JMSException {
        if (this.messageBody == null) {
            return;
        }
        try {
            this.setMessageBody(this.messageBody);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4014");
        }
    }

    protected void getMessageBodyFromPacket() throws JMSException {
        try {
            this.messageBody = this.getMessageBody();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4015");
        }
    }

    public void setObject(Serializable serializable) throws JMSException {
        this.checkMessageAccess();
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
            this.objectOutputStream.writeObject(serializable);
            this.objectOutputStream.flush();
            this.messageBody = this.byteArrayOutputStream.toByteArray();
            this.objectOutputStream.close();
            this.byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            if (exception instanceof NotSerializableException) {
                String string = ExceptionHandler.getExceptionMessage(exception, "C4014");
                MessageFormatException messageFormatException = new MessageFormatException(string, "C4014");
                ExceptionHandler.handleException(exception, (JMSException)((Object)messageFormatException));
            }
            ExceptionHandler.handleException(exception, "C4038");
        }
    }

    public Serializable getObject() throws JMSException {
        Serializable serializable = null;
        if (this.messageBody == null) {
            return null;
        }
        try {
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
            this.objectInputStream = new ObjectInputStreamWithContextLoader(this.byteArrayInputStream);
            serializable = (Serializable)this.objectInputStream.readObject();
        }
        catch (Exception exception) {
            if (exception instanceof InvalidClassException || exception instanceof OptionalDataException || exception instanceof ClassNotFoundException) {
                String string = ExceptionHandler.getExceptionMessage(exception, "C4015");
                MessageFormatException messageFormatException = new MessageFormatException(string, "C4015");
                messageFormatException.setLinkedException(exception);
                ExceptionHandler.throwJMSException((JMSException)((Object)messageFormatException));
            }
            ExceptionHandler.handleException(exception, "C4038");
        }
        return serializable;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ ObjectMessageImpl dump ------");
        super.dump(printStream);
    }

    public String toString() {
        return super.toString();
    }

    static class ObjectInputStreamWithContextLoader
    extends ObjectInputStream {
        public ObjectInputStreamWithContextLoader(InputStream inputStream) throws IOException, StreamCorruptedException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(objectStreamClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    throw new ClassNotFoundException(classNotFoundException.getMessage() + "; " + securityException.getMessage());
                }
                if (classLoader == null) {
                    throw classNotFoundException;
                }
                return Class.forName(objectStreamClass.getName(), false, classLoader);
            }
        }
    }
}

