/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.gimap;

import com.sun.mail.gimap.protocol.GmailProtocol;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.protocol.IMAPProtocol;
import javax.mail.FolderClosedException;
import javax.mail.MessagingException;
import javax.mail.Session;

public class GmailMessage
extends IMAPMessage {
    protected GmailMessage(IMAPFolder folder, int msgnum) {
        super(folder, msgnum);
    }

    protected GmailMessage(Session session) {
        super(session);
    }

    public long getMsgId() throws MessagingException {
        Long msgid = (Long)this.getItem(GmailProtocol.MSGID_ITEM);
        if (msgid != null) {
            return msgid;
        }
        return -1L;
    }

    public long getThrId() throws MessagingException {
        Long thrid = (Long)this.getItem(GmailProtocol.THRID_ITEM);
        if (thrid != null) {
            return thrid;
        }
        return -1L;
    }

    public String[] getLabels() throws MessagingException {
        String[] labels = (String[])this.getItem(GmailProtocol.LABELS_ITEM);
        if (labels != null) {
            return (String[])labels.clone();
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLabels(String[] labels, boolean set) throws MessagingException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol ip = this.getProtocol();
                assert (ip instanceof GmailProtocol);
                GmailProtocol p = (GmailProtocol)ip;
                this.checkExpunged();
                p.storeLabels(this.getSequenceNumber(), labels, set);
            }
            catch (ConnectionException cex) {
                throw new FolderClosedException(this.folder, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
        }
    }
}

