/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.storageservice;

import com.sun.jersey.samples.storageservice.Item;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Container {
    private String name;
    private String uri;
    private List<Item> item;

    public Container() {
    }

    public Container(String name, String uri) {
        this.setName(name);
        this.setUri(uri);
        this.setItem(new ArrayList<Item>());
    }

    public Container(String name, String uri, List<Item> items) {
        this.setName(name);
        this.setUri(uri);
        this.setItem(items);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public List<Item> getItem() {
        return this.item;
    }

    public void setItem(List<Item> items) {
        this.item = items;
    }

    public Item getItem(String name) {
        for (Item i : this.item) {
            if (!i.getName().equals(name)) continue;
            return i;
        }
        return null;
    }

    public void putItem(Item item) {
        ListIterator<Item> i = this.getItem().listIterator();
        while (i.hasNext()) {
            if (!i.next().getName().equals(item.getName())) continue;
            i.set(item);
            return;
        }
        this.getItem().add(item);
    }

    public Item removeItem(String name) {
        ListIterator<Item> i = this.getItem().listIterator();
        while (i.hasNext()) {
            Item item = i.next();
            if (!item.getName().equals(name)) continue;
            i.remove();
            return item;
        }
        return null;
    }

    public Container clone() {
        Container that = new Container(this.name, this.uri);
        that.setItem(new ArrayList<Item>(this.item));
        return that;
    }
}

