/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.storageservice.resources;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.samples.storageservice.Container;
import com.sun.jersey.samples.storageservice.Item;
import com.sun.jersey.samples.storageservice.MemoryStore;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class ItemResource {
    UriInfo uriInfo;
    Request request;
    String container;
    String item;

    public ItemResource(UriInfo uriInfo, Request request, String container, String item) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.container = container;
        this.item = item;
    }

    @GET
    public Response getItem() {
        EntityTag et;
        System.out.println("GET ITEM " + this.container + " " + this.item);
        Item i = MemoryStore.MS.getItem(this.container, this.item);
        if (i == null) {
            throw new NotFoundException("Item not found");
        }
        Date lastModified = i.getLastModified().getTime();
        Response.ResponseBuilder rb = this.request.evaluatePreconditions(lastModified, et = new EntityTag(i.getDigest()));
        if (rb != null) {
            return rb.build();
        }
        byte[] b = MemoryStore.MS.getItemData(this.container, this.item);
        return Response.ok((Object)b, (String)i.getMimeType()).lastModified(lastModified).tag(et).build();
    }

    @PUT
    public Response putItem(@Context HttpHeaders headers, byte[] data) {
        System.out.println("PUT ITEM " + this.container + " " + this.item);
        URI uri = this.uriInfo.getAbsolutePath();
        MediaType mimeType = headers.getMediaType();
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(14, 0);
        Item i = new Item(this.item, uri.toString(), mimeType.toString(), gc);
        String digest = this.computeDigest(data);
        i.setDigest(digest);
        Response r = !MemoryStore.MS.hasItem(this.container, this.item) ? Response.created((URI)uri).build() : Response.noContent().build();
        Item ii = MemoryStore.MS.createOrUpdateItem(this.container, i, data);
        if (ii == null) {
            URI containerUri = this.uriInfo.getAbsolutePathBuilder().path("..").build(new Object[0]).normalize();
            Container c = new Container(this.container, containerUri.toString());
            MemoryStore.MS.createContainer(c);
            i = MemoryStore.MS.createOrUpdateItem(this.container, i, data);
            if (i == null) {
                throw new NotFoundException("Container not found");
            }
        }
        return r;
    }

    @DELETE
    public void deleteItem() {
        System.out.println("DELETE ITEM " + this.container + " " + this.item);
        Item i = MemoryStore.MS.deleteItem(this.container, this.item);
        if (i == null) {
            throw new NotFoundException("Item not found");
        }
    }

    private String computeDigest(byte[] content) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] digest = md.digest(content);
            BigInteger bi = new BigInteger(digest);
            return bi.toString(16);
        }
        catch (Exception e) {
            return "";
        }
    }
}

