/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.console.resources;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.jettison.json.JSONArray;

public class Colours {
    private static String[] colours = new String[]{"red", "orange", "yellow", "green", "blue", "indigo", "violet"};

    @GET
    @Produces(value={"text/plain"})
    public String getColourListAsText(@QueryParam(value="match") String filter) {
        StringBuffer buf = new StringBuffer();
        for (String colour : Colours.getMatchingColours(filter)) {
            buf.append(colour);
            buf.append('\n');
        }
        return buf.toString();
    }

    @GET
    @Produces(value={"application/json"})
    public JSONArray getColourListAsJSON(@QueryParam(value="match") String filter) {
        return new JSONArray(Colours.getMatchingColours(filter));
    }

    public static List<String> getMatchingColours(String filter) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String colour : colours) {
            if (filter != null && filter.length() != 0 && !colour.contains(filter)) continue;
            matches.add(colour);
        }
        return matches;
    }
}

