/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.oauth.twitterclient;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.oauth.client.OAuthClientFilter;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.samples.oauth.twitterclient.Status;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import java.util.Properties;

public class App {
    private static final BufferedReader IN = new BufferedReader(new InputStreamReader(System.in));
    private static final String FRIENDS_TIMELINE_URI = "http://api.twitter.com/1.1/statuses/home_timeline.json";
    private static final Properties PROPERTIES = new Properties();
    private static final String PROPERTIES_FILE_NAME = "twitterclient.properties";
    private static final String PROPERTY_CONSUMER_KEY = "consumerKey";
    private static final String PROPERTY_CONSUMER_SECRET = "consumerSecret";
    private static final String PROPERTY_TOKEN = "token";
    private static final String PROPERTY_TOKEN_SECRET = "tokenSecret";

    public static void main(String[] args) throws Exception {
        App.loadSettings();
        DefaultClientConfig config = new DefaultClientConfig();
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", true);
        Client client = Client.create((ClientConfig)config);
        OAuthClientFilter.AuthHandler authHandler = new OAuthClientFilter.AuthHandler(){

            public void authorized(String token, String tokenSecret) {
                PROPERTIES.setProperty(App.PROPERTY_TOKEN, token);
                PROPERTIES.setProperty(App.PROPERTY_TOKEN_SECRET, tokenSecret);
            }

            public String authorize(URI authorizationUri) {
                try {
                    System.out.println("Enter the following URI into a web browser and authorize me:");
                    System.out.println(authorizationUri);
                    System.out.print("Enter the authorization code: ");
                    return IN.readLine();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        OAuthClientFilter filter = new OAuthClientFilter(client.getProviders(), new OAuthParameters().consumerKey(PROPERTIES.getProperty(PROPERTY_CONSUMER_KEY)).token(PROPERTIES.getProperty(PROPERTY_TOKEN)), new OAuthSecrets().consumerSecret(PROPERTIES.getProperty(PROPERTY_CONSUMER_SECRET)).tokenSecret(PROPERTIES.getProperty(PROPERTY_TOKEN_SECRET)), "https://api.twitter.com/oauth/request_token", "https://api.twitter.com/oauth/access_token", "https://api.twitter.com/oauth/authorize", authHandler);
        client.addFilter((ClientFilter)filter);
        do {
            List statuses = (List)client.resource(FRIENDS_TIMELINE_URI).get((GenericType)new GenericType<List<Status>>(){});
            for (Status s : statuses) {
                System.out.println(s.getText());
                System.out.println("[posted by " + s.getUser().getName() + " at " + s.getCreatedAt() + "]");
            }
            System.out.println();
            System.out.println("Please hit Enter to refresh, or enter a non-empty line to quit.");
        } while (IN.readLine().equals(""));
        App.storeSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSettings() {
        FileInputStream st = null;
        try {
            st = new FileInputStream(PROPERTIES_FILE_NAME);
            PROPERTIES.load(st);
        }
        catch (IOException e) {
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (IOException ex) {}
            }
        }
        for (String name : new String[]{PROPERTY_CONSUMER_KEY, PROPERTY_CONSUMER_SECRET, PROPERTY_TOKEN, PROPERTY_TOKEN_SECRET}) {
            String value = System.getProperty(name);
            if (value == null) continue;
            PROPERTIES.setProperty(name, value);
        }
        if (PROPERTIES.getProperty(PROPERTY_CONSUMER_KEY) == null || PROPERTIES.getProperty(PROPERTY_CONSUMER_SECRET) == null) {
            System.out.println("No consumerKey and/or consumerSecret found in twitterclient.properties file. You have to provide these as system properties.");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeSettings() {
        FileOutputStream st = null;
        try {
            st = new FileOutputStream(PROPERTIES_FILE_NAME);
            PROPERTIES.store(st, null);
        }
        catch (IOException e) {
        }
        finally {
            try {
                st.close();
            }
            catch (IOException ex) {}
        }
    }
}

