/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.application;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.container.filter.UriConnegFilter;
import com.sun.jersey.api.core.ExtendedUriInfo;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.core.ResourceConfigurator;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.ResourceModelIssue;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentInjector;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ProviderFactory;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessor;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactory;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactoryInitializer;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCProviderFactory;
import com.sun.jersey.core.spi.factory.ContextResolverFactory;
import com.sun.jersey.core.spi.factory.MessageBodyFactory;
import com.sun.jersey.core.util.FeaturesAndProperties;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.impl.BuildId;
import com.sun.jersey.server.impl.ThreadLocalHttpContext;
import com.sun.jersey.server.impl.application.CloseableServiceFactory;
import com.sun.jersey.server.impl.application.DeferredResourceConfig;
import com.sun.jersey.server.impl.application.ExceptionMapperFactory;
import com.sun.jersey.server.impl.application.ResourceMethodDispatcherFactory;
import com.sun.jersey.server.impl.application.WebApplicationContext;
import com.sun.jersey.server.impl.component.IoCResourceFactory;
import com.sun.jersey.server.impl.component.ResourceFactory;
import com.sun.jersey.server.impl.container.filter.FilterFactory;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderFactory;
import com.sun.jersey.server.impl.model.ResourceClass;
import com.sun.jersey.server.impl.model.RulesMap;
import com.sun.jersey.server.impl.model.parameter.CookieParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.FormParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.HeaderParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.HttpContextInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.MatrixParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.PathParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.QueryParamInjectableProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorFactory;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.StringReaderFactory;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.jersey.server.impl.modelapi.validation.BasicValidator;
import com.sun.jersey.server.impl.resource.PerRequestFactory;
import com.sun.jersey.server.impl.template.TemplateFactory;
import com.sun.jersey.server.impl.uri.PathPattern;
import com.sun.jersey.server.impl.uri.PathTemplate;
import com.sun.jersey.server.impl.uri.rules.ResourceClassRule;
import com.sun.jersey.server.impl.uri.rules.ResourceObjectRule;
import com.sun.jersey.server.impl.uri.rules.RightHandPathRule;
import com.sun.jersey.server.impl.uri.rules.RootResourceClassesRule;
import com.sun.jersey.server.impl.wadl.WadlFactory;
import com.sun.jersey.server.impl.wadl.WadlResource;
import com.sun.jersey.server.spi.component.ResourceComponentInjector;
import com.sun.jersey.server.spi.component.ResourceComponentProvider;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.StringReaderWorkers;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ExceptionMapperContext;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.inject.Inject;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import com.sun.jersey.spi.service.ServiceFinder;
import com.sun.jersey.spi.template.TemplateContext;
import com.sun.jersey.spi.uri.rules.UriRule;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebApplicationImpl
implements WebApplication {
    private static final Logger LOGGER = Logger.getLogger(WebApplicationImpl.class.getName());
    private final Map<Class, AbstractResource> abstractResourceMap = new HashMap<Class, AbstractResource>();
    private final ConcurrentMap<Class, ResourceClass> metaClassMap = new ConcurrentHashMap<Class, ResourceClass>();
    private final ConcurrentMap<ClassAnnotationKey, ResourceClass> metaClassAnnotationKeyMap = new ConcurrentHashMap<ClassAnnotationKey, ResourceClass>();
    private final ThreadLocalHttpContext context = new ThreadLocalHttpContext();
    private final CloseableServiceFactory closeableFactory;
    private boolean initiated;
    private ResourceConfig resourceConfig;
    private RootResourceClassesRule rootsRule;
    private ServerInjectableProviderFactory injectableFactory;
    private ProviderFactory cpFactory;
    private ResourceFactory rcpFactory;
    private IoCComponentProviderFactory provider;
    private List<IoCComponentProviderFactory> providerFactories;
    private MessageBodyFactory bodyFactory;
    private StringReaderFactory stringReaderFactory;
    private TemplateContext templateContext;
    private ExceptionMapperFactory exceptionFactory;
    private ResourceMethodDispatcherFactory dispatcherFactory;
    private ResourceContext resourceContext;
    private FilterFactory filterFactory;
    private WadlFactory wadlFactory;
    private boolean isTraceEnabled;
    private static final IoCComponentProcessor NULL_COMPONENT_PROCESSOR = new IoCComponentProcessor(){

        public void preConstruct() {
        }

        public void postConstruct(Object o) {
        }
    };

    public WebApplicationImpl() {
        InvocationHandler requestHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke((Object)WebApplicationImpl.this.context.getRequest(), args);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
        };
        InvocationHandler uriInfoHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke((Object)WebApplicationImpl.this.context.getUriInfo(), args);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
        };
        this.injectableFactory = new ServerInjectableProviderFactory();
        this.injectableFactory.add(new ContextInjectableProvider<ServerInjectableProviderFactory>((Type)((Object)InjectableProviderContext.class), this.injectableFactory));
        this.injectableFactory.add(new ContextInjectableProvider<ServerInjectableProviderFactory>((Type)((Object)ServerInjectableProviderContext.class), this.injectableFactory));
        final HashMap<Class, Object> m = new HashMap<Class, Object>();
        m.put(HttpContext.class, this.context);
        m.put(HttpHeaders.class, this.createProxy(HttpHeaders.class, requestHandler));
        m.put(UriInfo.class, this.createProxy(UriInfo.class, uriInfoHandler));
        m.put(ExtendedUriInfo.class, this.createProxy(ExtendedUriInfo.class, uriInfoHandler));
        m.put(Request.class, this.createProxy(Request.class, requestHandler));
        m.put(SecurityContext.class, this.createProxy(SecurityContext.class, requestHandler));
        this.injectableFactory.add(new InjectableProvider<Context, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            @Override
            public Injectable getInjectable(ComponentContext ic, Context a, Type c) {
                final Object o = m.get(c);
                if (o != null) {
                    return new Injectable(){

                        public Object getValue() {
                            return o;
                        }
                    };
                }
                return null;
            }
        });
        this.injectableFactory.add(new InjectableProvider<Context, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            @Override
            public Injectable<Injectable> getInjectable(ComponentContext ic, Context a, Type c) {
                ParameterizedType pt;
                if (c instanceof ParameterizedType && (pt = (ParameterizedType)c).getRawType() == Injectable.class && pt.getActualTypeArguments().length == 1) {
                    final Injectable i = WebApplicationImpl.this.injectableFactory.getInjectable((Class<? extends Annotation>)a.annotationType(), ic, a, pt.getActualTypeArguments()[0], ComponentScope.PERREQUEST_UNDEFINED_SINGLETON);
                    return new Injectable<Injectable>(){

                        @Override
                        public Injectable getValue() {
                            return i;
                        }
                    };
                }
                return null;
            }
        });
        this.injectableFactory.add(new InjectableProvider<Inject, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            @Override
            public Injectable<Injectable> getInjectable(ComponentContext ic, Inject a, Type c) {
                ParameterizedType pt;
                if (c instanceof ParameterizedType && (pt = (ParameterizedType)c).getRawType() == Injectable.class && pt.getActualTypeArguments().length == 1) {
                    final Injectable i = WebApplicationImpl.this.injectableFactory.getInjectable(a.annotationType(), ic, a, pt.getActualTypeArguments()[0], ComponentScope.PERREQUEST_UNDEFINED_SINGLETON);
                    return new Injectable<Injectable>(){

                        @Override
                        public Injectable getValue() {
                            return i;
                        }
                    };
                }
                return null;
            }
        });
        this.closeableFactory = new CloseableServiceFactory(this.context);
        this.injectableFactory.add(this.closeableFactory);
    }

    @Override
    public FeaturesAndProperties getFeaturesAndProperties() {
        return this.resourceConfig;
    }

    @Override
    public WebApplication clone() {
        WebApplicationImpl wa = new WebApplicationImpl();
        wa.initiate(this.resourceConfig, this.provider);
        return wa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceClass getResourceClass(Class c) {
        assert (c != null);
        ResourceClass rc = (ResourceClass)this.metaClassMap.get(c);
        if (rc != null) {
            return rc;
        }
        ConcurrentMap<Class, ResourceClass> concurrentMap = this.metaClassMap;
        synchronized (concurrentMap) {
            rc = (ResourceClass)this.metaClassMap.get(c);
            if (rc != null) {
                return rc;
            }
            rc = this.newResourceClass(this.getAbstractResource(c));
            rc.init(this.rcpFactory);
            this.metaClassMap.put(c, rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceClass getResourceClass(ComponentContext cc, Class c) {
        ClassAnnotationKey cak;
        ResourceClass rc;
        Annotation a;
        assert (c != null);
        if (cc == null || cc.getAnnotations().length == 0) {
            return this.getResourceClass(c);
        }
        if (cc.getAnnotations().length == 1 && (a = cc.getAnnotations()[0]).annotationType() == Inject.class) {
            String value;
            Inject i = (Inject)Inject.class.cast(a);
            String string = value = i.value() != null ? i.value().trim() : "";
            if (value.length() == 0) {
                return this.getResourceClass(c);
            }
        }
        if ((rc = (ResourceClass)this.metaClassAnnotationKeyMap.get(cak = new ClassAnnotationKey(c, cc.getAnnotations()))) != null) {
            return rc;
        }
        ConcurrentMap<Class, ResourceClass> concurrentMap = this.metaClassMap;
        synchronized (concurrentMap) {
            rc = (ResourceClass)this.metaClassAnnotationKeyMap.get(cak);
            if (rc != null) {
                return rc;
            }
            rc = this.newResourceClass(this.getAbstractResource(c));
            rc.init(this.rcpFactory, cc);
            this.metaClassAnnotationKeyMap.put(cak, rc);
        }
        return rc;
    }

    private ResourceClass getResourceClass(AbstractResource ar) {
        if (this.metaClassMap.containsKey(ar.getResourceClass())) {
            return (ResourceClass)this.metaClassMap.get(ar.getResourceClass());
        }
        ResourceClass rc = this.newResourceClass(ar);
        this.metaClassMap.put(ar.getResourceClass(), rc);
        rc.init(this.rcpFactory);
        return rc;
    }

    private ResourceClass getResourceClass(AbstractResource ar, Object resource) {
        if (this.metaClassMap.containsKey(ar.getResourceClass())) {
            return (ResourceClass)this.metaClassMap.get(ar.getResourceClass());
        }
        ResourceClass rc = this.newResourceClass(ar);
        this.metaClassMap.put(ar.getResourceClass(), rc);
        rc.initSingleton(resource);
        return rc;
    }

    private ResourceClass newResourceClass(AbstractResource ar) {
        assert (null != ar);
        BasicValidator validator = new BasicValidator();
        validator.validate(ar);
        boolean fatalIssueFound = false;
        for (ResourceModelIssue issue : validator.getIssueList()) {
            if (issue.isFatal()) {
                fatalIssueFound = true;
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.severe(issue.getMessage());
                continue;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning(issue.getMessage());
        }
        if (fatalIssueFound) {
            LOGGER.severe(ImplMessages.FATAL_ISSUES_FOUND_AT_RES_CLASS(ar.getResourceClass().getName()));
            throw new ContainerException(ImplMessages.FATAL_ISSUES_FOUND_AT_RES_CLASS(ar.getResourceClass().getName()));
        }
        return new ResourceClass(this.resourceConfig, this.dispatcherFactory, this.injectableFactory, this.filterFactory, this.wadlFactory, ar);
    }

    private AbstractResource getAbstractResource(Object o) {
        return this.getAbstractResource(o.getClass());
    }

    private AbstractResource getAbstractResource(Class c) {
        AbstractResource ar = this.abstractResourceMap.get(c);
        if (ar == null) {
            ar = IntrospectionModeller.createResource(c);
            this.abstractResourceMap.put(c, ar);
        }
        return ar;
    }

    @Override
    public boolean isInitiated() {
        return this.initiated;
    }

    @Override
    public void initiate(ResourceConfig resourceConfig) {
        this.initiate(resourceConfig, null);
    }

    @Override
    public void initiate(ResourceConfig rc, IoCComponentProviderFactory _provider) {
        if (rc == null) {
            throw new IllegalArgumentException("ResourceConfig instance MUST NOT be null");
        }
        if (this.initiated) {
            throw new ContainerException(ImplMessages.WEB_APP_ALREADY_INITIATED());
        }
        this.initiated = true;
        LOGGER.info("Initiating Jersey application, version '" + BuildId.getBuildId() + "'");
        Class<?>[] components = ServiceFinder.find("jersey-server-components").toClassArray();
        if (components.length > 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                StringBuilder b = new StringBuilder();
                b.append("Adding the following classes declared in META-INF/services/jersey-server-components to the resource configuration:");
                for (Class<?> c : components) {
                    b.append('\n').append("  ").append(c);
                }
                LOGGER.log(Level.INFO, b.toString());
            }
            this.resourceConfig = rc.clone();
            this.resourceConfig.getClasses().addAll(Arrays.asList(components));
        } else {
            this.resourceConfig = rc;
        }
        this.provider = _provider;
        this.providerFactories = new ArrayList<IoCComponentProviderFactory>(2);
        for (Object o : this.resourceConfig.getProviderSingletons()) {
            if (!(o instanceof IoCComponentProviderFactory)) continue;
            this.providerFactories.add((IoCComponentProviderFactory)o);
        }
        if (_provider != null) {
            this.providerFactories.add(_provider);
        }
        this.cpFactory = this.providerFactories.isEmpty() ? new ProviderFactory(this.injectableFactory) : new IoCProviderFactory((InjectableProviderContext)this.injectableFactory, this.providerFactories);
        this.rcpFactory = this.providerFactories.isEmpty() ? new ResourceFactory(this.resourceConfig, this.injectableFactory) : new IoCResourceFactory(this.resourceConfig, this.injectableFactory, this.providerFactories);
        for (IoCComponentProviderFactory f : this.providerFactories) {
            ComponentProcessorFactoryImpl cpf = null;
            if (!(f instanceof IoCComponentProcessorFactoryInitializer)) continue;
            if (cpf == null) {
                cpf = new ComponentProcessorFactoryImpl();
            }
            IoCComponentProcessorFactoryInitializer i = (IoCComponentProcessorFactoryInitializer)((Object)f);
            i.init(cpf);
        }
        this.resourceContext = new ResourceContext(){

            @Override
            public <T> T getResource(Class<T> c) {
                ResourceClass rc = WebApplicationImpl.this.getResourceClass(c);
                if (rc == null) {
                    LOGGER.severe("No resource class found for class " + c.getName());
                    throw new ContainerException("No resource class found for class " + c.getName());
                }
                Object instance = rc.rcProvider.getInstance(WebApplicationImpl.this.context);
                return instance != null ? (T)c.cast(instance) : null;
            }
        };
        ProviderServices providerServices = new ProviderServices(this.cpFactory, this.resourceConfig.getProviderClasses(), this.resourceConfig.getProviderSingletons());
        this.injectableFactory.add(new InjectableProvider<Inject, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.PerRequest;
            }

            @Override
            public Injectable<Object> getInjectable(ComponentContext cc, Inject a, Type t) {
                if (!(t instanceof Class)) {
                    return null;
                }
                final ResourceComponentProvider rcp = WebApplicationImpl.this.getResourceClass((ComponentContext)cc, (Class)((Class)t)).rcProvider;
                return new Injectable<Object>(){

                    @Override
                    public Object getValue() {
                        return rcp.getInstance(WebApplicationImpl.this.context);
                    }
                };
            }
        });
        this.injectableFactory.add(new InjectableProvider<Inject, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Undefined;
            }

            @Override
            public Injectable<Object> getInjectable(ComponentContext cc, Inject a, Type t) {
                if (!(t instanceof Class)) {
                    return null;
                }
                final ResourceComponentProvider rcp = WebApplicationImpl.this.getResourceClass((ComponentContext)cc, (Class)((Class)t)).rcProvider;
                if (rcp.getScope() == ComponentScope.PerRequest) {
                    return null;
                }
                return new Injectable<Object>(){

                    @Override
                    public Object getValue() {
                        return rcp.getInstance(WebApplicationImpl.this.context);
                    }
                };
            }
        });
        this.injectableFactory.add(new InjectableProvider<Inject, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            @Override
            public Injectable<Object> getInjectable(ComponentContext cc, Inject a, Type t) {
                if (!(t instanceof Class)) {
                    return null;
                }
                final ResourceComponentProvider rcp = WebApplicationImpl.this.getResourceClass((ComponentContext)cc, (Class)((Class)t)).rcProvider;
                if (rcp.getScope() != ComponentScope.Singleton) {
                    return null;
                }
                return new Injectable<Object>(){

                    @Override
                    public Object getValue() {
                        return rcp.getInstance(WebApplicationImpl.this.context);
                    }
                };
            }
        });
        this.injectableFactory.add(new ContextInjectableProvider<ResourceConfig>((Type)((Object)FeaturesAndProperties.class), this.resourceConfig));
        this.injectableFactory.add(new InjectableProvider<Context, Type>(){

            @Override
            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            @Override
            public Injectable<ResourceConfig> getInjectable(ComponentContext cc, Context a, Type t) {
                if (t != ResourceConfig.class) {
                    return null;
                }
                return new Injectable<ResourceConfig>(){

                    @Override
                    public ResourceConfig getValue() {
                        return WebApplicationImpl.this.resourceConfig;
                    }
                };
            }
        });
        this.injectableFactory.add(new ContextInjectableProvider<ResourceContext>((Type)((Object)ResourceContext.class), this.resourceContext));
        this.injectableFactory.configure(providerServices);
        boolean updateRequired = false;
        if (rc instanceof DeferredResourceConfig) {
            DeferredResourceConfig drc = (DeferredResourceConfig)rc;
            if (this.resourceConfig == drc) {
                this.resourceConfig = drc.clone();
            }
            this.resourceConfig.add(drc.getApplication(this.cpFactory));
            updateRequired = true;
        }
        for (ResourceConfigurator configurator : providerServices.getProviders(ResourceConfigurator.class)) {
            configurator.configure(this.resourceConfig);
            updateRequired = true;
        }
        this.resourceConfig.validate();
        if (updateRequired) {
            providerServices.update(this.resourceConfig.getProviderClasses(), this.resourceConfig.getProviderSingletons(), this.injectableFactory);
        }
        this.templateContext = new TemplateFactory(providerServices);
        this.injectableFactory.add(new ContextInjectableProvider<TemplateContext>((Type)((Object)TemplateContext.class), this.templateContext));
        final ContextResolverFactory crf = new ContextResolverFactory();
        this.exceptionFactory = new ExceptionMapperFactory();
        this.bodyFactory = new MessageBodyFactory(providerServices);
        this.injectableFactory.add(new ContextInjectableProvider<MessageBodyFactory>((Type)((Object)MessageBodyWorkers.class), this.bodyFactory));
        Providers p = new Providers(){

            public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return WebApplicationImpl.this.bodyFactory.getMessageBodyReader(c, t, as, m);
            }

            public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return WebApplicationImpl.this.bodyFactory.getMessageBodyWriter(c, t, as, m);
            }

            public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> c) {
                if (Throwable.class.isAssignableFrom(c)) {
                    return WebApplicationImpl.this.exceptionFactory.find(c);
                }
                return null;
            }

            public <T> ContextResolver<T> getContextResolver(Class<T> ct, MediaType m) {
                return crf.resolve(ct, m);
            }
        };
        this.injectableFactory.add(new ContextInjectableProvider<12>((Type)((Object)Providers.class), p));
        this.stringReaderFactory = new StringReaderFactory();
        this.injectableFactory.add(new ContextInjectableProvider<StringReaderFactory>((Type)((Object)StringReaderWorkers.class), this.stringReaderFactory));
        MultivaluedParameterExtractorFactory mpep = new MultivaluedParameterExtractorFactory(this.stringReaderFactory);
        this.injectableFactory.add(new ContextInjectableProvider<MultivaluedParameterExtractorFactory>((Type)((Object)MultivaluedParameterExtractorProvider.class), mpep));
        this.injectableFactory.add(new CookieParamInjectableProvider(mpep));
        this.injectableFactory.add(new HeaderParamInjectableProvider(mpep));
        this.injectableFactory.add(new HttpContextInjectableProvider());
        this.injectableFactory.add(new MatrixParamInjectableProvider(mpep));
        this.injectableFactory.add(new PathParamInjectableProvider(mpep));
        this.injectableFactory.add(new QueryParamInjectableProvider(mpep));
        this.injectableFactory.add(new FormParamInjectableProvider(mpep));
        this.filterFactory = new FilterFactory(providerServices);
        this.dispatcherFactory = new ResourceMethodDispatcherFactory(providerServices);
        this.wadlFactory = new WadlFactory(this.resourceConfig);
        this.filterFactory.init(this.resourceConfig);
        if (!this.resourceConfig.getMediaTypeMappings().isEmpty() || !this.resourceConfig.getLanguageMappings().isEmpty()) {
            boolean present = false;
            for (ContainerRequestFilter f : this.filterFactory.getRequestFilters()) {
                present |= f instanceof UriConnegFilter;
            }
            if (!present) {
                this.filterFactory.getRequestFilters().add(new UriConnegFilter(this.resourceConfig.getMediaTypeMappings(), this.resourceConfig.getLanguageMappings()));
            } else {
                LOGGER.warning("The media type and language mappings declared in the ResourceConfig are ignored because there is an instance of " + UriConnegFilter.class.getName() + "present in the list of request filters.");
            }
        }
        crf.init(providerServices, this.injectableFactory);
        this.exceptionFactory.init(providerServices);
        this.bodyFactory.init();
        this.stringReaderFactory.init(providerServices);
        this.cpFactory.injectOnAllComponents();
        this.cpFactory.injectOnProviderInstances(this.resourceConfig.getProviderSingletons());
        this.rootsRule = new RootResourceClassesRule(this.processRootResources());
        this.isTraceEnabled = this.resourceConfig.getFeature("com.sun.jersey.config.feature.Trace") | this.resourceConfig.getFeature("com.sun.jersey.config.feature.TracePerRequest");
    }

    @Override
    public MessageBodyWorkers getMessageBodyWorkers() {
        return this.bodyFactory;
    }

    @Override
    public ExceptionMapperContext getExceptionMapperContext() {
        return this.exceptionFactory;
    }

    @Override
    public void handleRequest(ContainerRequest request, ContainerResponseWriter responseWriter) throws IOException {
        ContainerResponse response = new ContainerResponse(this, request, responseWriter);
        this.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(ContainerRequest request, ContainerResponse response) throws IOException {
        WebApplicationContext localContext = new WebApplicationContext(this, request, response);
        this.context.set(localContext);
        try {
            this._handleRequest(localContext, request, response);
        }
        finally {
            PerRequestFactory.destroy(localContext);
            this.closeableFactory.close(localContext);
            this.context.set(null);
        }
    }

    @Override
    public void destroy() {
        for (ResourceClass rc : this.metaClassMap.values()) {
            rc.destroy();
        }
        for (ResourceClass rc : this.metaClassAnnotationKeyMap.values()) {
            rc.destroy();
        }
        this.cpFactory.destroy();
    }

    @Override
    public boolean isTracingEnabled() {
        return this.isTraceEnabled;
    }

    @Override
    public void trace(String message) {
        this.context.get().trace(message);
    }

    private void _handleRequest(WebApplicationContext localContext, ContainerRequest request, ContainerResponse response) throws IOException {
        block17: {
            block16: {
                try {
                    for (ContainerRequestFilter containerRequestFilter : this.filterFactory.getRequestFilters()) {
                        request = containerRequestFilter.filter(request);
                        localContext.setContainerRequest(request);
                    }
                    StringBuilder path = new StringBuilder();
                    path.append("/").append(request.getPath(false));
                    if (!this.resourceConfig.getFeature("com.sun.jersey.config.feature.IgnoreMatrixParams")) {
                        path = this.stripMatrixParams(path);
                    }
                    if (!this.rootsRule.accept(path, null, localContext)) {
                        throw new NotFoundException(request.getRequestUri());
                    }
                }
                catch (WebApplicationException e) {
                    response.mapWebApplicationException(e);
                }
                catch (MappableContainerException e) {
                    response.mapMappableContainerException(e);
                }
                catch (RuntimeException e) {
                    if (response.mapException(e)) break block16;
                    LOGGER.log(Level.SEVERE, "The RuntimeException could not be mapped to a response, re-throwing to the HTTP container", e);
                    throw e;
                }
            }
            try {
                for (ContainerResponseFilter containerResponseFilter : localContext.getResponseFilters()) {
                    response = containerResponseFilter.filter(request, response);
                    localContext.setContainerResponse(response);
                }
                for (ContainerResponseFilter containerResponseFilter : this.filterFactory.getResponseFilters()) {
                    response = containerResponseFilter.filter(request, response);
                    localContext.setContainerResponse(response);
                }
            }
            catch (WebApplicationException e) {
                response.mapWebApplicationException(e);
            }
            catch (MappableContainerException e) {
                response.mapMappableContainerException(e);
            }
            catch (RuntimeException e) {
                if (response.mapException(e)) break block17;
                LOGGER.log(Level.SEVERE, "The RuntimeException could not be mapped to a response, re-throwing to the HTTP container", e);
                throw e;
            }
        }
        try {
            response.write();
        }
        catch (WebApplicationException e) {
            if (response.isCommitted()) {
                LOGGER.log(Level.SEVERE, "The response of the WebApplicationException cannot be utilized as the response is already committed. Re-throwing to the HTTP container", e);
                throw e;
            }
            response.mapWebApplicationException(e);
            response.write();
        }
    }

    @Override
    public HttpContext getThreadLocalHttpContext() {
        return this.context;
    }

    private void ensureTemplateUnused(UriTemplate t, Class<?> c, Set<UriTemplate> templates) {
        if (templates.contains(t)) {
            LOGGER.severe(ImplMessages.AMBIGUOUS_RR_PATH(c, t));
            throw new ContainerException(ImplMessages.AMBIGUOUS_RR_PATH(c, t));
        }
        templates.add(t);
    }

    private RulesMap<UriRule> processRootResources() {
        AbstractResource ar;
        Set<Class<?>> classes = this.resourceConfig.getRootResourceClasses();
        Set<Object> singletons = this.resourceConfig.getRootResourceSingletons();
        if (classes.isEmpty() && singletons.isEmpty() && this.resourceConfig.getExplicitRootResources().isEmpty()) {
            LOGGER.severe(ImplMessages.NO_ROOT_RES_IN_RES_CFG());
            throw new ContainerException(ImplMessages.NO_ROOT_RES_IN_RES_CFG());
        }
        HashMap rootResourcesMap = new HashMap();
        HashSet<AbstractResource> rootResourcesSet = new HashSet<AbstractResource>();
        for (Object object : singletons) {
            AbstractResource ar2 = this.getAbstractResource(object);
            rootResourcesMap.put(object.getClass(), ar2);
            rootResourcesSet.add(ar2);
        }
        for (Class clazz : classes) {
            AbstractResource ar2 = this.getAbstractResource(clazz);
            rootResourcesMap.put(clazz, ar2);
            rootResourcesSet.add(ar2);
        }
        HashMap<String, AbstractResource> explicitRootResources = new HashMap<String, AbstractResource>();
        for (Map.Entry<String, Object> e : this.resourceConfig.getExplicitRootResources().entrySet()) {
            Object o = e.getValue();
            Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
            ar = (AbstractResource)rootResourcesMap.get(clazz);
            if (ar == null) {
                ar = this.getAbstractResource(clazz);
                rootResourcesMap.put(clazz, ar);
            }
            ar = new AbstractResource(e.getKey(), ar);
            rootResourcesSet.add(ar);
            explicitRootResources.put(e.getKey(), ar);
        }
        this.initWadl(rootResourcesSet, this.wadlFactory);
        RulesMap<UriRule> rulesMap = new RulesMap<UriRule>();
        HashSet<UriTemplate> uriTemplatesUsed = new HashSet<UriTemplate>();
        for (Object object : singletons) {
            ComponentInjector ci = new ComponentInjector(this.injectableFactory, object.getClass());
            ci.inject(object);
            AbstractResource ar3 = (AbstractResource)rootResourcesMap.get(object.getClass());
            PathTemplate t = new PathTemplate(ar3.getPath().getValue());
            this.ensureTemplateUnused(t, object.getClass(), uriTemplatesUsed);
            PathPattern p = new PathPattern(t);
            this.getResourceClass(ar3, object);
            rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceObjectRule(t, object)));
        }
        for (Class clazz : classes) {
            ar = (AbstractResource)rootResourcesMap.get(clazz);
            PathTemplate t = new PathTemplate(ar.getPath().getValue());
            this.ensureTemplateUnused(t, clazz, uriTemplatesUsed);
            PathPattern p = new PathPattern(t);
            this.getResourceClass(ar);
            rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceClassRule(t, clazz)));
        }
        for (Map.Entry entry : this.resourceConfig.getExplicitRootResources().entrySet()) {
            PathPattern p;
            PathTemplate t;
            String path = (String)entry.getKey();
            Object o = entry.getValue();
            if (o instanceof Class) {
                Class c = (Class)o;
                t = new PathTemplate(path);
                this.ensureTemplateUnused(t, c, uriTemplatesUsed);
                p = new PathPattern(t);
                this.getResourceClass((AbstractResource)explicitRootResources.get(path));
                rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceClassRule(t, c)));
                continue;
            }
            ComponentInjector ci = new ComponentInjector(this.injectableFactory, o.getClass());
            ci.inject(o);
            t = new PathTemplate(path);
            this.ensureTemplateUnused(t, o.getClass(), uriTemplatesUsed);
            p = new PathPattern(t);
            this.getResourceClass((AbstractResource)explicitRootResources.get(path));
            rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceObjectRule(t, o)));
        }
        this.initWadlResource(rulesMap);
        return rulesMap;
    }

    private void initWadl(Set<AbstractResource> rootResources, WadlFactory wadlFactory) {
        if (!wadlFactory.isSupported()) {
            return;
        }
        wadlFactory.init(this.injectableFactory, rootResources);
    }

    private void initWadlResource(RulesMap<UriRule> rulesMap) {
        if (!this.wadlFactory.isSupported()) {
            return;
        }
        PathTemplate t = new PathTemplate("application.wadl");
        PathPattern p = new PathPattern(t);
        if (rulesMap.containsKey(p)) {
            return;
        }
        this.getResourceClass(WadlResource.class);
        rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceClassRule(t, WadlResource.class)));
    }

    private StringBuilder stripMatrixParams(StringBuilder path) {
        int e = path.indexOf(";");
        if (e == -1) {
            return path;
        }
        int s = 0;
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(path, s, e);
        } while ((s = path.indexOf("/", e + 1)) != -1 && (e = path.indexOf(";", s)) != -1);
        if (s != -1) {
            sb.append(path, s, path.length());
        }
        return sb;
    }

    private <T> T createProxy(Class<T> c, InvocationHandler i) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{c}, i);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }

    private class ComponentProcessorFactoryImpl
    implements IoCComponentProcessorFactory {
        private final ConcurrentMap<Class, IoCComponentProcessor> componentProcessorMap = new ConcurrentHashMap<Class, IoCComponentProcessor>();

        private ComponentProcessorFactoryImpl() {
        }

        public ComponentScope getScope(Class c) {
            return WebApplicationImpl.this.rcpFactory.getScope(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IoCComponentProcessor get(Class c, ComponentScope scope) {
            IoCComponentProcessor cp = (IoCComponentProcessor)this.componentProcessorMap.get(c);
            if (cp != null) {
                return cp == NULL_COMPONENT_PROCESSOR ? null : cp;
            }
            ConcurrentMap concurrentMap = WebApplicationImpl.this.metaClassMap;
            synchronized (concurrentMap) {
                cp = (IoCComponentProcessor)this.componentProcessorMap.get(c);
                if (cp != null) {
                    return cp == NULL_COMPONENT_PROCESSOR ? null : cp;
                }
                ResourceComponentInjector rci = new ResourceComponentInjector(WebApplicationImpl.this.injectableFactory, scope, WebApplicationImpl.this.getAbstractResource(c));
                if (rci.hasInjectableArtifacts()) {
                    cp = new ComponentProcessorImpl(rci);
                    this.componentProcessorMap.put(c, cp);
                } else {
                    cp = null;
                    this.componentProcessorMap.put(c, NULL_COMPONENT_PROCESSOR);
                }
            }
            return cp;
        }
    }

    private class ComponentProcessorImpl
    implements IoCComponentProcessor {
        private final ResourceComponentInjector rci;

        ComponentProcessorImpl(ResourceComponentInjector rci) {
            this.rci = rci;
        }

        public void preConstruct() {
        }

        public void postConstruct(Object o) {
            this.rci.inject(WebApplicationImpl.this.context.get(), o);
        }
    }

    private static class ClassAnnotationKey {
        private final Class c;
        private final Set<Annotation> as;

        public ClassAnnotationKey(Class c, Annotation[] as) {
            this.c = c;
            this.as = new HashSet<Annotation>(Arrays.asList(as));
        }

        public Class getClassKey() {
            return this.c;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + (this.c != null ? this.c.hashCode() : 0);
            hash = 67 * hash + (this.as != null ? ((Object)this.as).hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassAnnotationKey other = (ClassAnnotationKey)obj;
            if (!(this.c == other.c || this.c != null && this.c.equals(other.c))) {
                return false;
            }
            return this.as == other.as || this.as != null && ((Object)this.as).equals(other.as);
        }
    }
}

