/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.modelapi.validation;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.model.AbstractField;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceConstructor;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSetterMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.api.model.AbstractSubResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.api.model.ResourceModelIssue;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.impl.modelapi.validation.AbstractModelValidator;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicValidator
extends AbstractModelValidator {
    @Override
    public void visitAbstractResource(AbstractResource resource) {
        if (resource.getResourceMethods().size() + resource.getSubResourceMethods().size() + resource.getSubResourceLocators().size() == 0) {
            this.issueList.add(new ResourceModelIssue(resource, ImplMessages.ERROR_NO_SUB_RES_METHOD_LOCATOR_FOUND(resource.getResourceClass()), false));
        }
        if (resource.isRootResource() && (null == resource.getPath() || null == resource.getPath().getValue())) {
            this.issueList.add(new ResourceModelIssue(resource, ImplMessages.ERROR_RES_URI_PATH_INVALID(resource.getResourceClass(), (Object)resource.getPath()), true));
        }
        if (resource.isRootResource() && resource.getConstructors().isEmpty()) {
            this.issueList.add(new ResourceModelIssue(resource, ImplMessages.ROOT_RES_NO_PUBLIC_CTOR(resource.getResourceClass()), true));
        }
        HashMap<UriTemplate, String> srlUriTemplates = new HashMap<UriTemplate, String>();
        HashMap<UriTemplate, String> srlUriTemplatesWithSlash = new HashMap<UriTemplate, String>();
        for (AbstractSubResourceLocator srl : resource.getSubResourceLocators()) {
            UriTemplate srlUriTemplateWithSlash;
            UriTemplate srlUriTemplate = new UriTemplate(srl.getPath().getValue());
            UriTemplate uriTemplate = srlUriTemplateWithSlash = srlUriTemplate.endsWithSlash() ? srlUriTemplate : new UriTemplate(srl.getPath().getValue() + '/');
            if (srlUriTemplates.containsKey(srlUriTemplate)) {
                this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_SRLS(resource.getResourceClass(), (Object)srlUriTemplate.getTemplate(), srlUriTemplates.get(srlUriTemplate)), true));
                continue;
            }
            if (srlUriTemplatesWithSlash.containsKey(srlUriTemplateWithSlash)) {
                this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_SRLS(resource.getResourceClass(), (Object)srlUriTemplate.getTemplate(), srlUriTemplatesWithSlash.get(srlUriTemplate)), true));
            } else {
                srlUriTemplatesWithSlash.put(srlUriTemplateWithSlash, srlUriTemplate.getTemplate());
            }
            srlUriTemplates.put(srlUriTemplate, srlUriTemplate.getTemplate());
        }
        this.findOutMTAmbiguities(resource, resource.getResourceMethods(), new ResourceMethodAmbiguityErrMsgGenerator<AbstractResourceMethod>(){

            @Override
            void generateInErrMsg(AbstractResource resource, AbstractResourceMethod arm1, AbstractResourceMethod arm2, MediaType mt) {
                BasicValidator.this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_RMS_IN(resource.getResourceClass(), (Object)arm1.getHttpMethod(), (Object)mt, (Object)arm1.getMethod().getName(), (Object)arm2.getMethod().getName(), arm1.getSupportedInputTypes(), arm2.getSupportedInputTypes()), true));
            }

            @Override
            void generateOutErrMsg(AbstractResource resource, AbstractResourceMethod arm1, AbstractResourceMethod arm2, MediaType mt) {
                BasicValidator.this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_RMS_OUT(resource.getResourceClass(), (Object)arm1.getHttpMethod(), (Object)mt, (Object)arm1.getMethod().getName(), (Object)arm2.getMethod().getName(), arm1.getSupportedOutputTypes(), arm2.getSupportedOutputTypes()), true));
            }
        });
        this.findOutMTAmbiguities(resource, resource.getSubResourceMethods(), new ResourceMethodAmbiguityErrMsgGenerator<AbstractSubResourceMethod>(){

            boolean isConflictingPaths(String path1, String path2) {
                UriTemplate t1 = new UriTemplate(path1);
                UriTemplate t2 = new UriTemplate(path2);
                if (t1.equals((Object)t2)) {
                    return true;
                }
                if (t1.endsWithSlash()) {
                    return !t2.endsWithSlash() && t1.equals((Object)new UriTemplate(path2 + "/"));
                }
                return t2.endsWithSlash() && t2.equals((Object)new UriTemplate(path1 + "/"));
            }

            @Override
            void generateInErrMsg(AbstractResource resource, AbstractSubResourceMethod arm1, AbstractSubResourceMethod arm2, MediaType mt) {
                if (this.isConflictingPaths(arm1.getPath().getValue(), arm2.getPath().getValue())) {
                    BasicValidator.this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_SRMS_IN(resource.getResourceClass(), (Object)arm1.getHttpMethod(), (Object)arm1.getPath().getValue(), (Object)mt, (Object)arm1.getMethod().getName(), (Object)arm2.getMethod().getName(), arm1.getSupportedInputTypes(), arm2.getSupportedInputTypes()), true));
                }
            }

            @Override
            void generateOutErrMsg(AbstractResource resource, AbstractSubResourceMethod arm1, AbstractSubResourceMethod arm2, MediaType mt) {
                if (this.isConflictingPaths(arm1.getPath().getValue(), arm2.getPath().getValue())) {
                    BasicValidator.this.issueList.add(new ResourceModelIssue(resource, ImplMessages.AMBIGUOUS_SRMS_OUT(resource.getResourceClass(), (Object)arm1.getHttpMethod(), (Object)arm1.getPath().getValue(), (Object)mt, (Object)arm1.getMethod().getName(), (Object)arm2.getMethod().getName(), arm1.getSupportedOutputTypes(), arm2.getSupportedOutputTypes()), true));
                }
            }
        });
    }

    private <T extends AbstractResourceMethod> void findOutMTAmbiguities(AbstractResource resource, List<T> methods, ResourceMethodAmbiguityErrMsgGenerator generator) {
        for (int i = 0; i < methods.size(); ++i) {
            AbstractResourceMethod arm1 = (AbstractResourceMethod)methods.get(i);
            for (int j = i + 1; j < methods.size(); ++j) {
                AbstractResourceMethod arm2 = (AbstractResourceMethod)methods.get(j);
                if (!arm1.getHttpMethod().equalsIgnoreCase(arm2.getHttpMethod())) continue;
                if (!"GET".equalsIgnoreCase(arm1.getHttpMethod())) {
                    for (MediaType mt1 : arm1.getSupportedInputTypes()) {
                        for (MediaType mt2 : arm2.getSupportedInputTypes()) {
                            if (!mt1.isCompatible(mt2) || mt1.isWildcardType() || mt1.isWildcardSubtype() || mt2.isWildcardType() || mt2.isWildcardSubtype()) continue;
                            generator.generateInErrMsg(resource, arm1, arm2, mt1);
                            for (MediaType outmt1 : arm1.getSupportedOutputTypes()) {
                                for (MediaType outmt2 : arm2.getSupportedOutputTypes()) {
                                    if (!outmt1.isCompatible(outmt2) || outmt1.isWildcardType() || outmt1.isWildcardSubtype() || outmt2.isWildcardType() || outmt2.isWildcardSubtype()) continue;
                                    generator.generateOutErrMsg(resource, arm1, arm2, outmt1);
                                }
                            }
                        }
                    }
                    continue;
                }
                for (MediaType outmt1 : arm1.getSupportedOutputTypes()) {
                    for (MediaType outmt2 : arm2.getSupportedOutputTypes()) {
                        if (!outmt1.isCompatible(outmt2) || outmt1.isWildcardType() || outmt1.isWildcardSubtype() || outmt2.isWildcardType() || outmt2.isWildcardSubtype()) continue;
                        generator.generateOutErrMsg(resource, arm1, arm2, outmt1);
                    }
                }
            }
        }
    }

    @Override
    public void visitAbstractResourceConstructor(AbstractResourceConstructor constructor) {
    }

    @Override
    public void visitAbstractField(AbstractField field) {
    }

    @Override
    public void visitAbstractSetterMethod(AbstractSetterMethod setterMethod) {
    }

    @Override
    public void visitAbstractResourceMethod(AbstractResourceMethod method) {
        if (!this.isRequestResponseMethod(method) && "GET".equals(method.getHttpMethod()) && Void.TYPE == method.getMethod().getReturnType()) {
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.ERROR_GET_RETURNS_VOID((Object)method.getMethod()), false));
        }
        if (!this.isRequestResponseMethod(method) && "GET".equals(method.getHttpMethod())) {
            for (Parameter p : method.getParameters()) {
                if (Parameter.Source.ENTITY != p.getSource()) continue;
                this.issueList.add(new ResourceModelIssue(method, ImplMessages.ERROR_GET_CONSUMES_ENTITY((Object)method.getMethod()), true));
            }
        }
        LinkedList<String> httpAnnotList = new LinkedList<String>();
        for (Annotation a : method.getMethod().getDeclaredAnnotations()) {
            if (null == a.annotationType().getAnnotation(HttpMethod.class)) continue;
            httpAnnotList.add(((Object)a).toString());
        }
        if (httpAnnotList.size() > 1) {
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.MULTIPLE_HTTP_METHOD_DESIGNATORS((Object)method.getMethod(), (Object)((Object)httpAnnotList).toString()), true));
        }
    }

    @Override
    public void visitAbstractSubResourceMethod(AbstractSubResourceMethod method) {
        this.visitAbstractResourceMethod(method);
        if (null == method.getPath() || null == method.getPath().getValue() || method.getPath().getValue().length() == 0) {
            this.issueList.add(new ResourceModelIssue(method, ImplMessages.ERROR_SUBRES_METHOD_URI_PATH_INVALID((Object)method.getMethod(), (Object)method.getPath()), true));
        }
    }

    @Override
    public void visitAbstractSubResourceLocator(AbstractSubResourceLocator locator) {
        if (Void.TYPE == locator.getMethod().getReturnType()) {
            this.issueList.add(new ResourceModelIssue(locator, ImplMessages.ERROR_SUBRES_LOC_RETURNS_VOID((Object)locator.getMethod()), true));
        }
        if (null == locator.getPath() || null == locator.getPath().getValue() || locator.getPath().getValue().length() == 0) {
            this.issueList.add(new ResourceModelIssue(locator, ImplMessages.ERROR_SUBRES_LOC_URI_PATH_INVALID((Object)locator.getMethod(), (Object)locator.getPath()), true));
        }
    }

    private boolean isRequestResponseMethod(AbstractResourceMethod method) {
        return method.getMethod().getParameterTypes().length == 2 && HttpRequestContext.class == method.getMethod().getParameterTypes()[0] && HttpResponseContext.class == method.getMethod().getParameterTypes()[1];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ResourceMethodAmbiguityErrMsgGenerator<T extends AbstractResourceMethod> {
        private ResourceMethodAmbiguityErrMsgGenerator() {
        }

        abstract void generateInErrMsg(AbstractResource var1, T var2, T var3, MediaType var4);

        abstract void generateOutErrMsg(AbstractResource var1, T var2, T var3, MediaType var4);
    }
}

