/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.container.servlet;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.impl.container.servlet.RequestDispatcherWrapper;
import com.sun.jersey.spi.template.TemplateProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPTemplateProcessor
implements TemplateProcessor {
    @Context
    ServletContext servletContext;
    @Context
    UriInfo ui;
    private final ThreadLocal<HttpServletRequest> requestInvoker;
    private final ThreadLocal<HttpServletResponse> responseInvoker;

    public JSPTemplateProcessor(ThreadLocal<HttpServletRequest> requestInvoker, ThreadLocal<HttpServletResponse> responseInvoker) {
        this.requestInvoker = requestInvoker;
        this.responseInvoker = responseInvoker;
    }

    @Override
    public String resolve(String path) {
        if (this.servletContext == null) {
            return null;
        }
        try {
            if (this.servletContext.getResource(path) != null) {
                return path;
            }
            if (!path.endsWith(".jsp") && this.servletContext.getResource(path = path + ".jsp") != null) {
                return path;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void writeTo(String resolvedPath, Object model, OutputStream out) throws IOException {
        RequestDispatcher d = this.servletContext.getRequestDispatcher(resolvedPath);
        if (d == null) {
            throw new ContainerException("No request dispatcher for: " + resolvedPath);
        }
        d = new RequestDispatcherWrapper(d, this.ui.getMatchedResources().get(0), model);
        try {
            d.forward((ServletRequest)this.requestInvoker.get(), (ServletResponse)this.responseInvoker.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ContainerException((Throwable)e);
        }
    }
}

