/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.core.header.OutBoundHeaders;
import com.sun.jersey.server.impl.ResponseImpl;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerResponse
implements HttpResponseContext {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final Logger LOGGER = Logger.getLogger(ContainerResponse.class.getName());
    private static final RuntimeDelegate rd = RuntimeDelegate.getInstance();
    private final MessageBodyWorkers bodyContext;
    private ContainerRequest request;
    private ContainerResponseWriter responseWriter;
    private Response response;
    private int status;
    private MultivaluedMap<String, Object> headers;
    private Object entity;
    private Type entityType;
    private boolean isCommitted;
    private CommittingOutputStream out;
    private Annotation[] annotations = EMPTY_ANNOTATIONS;

    public ContainerResponse(WebApplication wa, ContainerRequest request, ContainerResponseWriter responseWriter) {
        this.bodyContext = wa.getMessageBodyWorkers();
        this.request = request;
        this.responseWriter = responseWriter;
        this.status = 204;
    }

    public static String getHeaderValue(Object headerValue) {
        RuntimeDelegate.HeaderDelegate hp = rd.createHeaderDelegate(headerValue.getClass());
        return hp.toString(headerValue);
    }

    public void write() throws IOException {
        MessageBodyWriter p;
        if (this.isCommitted) {
            return;
        }
        if (this.entity == null) {
            this.responseWriter.writeStatusAndHeaders(-1L, this);
            return;
        }
        MediaType contentType = this.getContentType();
        if (contentType == null) {
            contentType = this.bodyContext.getMessageBodyWriterMediaType(this.entity.getClass(), this.entityType, this.annotations, this.request.getAcceptableMediaTypes());
            if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            this.getHttpHeaders().putSingle((Object)"Content-Type", (Object)contentType);
        }
        if ((p = this.bodyContext.getMessageBodyWriter(this.entity.getClass(), this.entityType, this.annotations, contentType)) == null) {
            String message = "A message body writer for Java type, " + this.entity.getClass() + ", and MIME media type, " + contentType + ", was not found";
            LOGGER.severe(message);
            if (this.request.getMethod().equals("HEAD")) {
                this.responseWriter.writeStatusAndHeaders(-1L, this);
                return;
            }
            throw new WebApplicationException(Response.serverError().entity((Object)message).build());
        }
        long size = p.getSize(this.entity, this.entity.getClass(), this.entityType, this.annotations, contentType);
        if (this.request.getMethod().equals("HEAD")) {
            if (size != -1L) {
                this.getHttpHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(size));
            }
            this.isCommitted = true;
            this.responseWriter.writeStatusAndHeaders(0L, this);
        } else {
            CommittingOutputStream o = new CommittingOutputStream(size);
            p.writeTo(this.entity, this.entity.getClass(), this.entityType, this.annotations, contentType, this.getHttpHeaders(), (OutputStream)o);
            if (!this.isCommitted) {
                this.isCommitted = true;
                this.responseWriter.writeStatusAndHeaders(-1L, this);
            }
        }
        this.responseWriter.finish();
    }

    public void reset() {
        this.setResponse(Responses.noContent().build());
    }

    public ContainerRequest getContainerRequest() {
        return this.request;
    }

    public void setContainerRequest(ContainerRequest request) {
        this.request = request;
    }

    public ContainerResponseWriter getContainerResponseWriter() {
        return this.responseWriter;
    }

    public void setContainerResponseWriter(ContainerResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(Response response) {
        this.isCommitted = false;
        this.out = null;
        response = response != null ? response : Responses.noContent().build();
        this.response = response;
        this.status = response.getStatus();
        this.headers = response instanceof ResponseImpl ? this.setResponseOptimal((ResponseImpl)response) : this.setResponseNonOptimal(response);
    }

    @Override
    public boolean isResponseSet() {
        return this.response != null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public Type getEntityType() {
        return this.entityType;
    }

    @Override
    public void setEntity(Object entity) {
        this.entity = entity;
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            this.entityType = ge.getType();
            this.entity = ge.getEntity();
        } else if (entity != null) {
            this.entityType = this.entity.getClass();
        }
        this.checkStatusAndEntity();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations != null ? annotations : EMPTY_ANNOTATIONS;
    }

    @Override
    public MultivaluedMap<String, Object> getHttpHeaders() {
        if (this.headers == null) {
            this.headers = new OutBoundHeaders();
        }
        return this.headers;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new CommittingOutputStream(-1L);
        }
        return this.out;
    }

    @Override
    public boolean isCommitted() {
        return this.isCommitted;
    }

    private MediaType getContentType() {
        Object mediaTypeHeader = this.getHttpHeaders().getFirst((Object)"Content-Type");
        if (mediaTypeHeader instanceof MediaType) {
            return (MediaType)mediaTypeHeader;
        }
        if (mediaTypeHeader != null) {
            return MediaType.valueOf((String)mediaTypeHeader.toString());
        }
        return null;
    }

    private void checkStatusAndEntity() {
        if (this.status == 204 && this.entity != null) {
            this.status = 200;
        } else if (this.status == 200 && this.entity == null) {
            this.status = 204;
        }
    }

    private MultivaluedMap<String, Object> setResponseOptimal(ResponseImpl r) {
        this.entityType = r.getEntityType();
        this.entity = r.getEntity();
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            this.entityType = ge.getType();
            this.entity = ge.getEntity();
        }
        return r.getMetadataOptimal(this.request);
    }

    private MultivaluedMap<String, Object> setResponseNonOptimal(Response r) {
        this.setEntity(r.getEntity());
        MultivaluedMap _headers = r.getMetadata();
        Object location = _headers.getFirst((Object)"Location");
        if (location != null && location instanceof URI) {
            URI absoluteLocation = this.request.getBaseUri().resolve((URI)location);
            _headers.putSingle((Object)"Location", (Object)absoluteLocation);
        }
        return _headers;
    }

    private final class CommittingOutputStream
    extends OutputStream {
        private final long size;
        private OutputStream o;

        CommittingOutputStream(long size) {
            this.size = size;
        }

        public void write(byte[] b) throws IOException {
            this.commitWrite();
            this.o.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.commitWrite();
            this.o.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.commitWrite();
            this.o.write(b);
        }

        public void flush() throws IOException {
            this.commitWrite();
            this.o.flush();
        }

        public void close() throws IOException {
            this.commitClose();
            this.o.close();
        }

        private void commitWrite() throws IOException {
            if (!ContainerResponse.this.isCommitted) {
                if (ContainerResponse.this.getStatus() == 204) {
                    ContainerResponse.this.setStatus(200);
                }
                ContainerResponse.this.isCommitted = true;
                this.o = ContainerResponse.this.responseWriter.writeStatusAndHeaders(this.size, ContainerResponse.this);
            }
        }

        private void commitClose() throws IOException {
            if (!ContainerResponse.this.isCommitted) {
                ContainerResponse.this.isCommitted = true;
                this.o = ContainerResponse.this.responseWriter.writeStatusAndHeaders(-1L, ContainerResponse.this);
            }
        }
    }
}

