/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.impl.model.parameter.multivalued.CollectionStringConstructorExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.CollectionStringExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.CollectionValueOfExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.PrimitiveMapper;
import com.sun.jersey.server.impl.model.parameter.multivalued.PrimitiveValueOfExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.StringConstructorExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.StringExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.ValueOfExtractor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultivaluedParameterProcessor {
    public static MultivaluedParameterExtractor process(Class<?> parameter, Type parameterType, String parameterName) {
        return MultivaluedParameterProcessor.process(null, parameter, parameterType, parameterName);
    }

    public static MultivaluedParameterExtractor process(String defaultValue, Class<?> parameter, Type parameterType, String parameterName) {
        if (parameter == List.class || parameter == Set.class || parameter == SortedSet.class) {
            Class c = ReflectionHelper.getGenericClass((Type)parameterType);
            if (c == null || c == String.class) {
                return CollectionStringExtractor.getInstance(parameter, parameterName, defaultValue);
            }
            Method valueOf = ReflectionHelper.getValueOfStringMethod((Class)c);
            if (valueOf != null) {
                try {
                    return CollectionValueOfExtractor.getInstance(parameter, valueOf, parameterName, defaultValue);
                }
                catch (Exception e) {
                    throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_METHOD((Object)defaultValue, (Object)valueOf));
                }
            }
            Constructor constructor = ReflectionHelper.getStringConstructor((Class)c);
            if (constructor != null) {
                try {
                    return CollectionStringConstructorExtractor.getInstance(parameter, constructor, parameterName, defaultValue);
                }
                catch (Exception e) {
                    throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_CONSTRUCTOR((Object)defaultValue, (Object)constructor));
                }
            }
        } else {
            if (parameter == String.class) {
                return new StringExtractor(parameterName, defaultValue);
            }
            if (parameter.isPrimitive()) {
                if ((parameter = PrimitiveMapper.primitiveToClassMap.get(parameter)) == null) {
                    return null;
                }
                Method valueOf = ReflectionHelper.getValueOfStringMethod((Class)parameter);
                if (valueOf != null) {
                    try {
                        Object defaultDefaultValue = PrimitiveMapper.primitiveToDefaultValueMap.get(parameter);
                        return new PrimitiveValueOfExtractor(valueOf, parameterName, defaultValue, defaultDefaultValue);
                    }
                    catch (Exception e) {
                        throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_METHOD((Object)defaultValue, (Object)valueOf));
                    }
                }
            } else {
                Method valueOf = ReflectionHelper.getValueOfStringMethod(parameter);
                if (valueOf != null) {
                    try {
                        return new ValueOfExtractor(valueOf, parameterName, defaultValue);
                    }
                    catch (Exception e) {
                        throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_METHOD((Object)defaultValue, (Object)valueOf));
                    }
                }
                Constructor constructor = ReflectionHelper.getStringConstructor((Class)parameter);
                if (constructor != null) {
                    try {
                        return new StringConstructorExtractor(constructor, parameterName, defaultValue);
                    }
                    catch (Exception e) {
                        throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_CONSTRUCTOR((Object)defaultValue, (Object)constructor));
                    }
                }
            }
        }
        return null;
    }
}

