/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.method.dispatch;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.ResponseBuilderImpl;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import com.sun.jersey.server.impl.model.method.dispatch.ResourceJavaMethodDispatcher;
import com.sun.jersey.server.impl.model.method.dispatch.ResourceMethodDispatchProvider;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterProcessor;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import com.sun.jersey.spi.inject.Injectable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDispatchProvider
implements ResourceMethodDispatchProvider {
    @Context
    ServerInjectableProviderContext sipc;
    @Context
    MessageBodyWorkers mbw;

    protected void processForm(HttpContext context) {
        Form form = context.getRequest().getEntity(Form.class);
        context.getProperties().put("com.sun.jersey.api.representation.form", form);
    }

    @Override
    public RequestDispatcher create(AbstractResourceMethod abstractResourceMethod) {
        if ("GET".equals(abstractResourceMethod.getHttpMethod())) {
            return null;
        }
        List<Injectable> is = this.processParameters(abstractResourceMethod);
        if (is == null) {
            return null;
        }
        Class<?> returnType = abstractResourceMethod.getMethod().getReturnType();
        if (Response.class.isAssignableFrom(returnType)) {
            return new ResponseOutInvoker(abstractResourceMethod, is);
        }
        if (returnType != Void.TYPE) {
            if (returnType == Object.class || GenericEntity.class.isAssignableFrom(returnType)) {
                return new ObjectOutInvoker(abstractResourceMethod, is);
            }
            return new TypeOutInvoker(abstractResourceMethod, is);
        }
        return new VoidOutInvoker(abstractResourceMethod, is);
    }

    private List<Injectable> processParameters(AbstractResourceMethod method) {
        if (method.getParameters().isEmpty()) {
            return null;
        }
        boolean hasFormParam = false;
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Parameter parameter = method.getParameters().get(i);
            if (parameter.getAnnotation() == null) continue;
            hasFormParam |= parameter.getAnnotation().annotationType() == FormParam.class;
        }
        if (!hasFormParam) {
            return null;
        }
        return this.getInjectables(method);
    }

    protected List<Injectable> getInjectables(AbstractResourceMethod method) {
        ArrayList<Injectable> is = new ArrayList<Injectable>(method.getParameters().size());
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Parameter p = method.getParameters().get(i);
            if (Parameter.Source.ENTITY == p.getSource()) {
                if (MultivaluedMap.class.isAssignableFrom(p.getParameterClass())) {
                    is.add(new FormEntityInjectable(p.getParameterClass(), p.getParameterType(), p.getAnnotations()));
                    continue;
                }
                return null;
            }
            if (p.getAnnotation().annotationType() == FormParam.class) {
                MultivaluedParameterExtractor e = MultivaluedParameterProcessor.process(p.getDefaultValue(), p.getParameterClass(), p.getParameterType(), p.getSourceName());
                if (e == null) {
                    return null;
                }
                is.add(new FormParamInjectable(e, !p.isEncoded()));
                continue;
            }
            Injectable injectable = this.sipc.getInjectable(p, ComponentScope.PerRequest);
            if (injectable == null) {
                return null;
            }
            is.add(injectable);
        }
        return is;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FormParamInjectable
    extends AbstractHttpContextInjectable<Object> {
        private final MultivaluedParameterExtractor extractor;
        private final boolean decode;

        FormParamInjectable(MultivaluedParameterExtractor extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        public Object getValue(HttpContext context) {
            Form form = (Form)context.getProperties().get("com.sun.jersey.api.representation.form");
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)form);
            }
            catch (ContainerException e) {
                throw new WebApplicationException(e.getCause(), 400);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FormEntityInjectable
    extends AbstractHttpContextInjectable<Object> {
        final Class<?> c;
        final Type t;
        final Annotation[] as;

        FormEntityInjectable(Class c, Type t, Annotation[] as) {
            this.c = c;
            this.t = t;
            this.as = as;
        }

        @Override
        public Object getValue(HttpContext context) {
            return context.getProperties().get("com.sun.jersey.api.representation.form");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ObjectOutInvoker
    extends FormParamInInvoker {
        ObjectOutInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod, is);
        }

        @Override
        public void _dispatch(Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(context);
            Object o = this.method.invoke(resource, params);
            if (o instanceof Response) {
                Response r = (Response)o;
                context.getResponse().setResponse(r);
            } else if (o != null) {
                Response r = new ResponseBuilderImpl().status(200).entity(o).build();
                context.getResponse().setResponse(r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ResponseOutInvoker
    extends FormParamInInvoker {
        ResponseOutInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod, is);
        }

        @Override
        public void _dispatch(Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(context);
            Response r = (Response)this.method.invoke(resource, params);
            if (r != null) {
                context.getResponse().setResponse(r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class TypeOutInvoker
    extends FormParamInInvoker {
        private final Type t;

        TypeOutInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod, is);
            this.t = abstractResourceMethod.getMethod().getGenericReturnType();
        }

        @Override
        public void _dispatch(Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(context);
            Object o = this.method.invoke(resource, params);
            if (o != null) {
                Response r = new ResponseBuilderImpl().entityWithType(o, this.t).status(200).build();
                context.getResponse().setResponse(r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class VoidOutInvoker
    extends FormParamInInvoker {
        VoidOutInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod, is);
        }

        @Override
        public void _dispatch(Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(context);
            this.method.invoke(resource, params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class FormParamInInvoker
    extends ResourceJavaMethodDispatcher {
        private final List<AbstractHttpContextInjectable> is;

        FormParamInInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod);
            this.is = AbstractHttpContextInjectable.transform(is);
        }

        protected final Object[] getParams(HttpContext context) {
            FormDispatchProvider.this.processForm(context);
            Object[] params = new Object[this.is.size()];
            try {
                int index = 0;
                for (AbstractHttpContextInjectable i : this.is) {
                    params[index++] = i.getValue(context);
                }
                return params;
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ContainerException("Exception injecting parameters to Web resource method", e);
            }
        }
    }
}

