/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.uri.rules;

import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightHandPathRule
implements UriRule {
    private final boolean redirect;
    private final boolean patternEndsInSlash;
    private final UriRule rule;

    public RightHandPathRule(boolean redirect, boolean patternEndsInSlash, UriRule rule) {
        assert (rule != null);
        this.redirect = redirect;
        this.patternEndsInSlash = patternEndsInSlash;
        this.rule = rule;
    }

    @Override
    public final boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        String rhpath = this.getRightHandPath(context.getGroupValues());
        if (rhpath.length() == 0) {
            if (this.patternEndsInSlash) {
                return this.redirect ? this.redirect(context) : false;
            }
            context.pushRightHandPathLength(0);
        } else if (rhpath.length() == 1) {
            if (!this.patternEndsInSlash) {
                return false;
            }
            rhpath = "";
            context.pushRightHandPathLength(0);
        } else if (this.patternEndsInSlash) {
            context.pushRightHandPathLength(rhpath.length() - 1);
        } else {
            context.pushRightHandPathLength(rhpath.length());
        }
        return this.rule.accept(rhpath, resource, context);
    }

    private String getRightHandPath(List<String> groupValues) {
        String rhp = !groupValues.isEmpty() ? groupValues.get(groupValues.size() - 1) : "";
        return rhp != null ? rhp : "";
    }

    private boolean redirect(UriRuleContext context) {
        HttpResponseContext response = context.getResponse();
        response.setResponse(Response.temporaryRedirect((URI)UriBuilder.fromUri((URI)context.getUriInfo().getAbsolutePath()).path(new String[]{"/"}).build()).build());
        return true;
    }
}

