/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.application;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.container.ContainerCheckedException;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.ResourceModelIssue;
import com.sun.jersey.api.uri.ExtendedUriInfo;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.impl.ThreadLocalHttpContext;
import com.sun.jersey.impl.application.ComponentProviderCache;
import com.sun.jersey.impl.application.ContextResolverFactory;
import com.sun.jersey.impl.application.ExceptionMapperFactory;
import com.sun.jersey.impl.application.FilterFactory;
import com.sun.jersey.impl.application.InjectableProviderFactory;
import com.sun.jersey.impl.application.MessageBodyFactory;
import com.sun.jersey.impl.application.ResourceMethodDispatcherFactory;
import com.sun.jersey.impl.application.WebApplicationContext;
import com.sun.jersey.impl.model.ResourceClass;
import com.sun.jersey.impl.model.RulesMap;
import com.sun.jersey.impl.model.parameter.CookieParamInjectableProvider;
import com.sun.jersey.impl.model.parameter.HeaderParamInjectableProvider;
import com.sun.jersey.impl.model.parameter.HttpContextInjectableProvider;
import com.sun.jersey.impl.model.parameter.MatrixParamInjectableProvider;
import com.sun.jersey.impl.model.parameter.PathParamInjectableProvider;
import com.sun.jersey.impl.model.parameter.QueryParamInjectableProvider;
import com.sun.jersey.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.jersey.impl.modelapi.validation.BasicValidator;
import com.sun.jersey.impl.template.TemplateFactory;
import com.sun.jersey.impl.uri.PathPattern;
import com.sun.jersey.impl.uri.PathTemplate;
import com.sun.jersey.impl.uri.rules.ResourceClassRule;
import com.sun.jersey.impl.uri.rules.ResourceObjectRule;
import com.sun.jersey.impl.uri.rules.RightHandPathRule;
import com.sun.jersey.impl.uri.rules.RootResourceClassesRule;
import com.sun.jersey.impl.wadl.WadlFactory;
import com.sun.jersey.impl.wadl.WadlResource;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.MessageBodyWorkers;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.inject.Inject;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import com.sun.jersey.spi.resource.InjectableProviderContext;
import com.sun.jersey.spi.resource.ResourceProviderFactory;
import com.sun.jersey.spi.service.ComponentContext;
import com.sun.jersey.spi.service.ComponentProvider;
import com.sun.jersey.spi.template.TemplateContext;
import com.sun.jersey.spi.uri.rules.UriRule;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebApplicationImpl
implements WebApplication {
    private static final Logger LOGGER = Logger.getLogger(WebApplicationImpl.class.getName());
    private final ConcurrentMap<Class, ResourceClass> metaClassMap = new ConcurrentHashMap<Class, ResourceClass>();
    private final ResourceProviderFactory resolverFactory;
    private final ThreadLocalHttpContext context;
    private boolean initiated;
    private ResourceConfig resourceConfig;
    private RootResourceClassesRule rootsRule;
    private InjectableProviderFactory injectableFactory;
    private MessageBodyFactory bodyFactory;
    private ComponentProvider provider;
    private ComponentProvider resourceProvider;
    private TemplateContext templateContext;
    private ExceptionMapperFactory exceptionFactory;
    private ResourceMethodDispatcherFactory dispatcherFactory;
    private ResourceContext resourceContext;
    private List<ContainerRequestFilter> requestFilters = new LinkedList<ContainerRequestFilter>();
    private List<ContainerResponseFilter> responseFilters = new LinkedList<ContainerResponseFilter>();
    private WadlFactory wadlFactory;

    public WebApplicationImpl() {
        this.resolverFactory = ResourceProviderFactory.getInstance();
        this.context = new ThreadLocalHttpContext();
        InvocationHandler requestHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)WebApplicationImpl.this.context.getRequest(), args);
            }
        };
        InvocationHandler uriInfoHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)WebApplicationImpl.this.context.getUriInfo(), args);
            }
        };
        this.injectableFactory = new InjectableProviderFactory();
        this.injectableFactory.add(new ContextInjectableProvider<InjectableProviderFactory>((Type)((Object)InjectableProviderContext.class), this.injectableFactory));
        final HashMap<Class, ThreadLocalHttpContext> m = new HashMap<Class, ThreadLocalHttpContext>();
        m.put(HttpContext.class, this.context);
        m.put(HttpHeaders.class, (ThreadLocalHttpContext)this.createProxy(HttpHeaders.class, requestHandler));
        m.put(UriInfo.class, (ThreadLocalHttpContext)this.createProxy(UriInfo.class, uriInfoHandler));
        m.put(ExtendedUriInfo.class, (ThreadLocalHttpContext)this.createProxy(ExtendedUriInfo.class, uriInfoHandler));
        m.put(Request.class, (ThreadLocalHttpContext)this.createProxy(Request.class, requestHandler));
        m.put(SecurityContext.class, (ThreadLocalHttpContext)this.createProxy(SecurityContext.class, requestHandler));
        this.injectableFactory.add((InjectableProvider)new InjectableProvider<Context, Type>(){

            public ComponentProvider.Scope getScope() {
                return ComponentProvider.Scope.Singleton;
            }

            public Injectable getInjectable(ComponentContext ic, Context a, Type c) {
                final Object o = m.get(c);
                if (o != null) {
                    return new Injectable(){

                        public Object getValue(HttpContext c) {
                            return o;
                        }
                    };
                }
                return null;
            }
        });
    }

    @Override
    public WebApplication clone() {
        WebApplicationImpl wa = new WebApplicationImpl();
        if (this.provider instanceof DefaultComponentProvider) {
            wa.initiate(this.resourceConfig, null);
        } else {
            AdaptingComponentProvider acp = (AdaptingComponentProvider)this.provider;
            wa.initiate(this.resourceConfig, acp.getAdaptedComponentProvider());
        }
        return wa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceClass getResourceClass(Class c) {
        assert (c != null);
        ResourceClass rc = (ResourceClass)this.metaClassMap.get(c);
        if (rc != null) {
            return rc;
        }
        ConcurrentMap<Class, ResourceClass> concurrentMap = this.metaClassMap;
        synchronized (concurrentMap) {
            rc = (ResourceClass)this.metaClassMap.get(c);
            if (rc != null) {
                return rc;
            }
            rc = this.newResourceClass(this.getAbstractResource(c));
            this.metaClassMap.put(c, rc);
        }
        rc.init(this.getComponentProvider(), this.getResourceComponentProvider(), this.resolverFactory);
        return rc;
    }

    private ResourceClass getResourceClass(AbstractResource ar) {
        ResourceClass rc = this.newResourceClass(ar);
        this.metaClassMap.put(ar.getResourceClass(), rc);
        rc.init(this.getComponentProvider(), this.getResourceComponentProvider(), this.resolverFactory);
        return rc;
    }

    private ResourceClass newResourceClass(AbstractResource ar) {
        assert (null != ar);
        BasicValidator validator = new BasicValidator();
        validator.validate(ar);
        boolean fatalIssueFound = false;
        for (ResourceModelIssue issue : validator.getIssueList()) {
            if (issue.isFatal()) {
                fatalIssueFound = true;
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.severe(issue.getMessage());
                continue;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning(issue.getMessage());
        }
        if (fatalIssueFound) {
            LOGGER.severe(ImplMessages.FATAL_ISSUES_FOUND_AT_RES_CLASS((Object)ar.getResourceClass().getName()));
            throw new ContainerException(ImplMessages.FATAL_ISSUES_FOUND_AT_RES_CLASS((Object)ar.getResourceClass().getName()));
        }
        return new ResourceClass(this.resourceConfig, this.getComponentProvider(), this.dispatcherFactory, (InjectableProviderContext)this.injectableFactory, ar, this.wadlFactory);
    }

    private AbstractResource getAbstractResource(Class c) {
        return IntrospectionModeller.createResource(c);
    }

    private void injectResources(Object o) {
        this.injectableFactory.injectResources(o);
    }

    @Override
    public void initiate(ResourceConfig resourceConfig) {
        this.initiate(resourceConfig, null);
    }

    @Override
    public void initiate(ResourceConfig resourceConfig, ComponentProvider _provider) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("ResourceConfig instance MUST NOT be null");
        }
        if (this.initiated) {
            throw new ContainerException(ImplMessages.WEB_APP_ALREADY_INITIATED());
        }
        this.initiated = true;
        this.provider = _provider == null ? new DefaultComponentProvider() : new AdaptingComponentProvider(_provider);
        this.resourceProvider = _provider == null ? new DefaultResourceComponentProvider() : new AdaptingResourceComponentProvider(_provider);
        this.resourceConfig = resourceConfig;
        this.verifyResourceConfig();
        this.resourceContext = new ResourceContext(){

            @Override
            public <T> T getResource(Class<T> c) {
                ResourceClass rc = WebApplicationImpl.this.getResourceClass(c);
                if (rc == null) {
                    LOGGER.severe("No resource class found for class " + c.getName());
                    throw new ContainerException("No resource class found for class " + c.getName());
                }
                Object instance = rc.provider.getInstance(WebApplicationImpl.this.resourceProvider, WebApplicationImpl.this.context);
                return instance != null ? (T)c.cast(instance) : null;
            }
        };
        ComponentProviderCache cpc = new ComponentProviderCache(this.injectableFactory, this.provider, resourceConfig.getProviderClasses(), resourceConfig.getProviderInstances());
        this.injectableFactory.add((InjectableProvider)new InjectableProvider<Inject, Type>(){

            public ComponentProvider.Scope getScope() {
                return ComponentProvider.Scope.Undefined;
            }

            public Injectable<Object> getInjectable(ComponentContext ic, Inject a, final Type c) {
                if (!(c instanceof Class)) {
                    return null;
                }
                final InjectableProviderFactory.AccessibleObjectContext aic = new InjectableProviderFactory.AccessibleObjectContext(ic.getAccesibleObject(), ic.getAnnotations());
                return new Injectable<Object>(){

                    public Object getValue(HttpContext context) {
                        try {
                            return WebApplicationImpl.this.provider.getInstance((ComponentContext)aic, ComponentProvider.Scope.Undefined, (Class)c);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "Could not get instance from component provider for type " + c, e);
                            throw new ContainerException("Could not get instance from component provider for type " + c, (Throwable)e);
                        }
                    }
                };
            }
        });
        this.injectableFactory.add(new ContextInjectableProvider<ResourceConfig>((Type)((Object)ResourceConfig.class), resourceConfig));
        this.injectableFactory.add(new ContextInjectableProvider<ResourceContext>((Type)((Object)ResourceContext.class), this.resourceContext));
        this.injectableFactory.configure(cpc);
        this.injectableFactory.add((InjectableProvider)new CookieParamInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new HeaderParamInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new HttpContextInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new MatrixParamInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new PathParamInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new QueryParamInjectableProvider());
        final ContextResolverFactory crf = new ContextResolverFactory(cpc, this.injectableFactory);
        this.templateContext = new TemplateFactory(cpc);
        this.injectableFactory.add(new ContextInjectableProvider<TemplateContext>((Type)((Object)TemplateContext.class), this.templateContext));
        this.exceptionFactory = new ExceptionMapperFactory(cpc);
        this.dispatcherFactory = new ResourceMethodDispatcherFactory(cpc);
        this.bodyFactory = new MessageBodyFactory(cpc);
        this.injectableFactory.add(new ContextInjectableProvider<MessageBodyFactory>((Type)((Object)MessageBodyWorkers.class), this.bodyFactory));
        Providers p = new Providers(){

            public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return WebApplicationImpl.this.bodyFactory.getMessageBodyReader(c, t, as, m);
            }

            public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return WebApplicationImpl.this.bodyFactory.getMessageBodyWriter(c, t, as, m);
            }

            public <T> ExceptionMapper<T> getExceptionMapper(Class<T> c) {
                if (Throwable.class.isAssignableFrom(c)) {
                    return WebApplicationImpl.this.exceptionFactory.find(c);
                }
                return null;
            }

            public <T> ContextResolver<T> getContextResolver(Class<T> ct, Class<?> ot, MediaType m) {
                return crf.resolve(ct, m);
            }
        };
        this.injectableFactory.add(new ContextInjectableProvider<6>((Type)((Object)Providers.class), p));
        this.bodyFactory.init();
        this.injectableFactory.add((InjectableProvider)new CookieParamInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new HeaderParamInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new HttpContextInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new MatrixParamInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new PathParamInjectableProvider());
        this.injectableFactory.add((InjectableProvider)new QueryParamInjectableProvider());
        FilterFactory ff = new FilterFactory(cpc);
        this.requestFilters.addAll(ff.getRequestFilters(resourceConfig.getProperty("com.sun.jersey.spi.container.ContainerRequestFilters")));
        this.requestFilters.addAll(cpc.getServices(ContainerRequestFilter.class));
        this.responseFilters.addAll(ff.getResponseFilters(resourceConfig.getProperty("com.sun.jersey.spi.container.ContainerResponseFilters")));
        this.responseFilters.addAll(cpc.getServices(ContainerResponseFilter.class));
        cpc.injectOnComponents();
        this.wadlFactory = new WadlFactory(resourceConfig);
        this.rootsRule = new RootResourceClassesRule(this.processRootResources(resourceConfig.getResourceClasses(), this.wadlFactory));
    }

    @Override
    public MessageBodyWorkers getMessageBodyWorkers() {
        return this.bodyFactory;
    }

    @Override
    public ComponentProvider getComponentProvider() {
        return this.provider;
    }

    @Override
    public ComponentProvider getResourceComponentProvider() {
        return this.resourceProvider;
    }

    @Override
    public void handleRequest(ContainerRequest request, ContainerResponseWriter responseWriter) throws IOException {
        ContainerResponse response = new ContainerResponse(this, request, responseWriter);
        this.handleRequest(request, response);
    }

    @Override
    public void handleRequest(ContainerRequest request, ContainerResponse response) throws IOException {
        block13: {
            try {
                WebApplicationContext localContext = new WebApplicationContext(this, request, response);
                this.context.set(localContext);
                StringBuilder path = new StringBuilder();
                path.append("/").append(localContext.getPath(false));
                if (!this.resourceConfig.getFeature("com.sun.jersey.config.feature.IgnoreMatrixParams")) {
                    path = this.stripMatrixParams(path);
                }
                if (!this.resourceConfig.getMediaTypeMappings().isEmpty() || !this.resourceConfig.getLanguageMappings().isEmpty()) {
                    this.uriConneg(path, request);
                }
                for (ContainerRequestFilter containerRequestFilter : this.requestFilters) {
                    request = containerRequestFilter.filter(request);
                }
                if (!this.rootsRule.accept(path, null, localContext)) {
                    throw new NotFoundException();
                }
                for (ContainerResponseFilter containerResponseFilter : this.responseFilters) {
                    response = containerResponseFilter.filter(response);
                }
            }
            catch (WebApplicationException e) {
                this.mapWebApplicationException(e, response);
            }
            catch (ContainerCheckedException e) {
                if (!this.mapException(e.getCause(), response)) {
                    throw e;
                }
            }
            catch (RuntimeException e) {
                if (this.mapException(e, response)) break block13;
                throw e;
            }
        }
        try {
            response.write();
        }
        catch (WebApplicationException e) {
            if (response.isCommitted()) {
                throw e;
            }
            this.mapWebApplicationException(e, response);
            response.write();
        }
    }

    @Override
    public HttpContext getThreadLocalHttpContext() {
        return this.context;
    }

    private void verifyResourceConfig() {
        Iterator i = this.resourceConfig.getProviderClasses().iterator();
        while (i.hasNext()) {
            Class pc = (Class)i.next();
            if (pc.isAnnotationPresent(Provider.class)) continue;
            LOGGER.warning("The class, " + pc + ", registered as a provider class " + "of the ResourceConfig is not annotationed with " + Provider.class + ". This class will be ignored");
            i.remove();
        }
    }

    private RulesMap<UriRule> processRootResources(Set<Class<?>> classes, WadlFactory wadlFactory) {
        if (classes.isEmpty()) {
            LOGGER.severe(ImplMessages.NO_ROOT_RES_IN_RES_CFG());
            throw new ContainerException(ImplMessages.NO_ROOT_RES_IN_RES_CFG());
        }
        RulesMap<UriRule> rulesMap = new RulesMap<UriRule>();
        HashSet<AbstractResource> rootResources = new HashSet<AbstractResource>();
        for (Class<?> c : classes) {
            AbstractResource ar = this.getAbstractResource(c);
            if (!ar.isRootResource()) {
                LOGGER.warning("The class, " + c + ", registered as a root resource class " + "of the ResourceConfig is not a root resource class" + ". This class will be ignored");
                continue;
            }
            int modifiers = c.getModifiers();
            if (Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers)) {
                LOGGER.warning("The " + c + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This class will be ignored");
                continue;
            }
            if (Modifier.isInterface(modifiers)) {
                LOGGER.warning("The " + c + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This interface will be ignored");
                continue;
            }
            ResourceClass r = this.getResourceClass(ar);
            rootResources.add(r.resource);
            PathTemplate t = new PathTemplate(r.resource.getUriPath().getValue(), r.resource.getUriPath().isEncode(), r.resource.getUriPath().isLimited());
            PathPattern p = new PathPattern((UriTemplate)t, r.resource.getUriPath().isLimited());
            rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), new ResourceClassRule((UriTemplate)t, c)));
        }
        this.createWadlResource(rootResources, rulesMap, wadlFactory);
        return rulesMap;
    }

    private void createWadlResource(Set<AbstractResource> rootResources, RulesMap<UriRule> rulesMap, WadlFactory wadlFactory) {
        Object wr = wadlFactory.createWadlResource(rootResources);
        if (wr == null) {
            return;
        }
        this.getResourceClass(WadlResource.class);
        PathTemplate t = new PathTemplate("application.wadl", false);
        PathPattern p = new PathPattern((UriTemplate)t, false);
        rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.jersey.config.feature.Redirect"), false, new ResourceObjectRule((UriTemplate)t, wr)));
    }

    private StringBuilder stripMatrixParams(StringBuilder path) {
        int e = path.indexOf(";");
        if (e == -1) {
            return path;
        }
        int s = 0;
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(path, s, e);
        } while ((s = path.indexOf("/", e + 1)) != -1 && (e = path.indexOf(";", s)) != -1);
        if (s != -1) {
            sb.append(path, s, path.length());
        }
        return sb;
    }

    private void uriConneg(StringBuilder path, ContainerRequest request) {
        int si = path.lastIndexOf("/");
        if (si == path.length() - 1) {
            si = path.lastIndexOf("/", si - 1);
        }
        if (si == -1) {
            si = 0;
        }
        MediaType accept = null;
        for (Map.Entry e : this.resourceConfig.getMediaTypeMappings().entrySet()) {
            int i = path.indexOf((String)e.getKey(), si);
            if (i <= 0 || path.charAt(i - 1) != '.') continue;
            int lengthWithExt = i + ((String)e.getKey()).length();
            if (lengthWithExt == path.length()) {
                accept = (MediaType)e.getValue();
                path.delete(i - 1, lengthWithExt);
                continue;
            }
            char charAfterExt = path.charAt(lengthWithExt);
            if ('/' != charAfterExt && '.' != charAfterExt) continue;
            accept = (MediaType)e.getValue();
            path.delete(i - 1, lengthWithExt);
        }
        if (accept != null) {
            MultivaluedMap<String, String> h = request.getRequestHeaders();
            h.putSingle((Object)"Accept", (Object)accept.toString());
        }
        String acceptLanguage = null;
        for (Map.Entry e : this.resourceConfig.getLanguageMappings().entrySet()) {
            int i = path.indexOf((String)e.getKey(), si);
            if (i <= 0 || path.charAt(i - 1) != '.') continue;
            acceptLanguage = (String)e.getValue();
            path.delete(i - 1, i + ((String)e.getKey()).length());
        }
        if (acceptLanguage != null) {
            MultivaluedMap<String, String> h = request.getRequestHeaders();
            h.putSingle((Object)"Accept-Language", acceptLanguage);
        }
    }

    private <T> T createProxy(Class<T> c, InvocationHandler i) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{c}, i);
    }

    private void mapWebApplicationException(WebApplicationException e, HttpResponseContext response) {
        if (e.getResponse().getEntity() != null) {
            WebApplicationImpl.onException(e, e.getResponse(), response);
        } else if (!this.mapException(e, response)) {
            WebApplicationImpl.onException(e, e.getResponse(), response);
        }
    }

    private boolean mapException(Throwable e, HttpResponseContext response) {
        ExceptionMapper em = this.exceptionFactory.find(e.getClass());
        if (em == null) {
            return false;
        }
        Response r = em.toResponse((Object)e);
        if (r == null) {
            return false;
        }
        WebApplicationImpl.onException(e, r, response);
        return true;
    }

    private static void onException(Throwable e, Response r, HttpResponseContext response) {
        if (r.getStatus() >= 500) {
            e.printStackTrace();
        }
        if (r.getStatus() >= 500 && r.getEntity() == null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            r = Response.status((int)r.getStatus()).entity((Object)sw.toString()).type("text/plain").build();
        }
        response.setResponse(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultResourceComponentProvider
    implements ComponentProvider {
        private DefaultResourceComponentProvider() {
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            T o = c.newInstance();
            return o;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            T o = contructor.newInstance(parameters);
            return o;
        }

        public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            return this.getInstance(scope, c);
        }

        public <T> T getInjectableInstance(T instance) {
            return instance;
        }

        public void inject(Object instance) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultComponentProvider
    implements ComponentProvider {
        private DefaultComponentProvider() {
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            T o = c.newInstance();
            WebApplicationImpl.this.injectResources(o);
            return o;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            T o = contructor.newInstance(parameters);
            WebApplicationImpl.this.injectResources(o);
            return o;
        }

        public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            return this.getInstance(scope, c);
        }

        public <T> T getInjectableInstance(T instance) {
            return instance;
        }

        public void inject(Object instance) {
            WebApplicationImpl.this.injectResources(instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdaptingResourceComponentProvider
    implements ComponentProvider {
        private final ComponentProvider cp;

        AdaptingResourceComponentProvider(ComponentProvider cp) {
            this.cp = cp;
        }

        public ComponentProvider getAdaptedComponentProvider() {
            return this.cp;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            Object o = this.cp.getInstance(scope, c);
            if (o == null) {
                o = c.newInstance();
            }
            return (T)o;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object o = this.cp.getInstance(scope, contructor, parameters);
            if (o == null) {
                o = contructor.newInstance(parameters);
            }
            return (T)o;
        }

        public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            Object o = this.cp.getInstance(cc, scope, c);
            if (o == null) {
                o = c.newInstance();
            }
            return (T)o;
        }

        public <T> T getInjectableInstance(T instance) {
            return (T)this.cp.getInjectableInstance(instance);
        }

        public void inject(Object instance) {
            this.cp.inject(instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AdaptingComponentProvider
    implements ComponentProvider {
        private final ComponentProvider cp;

        AdaptingComponentProvider(ComponentProvider cp) {
            this.cp = cp;
        }

        public ComponentProvider getAdaptedComponentProvider() {
            return this.cp;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            Object o = this.cp.getInstance(scope, c);
            if (o == null) {
                o = c.newInstance();
                WebApplicationImpl.this.injectResources(o);
            } else {
                WebApplicationImpl.this.injectResources(this.cp.getInjectableInstance(o));
            }
            return (T)o;
        }

        public <T> T getInstance(ComponentProvider.Scope scope, Constructor<T> contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object o = this.cp.getInstance(scope, contructor, parameters);
            if (o == null) {
                o = contructor.newInstance(parameters);
                WebApplicationImpl.this.injectResources(o);
            } else {
                WebApplicationImpl.this.injectResources(this.cp.getInjectableInstance(o));
            }
            return (T)o;
        }

        public <T> T getInstance(ComponentContext cc, ComponentProvider.Scope scope, Class<T> c) throws InstantiationException, IllegalAccessException {
            Object o = this.cp.getInstance(cc, scope, c);
            if (o == null) {
                o = c.newInstance();
                WebApplicationImpl.this.injectResources(o);
            } else {
                WebApplicationImpl.this.injectResources(this.cp.getInjectableInstance(o));
            }
            return (T)o;
        }

        public <T> T getInjectableInstance(T instance) {
            return (T)this.cp.getInjectableInstance(instance);
        }

        public void inject(Object instance) {
            this.cp.inject(instance);
            WebApplicationImpl.this.injectResources(this.cp.getInjectableInstance(instance));
        }
    }
}

