/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.application;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.impl.application.ComponentProviderCache;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFactory {
    private static final Logger LOGGER = Logger.getLogger(FilterFactory.class.getName());
    private final ComponentProviderCache cpc;

    FilterFactory(ComponentProviderCache cpc) {
        this.cpc = cpc;
    }

    public List<ContainerRequestFilter> getRequestFilters(Object o) {
        return this.getFilters(ContainerRequestFilter.class, o);
    }

    public List<ContainerResponseFilter> getResponseFilters(Object o) {
        return this.getFilters(ContainerResponseFilter.class, o);
    }

    private <T> List<T> getFilters(Class<T> c, Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof String) {
            return this.getFilters(c, DefaultResourceConfig.getElements(new String[]{(String)o}));
        }
        if (o instanceof String[]) {
            return this.getFilters(c, DefaultResourceConfig.getElements((String[])o));
        }
        if (o instanceof List) {
            return this.getFilters(c, (List)o);
        }
        LOGGER.severe("The filters, " + o.getClass().getName() + " declared for " + c.getName() + "MUST be of the type String[], String or List");
        return Collections.emptyList();
    }

    private <T> List<T> getFilters(Class<T> c, String[] classNames) {
        LinkedList f = new LinkedList();
        f.addAll(this.cpc.getInstances(c, classNames));
        return f;
    }

    private <T> List<T> getFilters(Class<T> c, List<?> l) {
        LinkedList<T> f = new LinkedList<T>();
        for (Object o : l) {
            if (!c.isInstance(o)) {
                LOGGER.severe("The filter, " + o.getClass().getName() + " MUST be an instance of " + c.getName() + ". The filter is ignored.");
                continue;
            }
            this.cpc.getComponentProvider().inject(o);
            f.add(c.cast(o));
        }
        return f;
    }
}

